from lxml import etree
from pathlib import Path
import argparse
def main():
   ap = argparse.ArgumentParser()
   ap.add_argument("--in", dest="inp", required=True, help="XML SOAP de entrada")
   ap.add_argument("--out", required=True, help="XML de salida (payload SII)")
   ap.add_argument("--tag", default="SuministroLRFacturasEmitidas",
                   help="Raíz SII a extraer (ej: SuministroLRFacturasEmitidas)")
   args = ap.parse_args()
   doc = etree.parse(args.inp)
   # Busca el nodo por nombre local (independiente del prefijo)
   nodes = doc.xpath(f"//*[local-name()='{args.tag}']")
   if not nodes:
       raise SystemExit(f"No encontré el nodo '{args.tag}' dentro del XML.")
   payload = nodes[0]
   out_bytes = etree.tostring(payload, xml_declaration=True, encoding="utf-8", pretty_print=True)
   Path(args.out).write_bytes(out_bytes)
   print(f"OK -> {args.out}")
if __name__ == "__main__":
   main()