# C:\Tools\SII\validador\debug_xsd.py
# Uso:
#   py debug_xsd.py --xml sii_payload.xml --schema SuministroLR.xsd
#
# Imprime el error COMPLETO del XSD (incluyendo "Expected is (...)") y el XPath del nodo.

import argparse
from lxml import etree

def main():
    ap = argparse.ArgumentParser()
    ap.add_argument("--xml", required=True)
    ap.add_argument("--schema", required=True)
    args = ap.parse_args()

    parser = etree.XMLParser(remove_blank_text=False, huge_tree=True)
    xml_doc = etree.parse(args.xml, parser)
    xsd_doc = etree.parse(args.schema, parser)
    schema = etree.XMLSchema(xsd_doc)

    ok = schema.validate(xml_doc)
    if ok:
        print("✅ XML VÁLIDO contra XSD")
        return

    print("❌ XML NO válido contra XSD")
    # Mostramos TODAS las entradas del error_log para ver "Expected is (...)"
    for i, e in enumerate(schema.error_log, 1):
        print(f"\n[{i}] Línea {e.line}, Col {e.column}")
        print(f"Tipo: {e.type_name}")
        print(f"Dominio: {e.domain_name}")
        print(f"Mensaje COMPLETO:\n{e.message}")

        # Intentar localizar el nodo por línea aproximada para sacar XPath + snippet
        try:
            # lxml mantiene sourceline en elementos
            target = None
            for el in xml_doc.iter():
                if getattr(el, "sourceline", None) == e.line:
                    target = el
                    break
            if target is not None:
                print(f"XPath aproximado: {xml_doc.getpath(target)}")
                print(f"Tag: {target.tag}")
        except Exception as ex:
            print(f"(No se pudo calcular XPath: {ex})")

if __name__ == "__main__":
    main()
