# Herramientas locales SII (sin certificado)

Incluye:
- `validate_sii_xsd.py`: Validador local de XML contra XSD oficiales (descarga + caché).
- `simulate_sii_response.py`: Simulador (MOCK) de respuesta SII para desarrollo sin AEAT.

## Requisitos
- Python 3.10+
- Instalar dependencias:
  - Windows: `py -m pip install -r requirements.txt`
  - macOS/Linux: `python3 -m pip install -r requirements.txt`

## 1) Validar un XML (local, sin certificado)
Ejemplo:
- Windows: `py validate_sii_xsd.py --xml Estructura_desde_Plantilla_SII.xml --schema SuministroLR.xsd`
- macOS/Linux: `python3 validate_sii_xsd.py --xml Estructura_desde_Plantilla_SII.xml --schema SuministroLR.xsd`

Los XSD se descargan a `./xsd_cache/` la primera vez.

## 2) Simular una respuesta SII (MOCK)
Genera un XML de respuesta de ejemplo con una línea por factura encontrada en el envío.

- Windows: `py simulate_sii_response.py --request Estructura_desde_Plantilla_SII.xml --out respuesta_mock.xml`
- macOS/Linux: `python3 simulate_sii_response.py --request Estructura_desde_Plantilla_SII.xml --out respuesta_mock.xml`

⚠️ Nota: el simulador es para **tests** y **desarrollo**. La respuesta real solo la devuelve AEAT al invocar el WebService (con certificado).
