<?php
require __DIR__ . '/../app/bootstrap.php';
require_login();
require __DIR__ . '/../app/layout.php';

$pdo = db();
$tenantId = (int)$_SESSION['user']['tenant_id'];
$tenant = $pdo->prepare("SELECT * FROM tenants WHERE id=?");
$tenant->execute([$tenantId]);
$tenant = $tenant->fetch();

page_header('Subida de Excel');
?>
<div class="card">
  <form method="post" action="<?= e(base_url()) ?>/run_job.php" enctype="multipart/form-data">
    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
    <p class="muted">Empresa: <b><?= e($tenant['name']) ?></b> · NIF: <b><?= e($tenant['nif']) ?></b></p>

    <label>Excel (Plantilla_SII_FacturasEmitidas.xlsx)</label>
    <input type="file" name="xlsx" accept=".xlsx" required>

    <label>Esquema XSD a validar</label>
    <select name="schema">
      <option value="SuministroLR.xsd">SuministroLR.xsd (recomendado)</option>
      <option value="SuministroInformacion.xsd">SuministroInformacion.xsd</option>
    </select>

    <button>Procesar</button>
    <a style="margin-left:10px" href="<?= e(base_url()) ?>/dashboard.php">Volver</a>
  </form>
</div>
<?php page_footer(); ?>
