<?php
require __DIR__ . '/../app/bootstrap.php';
require __DIR__ . '/../app/layout.php';

// Si ya está logueado, al dashboard
if (auth()) {
    redirect('dashboard.php');
}

$error = '';

if (($_SERVER['REQUEST_METHOD'] ?? 'GET') === 'POST') {
    // CSRF (compatible: _csrf o csrf)
    csrf_verify();

    $email = strtolower(trim($_POST['email'] ?? ''));
    $pass  = (string)($_POST['password'] ?? '');

    if ($email === '' || $pass === '') {
        $error = 'Introduce email y contraseña.';
    } else {
        try {
            $pdo = db();

            $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? LIMIT 1");
            $stmt->execute([$email]);
            $u = $stmt->fetch();

            if (!$u) {
                $error = 'Email o contraseña incorrectos, o usuario inactivo.';
            } else {
                $hash   = $u['password_hash'] ?? ($u['password'] ?? '');
                $active = (int)($u['is_active'] ?? 1);

                if ($active !== 1) {
                    $error = 'Email o contraseña incorrectos, o usuario inactivo.';
                } elseif (!$hash || !password_verify($pass, $hash)) {
                    $error = 'Email o contraseña incorrectos, o usuario inactivo.';
                } else {
                    // Login OK
                    if (function_exists('session_regenerate_id')) {
                        session_regenerate_id(true);
                    }

                    $_SESSION['user_id']   = (int)($u['id'] ?? 0);
                    $_SESSION['tenant_id'] = isset($u['tenant_id']) ? (int)$u['tenant_id'] : null;
                    $_SESSION['role']      = $u['role'] ?? 'user';
                    $_SESSION['email']     = $u['email'] ?? $email;

                    redirect('dashboard.php');
                }
            }
        } catch (Throwable $e) {
            $error = 'Error interno: ' . $e->getMessage();
        }
    }
}

page_header('Acceso');
?>
<div class="card">
  <form method="post" autocomplete="on">
    <?= csrf_field(); ?>

    <label>Email</label>
    <input name="email" type="email" required value="<?= e($_POST['email'] ?? '') ?>">

    <label>Contraseña</label>
    <input name="password" type="password" required>

    <?php if ($error): ?>
      <p style="color:#ff8080"><?= e($error) ?></p>
    <?php endif; ?>

    <button>Entrar</button>
  </form>
</div>
<?php page_footer(); ?>