<?php
require __DIR__ . '/../app/bootstrap.php';
require_login();
require __DIR__ . '/../app/layout.php';

$jobId = $_GET['id'] ?? '';
$pdo = db();
$st = $pdo->prepare("SELECT * FROM sii_jobs WHERE id=? AND tenant_id=?");
$st->execute([$jobId, (int)$_SESSION['user']['tenant_id']]);
$job = $st->fetch();
if (!$job) { http_response_code(404); echo "Job no encontrado"; exit; }

page_header('Resultado');
?>
<div class="card">
  <p><b>ID:</b> <?= e($job['id']) ?> · <b>Estado:</b> <?= e($job['status']) ?> · <b>Creado:</b> <?= e($job['created_at']) ?></p>
  <?php if ($job['status'] === 'ok'): ?>
    <p style="color:#7CFFB2">✅ Validación OK.</p>
  <?php else: ?>
    <p style="color:#ff8080">❌ Hubo errores. <?= e($job['error_message'] ?? '') ?></p>
  <?php endif; ?>

  <ul>
    <?php if (!empty($job['request_xml_path'])): ?>
      <li><a href="<?= e(base_url()) ?>/download.php?type=request&id=<?= e($job['id']) ?>">Descargar XML SOAP (request)</a></li>
    <?php endif; ?>
    <?php if (!empty($job['payload_xml_path'])): ?>
      <li><a href="<?= e(base_url()) ?>/download.php?type=payload&id=<?= e($job['id']) ?>">Descargar XML Payload (SII)</a></li>
    <?php endif; ?>
    <?php if (!empty($job['log_path'])): ?>
      <li><a href="<?= e(base_url()) ?>/download.php?type=log&id=<?= e($job['id']) ?>">Ver log</a></li>
    <?php endif; ?>
  </ul>

  <a href="<?= e(base_url()) ?>/history.php">Ver histórico</a>
</div>
<?php page_footer(); ?>
