<?php
// Ejecuta UNA VEZ para crear el admin inicial, y luego borra este archivo.
require __DIR__ . '/../app/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $email = strtolower(trim($_POST['email'] ?? ''));
  $pass  = $_POST['password'] ?? '';
  $tenantId = (int)($_POST['tenant_id'] ?? 1);

  if (!$email || !$pass) { echo "Email/contraseña requeridos."; exit; }

  $hash = password_hash($pass, PASSWORD_BCRYPT);
  $pdo = db();
  $pdo->prepare("INSERT INTO users (tenant_id,email,password_hash,role,is_active,created_at) VALUES (?,?,?,?,1,NOW())")
      ->execute([$tenantId, $email, $hash, 'admin']);

  echo "Admin creado. Ahora borra install_admin.php y entra en " . base_url() . "/login.php"";
  exit;
}

require __DIR__ . '/../app/layout.php';
page_header('Crear admin (legacy)');
?>
<div class="card">
  <p class="muted">Crea el admin inicial. <b>Borra este archivo después</b>.</p>
  <form method="post">
    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
    <label>Tenant ID (empresa)</label>
    <input name="tenant_id" value="1">
    <label>Email</label>
    <input name="email" type="email" required>
    <label>Contraseña</label>
    <input name="password" type="text" required>
    <button>Crear admin</button>
  </form>
</div>
<?php page_footer(); ?>
