<?php
require __DIR__ . '/../app/bootstrap.php';
require_login();
require __DIR__ . '/../app/layout.php';

$pdo = db();
$st = $pdo->prepare("SELECT id,status,schema_name,created_at,finished_at FROM sii_jobs WHERE tenant_id=? ORDER BY created_at DESC LIMIT 100");
$st->execute([(int)$_SESSION['user']['tenant_id']]);
$rows = $st->fetchAll();

page_header('Histórico');
?>
<div class="card">
  <table>
    <thead><tr><th>ID</th><th>Estado</th><th>Schema</th><th>Creado</th><th>Finalizado</th></tr></thead>
    <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td><a href="<?= e(base_url()) ?>/job.php?id=<?= e($r['id']) ?>"><?= e($r['id']) ?></a></td>
          <td><?= e($r['status']) ?></td>
          <td><?= e($r['schema_name']) ?></td>
          <td><?= e($r['created_at']) ?></td>
          <td><?= e($r['finished_at'] ?? '') ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
  <p><a href="<?= e(base_url()) ?>/dashboard.php">Volver</a></p>
</div>
<?php page_footer(); ?>
