<?php
require __DIR__ . '/../app/bootstrap.php';
require_login();

$type = $_GET['type'] ?? '';
$jobId = $_GET['id'] ?? '';

$pdo = db();
$st = $pdo->prepare("SELECT * FROM sii_jobs WHERE id=? AND tenant_id=?");
$st->execute([$jobId, (int)$_SESSION['user']['tenant_id']]);
$job = $st->fetch();
if (!$job) { http_response_code(404); echo "Job no encontrado"; exit; }

$path = null; $name = null; $mime = 'text/plain; charset=utf-8';
if ($type === 'request') { $path = $job['request_xml_path']; $name = $jobId . '_request.xml'; $mime='application/xml'; }
if ($type === 'payload') { $path = $job['payload_xml_path']; $name = $jobId . '_payload.xml'; $mime='application/xml'; }
if ($type === 'log')     { $path = $job['log_path'];        $name = $jobId . '.log';        $mime='text/plain; charset=utf-8'; }

if (!$path || !file_exists($path)) { http_response_code(404); echo "Archivo no disponible"; exit; }

header('Content-Type: ' . $mime);
header('Content-Disposition: inline; filename="' . $name . '"');
readfile($path);
