<?php
require __DIR__ . '/../../app/bootstrap.php';
require_admin();
require __DIR__ . '/../../app/layout.php';

$pdo = db();
$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $tenantId = (int)($_POST['tenant_id'] ?? 0);
  $email = strtolower(trim($_POST['email'] ?? ''));
  $pass  = $_POST['password'] ?? '';
  $role  = $_POST['role'] ?? 'client';
  if (!in_array($role, ['admin','client'], true)) $role = 'client';

  if ($tenantId && $email && $pass) {
    $hash = password_hash($pass, PASSWORD_BCRYPT);
    $st = $pdo->prepare("INSERT INTO users (tenant_id,email,password_hash,role,is_active,created_at) VALUES (?,?,?,?,1,NOW())");
    $st->execute([$tenantId,$email,$hash,$role]);
    $msg = 'Usuario creado.';
  } else $msg = 'Rellena tenant, email y contraseña.';
}

$tenants = $pdo->query("SELECT id,name FROM tenants ORDER BY name")->fetchAll();
$users = $pdo->query("SELECT u.id,u.email,u.role,u.is_active,u.created_at,t.name as tenant_name
                      FROM users u JOIN tenants t ON t.id=u.tenant_id ORDER BY u.id DESC LIMIT 200")->fetchAll();

page_header('Usuarios');
?>
<div class="card">
  <form method="post">
    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
    <div class="row">
      <div>
        <label>Empresa</label>
        <select name="tenant_id" required>
          <option value="">--</option>
          <?php foreach ($tenants as $t): ?>
            <option value="<?= e((string)$t['id']) ?>"><?= e($t['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Rol</label>
        <select name="role">
          <option value="client">client</option>
          <option value="admin">admin</option>
        </select>
      </div>
    </div>
    <div class="row">
      <div>
        <label>Email</label>
        <input name="email" type="email" required>
      </div>
      <div>
        <label>Contraseña</label>
        <input name="password" type="text" required>
      </div>
    </div>
    <button>Crear</button>
    <?php if ($msg): ?><p class="muted"><?= e($msg) ?></p><?php endif; ?>
  </form>
</div>

<div class="card">
  <table>
    <thead><tr><th>ID</th><th>Empresa</th><th>Email</th><th>Rol</th><th>Activo</th><th>Creado</th></tr></thead>
    <tbody>
      <?php foreach ($users as $u): ?>
      <tr>
        <td><?= e((string)$u['id']) ?></td>
        <td><?= e($u['tenant_name']) ?></td>
        <td><?= e($u['email']) ?></td>
        <td><?= e($u['role']) ?></td>
        <td><?= e((string)$u['is_active']) ?></td>
        <td><?= e($u['created_at']) ?></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php page_footer(); ?>
