<?php
require __DIR__ . '/../../app/bootstrap.php';
require_admin();
require __DIR__ . '/../../app/layout.php';

$pdo = db();
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $name = trim($_POST['name'] ?? '');
  $nif  = strtoupper(trim($_POST['nif'] ?? ''));
  if ($name && $nif) {
    $st = $pdo->prepare("INSERT INTO tenants (name,nif,created_at) VALUES (?,?,NOW())");
    $st->execute([$name,$nif]);
    $msg = 'Empresa creada.';
  } else $msg = 'Rellena nombre y NIF.';
}

$rows = $pdo->query("SELECT * FROM tenants ORDER BY id DESC")->fetchAll();

page_header('Empresas');
?>
<div class="card">
  <form method="post">
    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
    <div class="row">
      <div>
        <label>Nombre</label>
        <input name="name" required>
      </div>
      <div>
        <label>NIF</label>
        <input name="nif" required>
      </div>
    </div>
    <button>Crear</button>
    <?php if ($msg): ?><p class="muted"><?= e($msg) ?></p><?php endif; ?>
  </form>
</div>

<div class="card">
  <table>
    <thead><tr><th>ID</th><th>Empresa</th><th>NIF</th><th>Creada</th></tr></thead>
    <tbody>
      <?php foreach ($rows as $r): ?>
      <tr><td><?= e((string)$r['id']) ?></td><td><?= e($r['name']) ?></td><td><?= e($r['nif']) ?></td><td><?= e($r['created_at']) ?></td></tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php page_footer(); ?>
