<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';
function page_header(string $title): void { ?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= e($title) ?></title>
  <style>
    body{font-family:system-ui,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#0b0f16;color:#eaeef7}
    a{color:#7ab6ff}
    .wrap{max-width:1100px;margin:0 auto;padding:18px}
    .card{background:#121a26;border:1px solid #1e2a3d;border-radius:14px;padding:16px;margin:14px 0}
    input,select{width:100%;padding:10px;border-radius:10px;border:1px solid #2a3a54;background:#0e1522;color:#eaeef7}
    label{display:block;margin:10px 0 6px}
    button{padding:10px 14px;border:0;border-radius:10px;background:#2b7cff;color:#fff;cursor:pointer}
    button.secondary{background:#2a3a54}
    table{width:100%;border-collapse:collapse}
    th,td{padding:10px;border-bottom:1px solid #1e2a3d;text-align:left;vertical-align:top}
    .top{display:flex;justify-content:space-between;gap:12px;align-items:center}
    .badge{display:inline-block;padding:4px 8px;border-radius:999px;background:#1e2a3d}
    .muted{color:#a7b3c6}
    .row{display:grid;grid-template-columns:1fr 1fr;gap:14px}
    @media(max-width:800px){.row{grid-template-columns:1fr}.top{flex-direction:column;align-items:flex-start}}
  </style>
</head>
<body>
  <div class="wrap">
    <div class="top">
      <div>
        <div class="muted">SII Multiempresa</div>
        <h1 style="margin:6px 0 0"><?= e($title) ?></h1>
      </div>
      <div>
        <?php if (!empty($_SESSION['user'])): ?>
          <span class="badge"><?= e($_SESSION['user']['tenant_name']) ?></span>
          <span class="badge"><?= e($_SESSION['user']['email']) ?> · <?= e($_SESSION['user']['role']) ?></span>
          <a style="margin-left:10px" href="<?= e(base_url()) ?>/logout.php">Salir</a>
        <?php endif; ?>
      </div>
    </div>
<?php }

function page_footer(): void { ?>
  </div>
</body>
</html>
<?php } ?>
