<?php
declare(strict_types=1);
require __DIR__ . '/bootstrap.php';

function password_hash_app(string $plain): string {
  return password_hash($plain, PASSWORD_BCRYPT);
}

function login(string $email, string $pass): bool {
  $pdo = db();
  $st = $pdo->prepare("SELECT u.id,u.tenant_id,u.email,u.password_hash,u.role,u.is_active,t.name as tenant_name
                       FROM users u JOIN tenants t ON t.id=u.tenant_id
                       WHERE u.email=? LIMIT 1");
  $st->execute([$email]);
  $u = $st->fetch();
  if (!$u) return false;
  if ((int)$u['is_active'] !== 1) return false;
  if (!password_verify($pass, $u['password_hash'])) return false;
  $_SESSION['user'] = [
    'id' => (int)$u['id'],
    'tenant_id' => (int)$u['tenant_id'],
    'email' => $u['email'],
    'role' => $u['role'],
    'tenant_name' => $u['tenant_name'],
  ];
  return true;
}

function logout(): void {
  $_SESSION = [];
  if (ini_get('session.use_cookies')) {
    $p = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $p['path'], $p['domain'], $p['secure'], $p['httponly']);
  }
  session_destroy();
}
