<h2>Subir foto</h2>

<div class="upload-layout">
    <section class="card">
        <div class="card-header">
            <h3>Nueva publicación</h3>
            <span class="badge badge-count">📸</span>
        </div>
        
        <form method="post" action="<?php echo htmlspecialchars(base_url('/photos/upload')); ?>" enctype="multipart/form-data" class="upload-form">
            <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
            
            <!-- Área de subida de imagen -->
            <div class="upload-area" id="uploadArea">
                <div class="upload-placeholder">
                    <div class="upload-icon">📁</div>
                    <p>Haz clic para seleccionar una imagen</p>
                    <p class="upload-subtitle">JPG, PNG o WEBP (máx. 5MB)</p>
                </div>
                <input type="file" name="photo" id="photoInput" accept="image/jpeg,image/png,image/webp" required class="hidden-input">
                <div class="image-preview hidden" id="imagePreview">
                    <img id="previewImage" src="" alt="Vista previa">
                    <button type="button" class="btn btn-ghost btn-sm" id="removeImage">✗ Cambiar imagen</button>
                </div>
            </div>

            <!-- Campos del formulario -->
            <div class="form-fields">
                <div class="form-group">
                    <label for="textInput" class="form-label">Texto (opcional)</label>
                    <textarea 
                        name="text" 
                        id="textInput" 
                        maxlength="500" 
                        placeholder="¿Qué quieres compartir hoy?"
                        class="form-textarea"
                        rows="3"
                    ></textarea>
                    <div class="char-counter">
                        <span id="charCount">0</span>/500 caracteres
                    </div>
                </div>

                <div class="form-group">
                    <label for="visibilitySelect" class="form-label">Visibilidad</label>
                    <select name="visibility" id="visibilitySelect" class="form-select">
                        <option value="friends" selected>👥 Solo amigos</option>
                        <option value="private">🔒 Privado (solo tú)</option>
                    </select>
                </div>

                <div class="form-actions">
                    <a href="javascript:history.back()" class="btn btn-ghost">Cancelar</a>
                    <button type="submit" class="btn btn-primary" id="submitBtn">
                        <span class="btn-icon">📤</span>
                        Subir foto
                    </button>
                </div>
            </div>
        </form>
    </section>
</div>

<style>
.upload-layout {
    max-width: 600px;
    margin: 0 auto;
}

.upload-form {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.upload-area {
    border: 2px dashed #4b5563;
    border-radius: 12px;
    padding: 2rem;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
    background: #2d2d2d;
    position: relative;
    overflow: hidden;
}

.upload-area:hover {
    border-color: #6366f1;
    background: #374151;
}

.upload-area.dragover {
    border-color: #10b981;
    background: #064e3b;
}

.upload-placeholder {
    color: #9ca3af;
}

.upload-icon {
    font-size: 3rem;
    margin-bottom: 1rem;
    opacity: 0.7;
}

.upload-subtitle {
    font-size: 0.875rem;
    margin: 0.5rem 0 0 0;
    color: #6b7280;
}

.hidden-input {
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    opacity: 0;
    cursor: pointer;
}

.image-preview {
    position: relative;
    max-width: 300px;
    margin: 0 auto;
}

#previewImage {
    width: 100%;
    height: auto;
    border-radius: 8px;
    max-height: 300px;
    object-fit: contain;
}

#removeImage {
    margin-top: 0.5rem;
}

.form-fields {
    display: flex;
    flex-direction: column;
    gap: 1.25rem;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.form-label {
    color: #cbd5e1;
    font-weight: 500;
    font-size: 0.9rem;
}

.form-textarea {
    background: #2b3138;
    border: 1px solid #3f4752;
    border-radius: 8px;
    padding: 12px;
    color: #f8fafc;
    font-family: inherit;
    resize: vertical;
    transition: all 0.2s ease;
    font-size: 0.9rem;
}

.form-textarea:focus {
    outline: none;
    border-color: #6366f1;
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.form-select {
    background: #2b3138;
    border: 1px solid #3f4752;
    border-radius: 8px;
    padding: 12px;
    color: #f8fafc;
    cursor: pointer;
    transition: all 0.2s ease;
    font-size: 0.9rem;
}

.form-select:focus {
    outline: none;
    border-color: #6366f1;
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.char-counter {
    text-align: right;
    font-size: 0.75rem;
    color: #64748b;
}

.char-counter.warning {
    color: #f59e0b;
}

.char-counter.error {
    color: #ef4444;
}

.form-actions {
    display: flex;
    gap: 12px;
    justify-content: flex-end;
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid #2b3138;
}

/* BOTONES CONSISTENTES CON EL RESTO DE LA APLICACIÓN */
.btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border-radius: 8px;
    font-weight: 500;
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: all 0.2s ease;
    font-size: 0.9rem;
    min-width: 120px;
    justify-content: center;
}

.btn-primary {
    background: #6366f1;
    color: white;
}

.btn-primary:hover:not(:disabled) {
    background: #4f46e5;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

.btn-primary:disabled {
    background: #4b5563;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}

.btn-ghost {
    background: transparent;
    color: #94a3b8;
    border: 1px solid #2b3138;
}

.btn-ghost:hover {
    background: rgba(255,255,255,0.05);
    color: #f8fafc;
    border-color: #3f4752;
}

.btn-sm {
    padding: 8px 16px;
    font-size: 0.8rem;
    min-width: auto;
}

.btn-icon {
    font-size: 1rem;
}

.hidden {
    display: none;
}

/* Estados de carga */
.btn.loading {
    opacity: 0.7;
    cursor: not-allowed;
}

.btn.loading .btn-icon {
    animation: spin 1s linear infinite;
}

@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

/* Card styles consistentes */
.card {
    background: #1a1d23;
    border: 1px solid #2b3138;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    border-bottom: 1px solid #2b3138;
    padding-bottom: 12px;
}

.card-header h3 {
    color: #f8fafc;
    font-size: 1.25rem;
    font-weight: 600;
    margin: 0;
}

.badge-count {
    background: #6366f1;
    color: white;
    padding: 4px 8px;
    border-radius: 6px;
    font-size: 0.8rem;
}

/* Responsive */
@media (max-width: 768px) {
    .upload-layout {
        max-width: 100%;
    }
    
    .upload-area {
        padding: 1.5rem;
    }
    
    .form-actions {
        flex-direction: column;
    }
    
    .form-actions .btn {
        width: 100%;
    }
    
    .card {
        padding: 20px;
    }
}

@media (max-width: 480px) {
    .card {
        padding: 16px;
    }
    
    .card-header h3 {
        font-size: 1.1rem;
    }
    
    .upload-area {
        padding: 1rem;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const uploadArea = document.getElementById('uploadArea');
    const photoInput = document.getElementById('photoInput');
    const imagePreview = document.getElementById('imagePreview');
    const previewImage = document.getElementById('previewImage');
    const removeImageBtn = document.getElementById('removeImage');
    const textInput = document.getElementById('textInput');
    const charCount = document.getElementById('charCount');
    const submitBtn = document.getElementById('submitBtn');
    const charCounter = charCount.parentElement;

    // Manejar arrastrar y soltar
    uploadArea.addEventListener('dragover', (e) => {
        e.preventDefault();
        uploadArea.classList.add('dragover');
    });

    uploadArea.addEventListener('dragleave', () => {
        uploadArea.classList.remove('dragover');
    });

    uploadArea.addEventListener('drop', (e) => {
        e.preventDefault();
        uploadArea.classList.remove('dragover');
        if (e.dataTransfer.files.length > 0) {
            handleFileSelect(e.dataTransfer.files[0]);
        }
    });

    // Manejar clic en el área de upload
    uploadArea.addEventListener('click', () => {
        photoInput.click();
    });

    // Manejar cambio de archivo
    photoInput.addEventListener('change', (e) => {
        if (e.target.files.length > 0) {
            handleFileSelect(e.target.files[0]);
        }
    });

    // Manejar remover imagen
    removeImageBtn.addEventListener('click', (e) => {
        e.stopPropagation();
        resetImagePreview();
    });

    // Contador de caracteres
    textInput.addEventListener('input', () => {
        const count = textInput.value.length;
        charCount.textContent = count;
        
        // Cambiar color según el conteo
        charCounter.classList.remove('warning', 'error');
        if (count > 400) {
            charCounter.classList.add('warning');
        }
        if (count > 490) {
            charCounter.classList.add('error');
        }
    });

    // Validación antes de enviar
    document.querySelector('.upload-form').addEventListener('submit', (e) => {
        if (!photoInput.files.length) {
            e.preventDefault();
            alert('Por favor, selecciona una imagen para subir.');
            return;
        }

        // Mostrar estado de carga
        submitBtn.disabled = true;
        submitBtn.classList.add('loading');
        submitBtn.innerHTML = '<span class="btn-icon">⏳</span>Subiendo...';
    });

    function handleFileSelect(file) {
        // Validar tipo de archivo
        const validTypes = ['image/jpeg', 'image/png', 'image/webp'];
        if (!validTypes.includes(file.type)) {
            alert('Por favor, selecciona una imagen válida (JPG, PNG o WEBP).');
            return;
        }

        // Validar tamaño (5MB)
        if (file.size > 5 * 1024 * 1024) {
            alert('La imagen es demasiado grande. Máximo 5MB permitidos.');
            return;
        }

        // Mostrar vista previa
        const reader = new FileReader();
        reader.onload = (e) => {
            previewImage.src = e.target.result;
            uploadArea.querySelector('.upload-placeholder').classList.add('hidden');
            imagePreview.classList.remove('hidden');
        };
        reader.readAsDataURL(file);
    }

    function resetImagePreview() {
        photoInput.value = '';
        previewImage.src = '';
        imagePreview.classList.add('hidden');
        uploadArea.querySelector('.upload-placeholder').classList.remove('hidden');
    }
});
</script>