<?php 
// Verificar si la función user() existe y obtener el usuario
$u = function_exists('user') ? user() : null;
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin - Nebusa</title>
  <link rel="stylesheet" href="<?php echo htmlspecialchars(asset_url('assets/css/app.css')); ?>">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --primary: #6366f1;
      --primary-dark: #4f46e5;
      --secondary: #f8fafc;
      --dark: #0f172a;
      --dark-light: #1e293b;
      --text: #334155;
      --text-light: #64748b;
      --border: #e2e8f0;
      --success: #10b981;
      --warning: #f59e0b;
      --danger: #ef4444;
      --radius: 12px;
      --shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
      --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
    }
    
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
      color: #f8fafc;
      min-height: 100vh;
      line-height: 1.6;
    }
    
    .topbar {
      background: rgba(15, 23, 42, 0.95);
      backdrop-filter: blur(10px);
      border-bottom: 1px solid rgba(255, 255, 255, 0.1);
      padding: 1rem 0;
      position: sticky;
      top: 0;
      z-index: 100;
    }
    
    .topbar .container {
      max-width: 1400px;
      margin: 0 auto;
      padding: 0 1.5rem;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    
    .brand {
      font-size: 1.75rem;
      font-weight: 700;
      background: linear-gradient(135deg, #6366f1, #8b5cf6);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }
    
    .topbar nav {
      display: flex;
      align-items: center;
      gap: 1rem;
    }
    
    .topbar nav a, .topbar nav button {
      color: #cbd5e1;
      text-decoration: none;
      font-weight: 500;
      font-size: 0.9rem;
      transition: all 0.2s ease;
      padding: 0.5rem 0.75rem;
      border-radius: 8px;
    }
    
    .topbar nav a:hover, .topbar nav button:hover {
      color: #f8fafc;
      background: rgba(255, 255, 255, 0.05);
    }
    
    .admin-nav-link {
      background: rgba(99, 102, 241, 0.1);
      border: 1px solid rgba(99, 102, 241, 0.3);
      color: #6366f1;
      font-weight: 600;
    }
    
    .admin-nav-link:hover {
      background: rgba(99, 102, 241, 0.2);
      transform: translateY(-1px);
    }
    
    .role-badge {
      padding: 2px 8px;
      border-radius: 6px;
      font-size: 0.7rem;
      font-weight: 600;
      margin-left: 6px;
    }
    
    .role-admin {
      background: linear-gradient(135deg, #ef4444, #dc2626);
      color: white;
    }
    
    .role-moderator {
      background: linear-gradient(135deg, #f59e0b, #d97706);
      color: white;
    }
    
    .linklike {
      background: none;
      border: none;
      cursor: pointer;
      font: inherit;
    }
    
    .container {
      max-width: 1400px;
      margin: 0 auto;
      padding: 0 1.5rem;
    }
    
    main.container {
      padding-top: 2rem;
      padding-bottom: 2rem;
      min-height: calc(100vh - 140px);
    }
    
    .flash {
      background: var(--primary);
      color: white;
      padding: 1rem 1.5rem;
      border-radius: var(--radius);
      margin-bottom: 2rem;
      box-shadow: var(--shadow);
      animation: slideIn 0.3s ease;
    }
    
    @keyframes slideIn {
      from { opacity: 0; transform: translateY(-10px); }
      to { opacity: 1; transform: translateY(0); }
    }
    
    @media (max-width: 768px) {
      .topbar .container {
        flex-direction: column;
        gap: 1rem;
      }
      
      .topbar nav {
        flex-wrap: wrap;
        justify-content: center;
        gap: 0.75rem;
      }
      
      .topbar nav a, .topbar nav button {
        font-size: 0.85rem;
        padding: 0.4rem 0.6rem;
      }
    }
  </style>
</head>
<body>
<header class="topbar">
  <div class="container">
    <div class="brand">Nebusa Admin</div>
    <nav>
      <a href="<?php echo htmlspecialchars(base_url('/')); ?>">← Volver al sitio</a>
      
      <?php if (function_exists('is_admin') && is_admin()): ?>
        <a href="<?php echo htmlspecialchars(base_url('/admin')); ?>" class="admin-nav-link">
          Dashboard
        </a>
        <a href="<?php echo htmlspecialchars(base_url('/admin/users')); ?>" class="admin-nav-link">
          Usuarios
        </a>
        <a href="<?php echo htmlspecialchars(base_url('/admin/photos')); ?>" class="admin-nav-link">
          Fotos
        </a>
        <a href="<?php echo htmlspecialchars(base_url('/admin/reports')); ?>" class="admin-nav-link">
          Reportes
        </a>
        <a href="<?php echo htmlspecialchars(base_url('/admin/system/logs')); ?>" class="admin-nav-link">
          Logs
        </a>
        <span class="role-badge role-admin">Admin</span>
      <?php elseif (function_exists('is_moderator') && is_moderator()): ?>
        <a href="<?php echo htmlspecialchars(base_url('/moderator')); ?>" class="admin-nav-link">
          Dashboard
        </a>
        <a href="<?php echo htmlspecialchars(base_url('/moderator/reports')); ?>" class="admin-nav-link">
          Reportes
        </a>
        <a href="<?php echo htmlspecialchars(base_url('/moderator/photos')); ?>" class="admin-nav-link">
          Fotos
        </a>
        <span class="role-badge role-moderator">Mod</span>
      <?php endif; ?>
      
      <form method="post" action="<?php echo htmlspecialchars(base_url('/logout')); ?>" style="display:inline;">
        <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
        <button type="submit" class="linklike">Salir</button>
      </form>
    </nav>
  </div>
</header>
<main class="container">
<?php 
// Verificar si la función get_flash() existe antes de usarla
if (function_exists('get_flash') && $msg = get_flash()): ?>
  <div class="flash"><?php echo htmlspecialchars($msg, ENT_QUOTES, 'UTF-8'); ?></div>
<?php endif; ?>