<?php 
// Verificar si la función user() existe y obtener el usuario
$u = function_exists('user') ? user() : null;

// Detectar si estamos en el panel de administración
$is_admin_panel = strpos($_SERVER['REQUEST_URI'] ?? '', '/admin') !== false || 
                  strpos($_SERVER['REQUEST_URI'] ?? '', '/moderator') !== false;

// Verificar roles - método directo
$is_admin = false;
$is_moderator = false;

if (isset($u) && $u) {
    // Si es un objeto, intentar diferentes métodos para acceder al role
    if (is_object($u)) {
        // Método 1: Verificar propiedad role directamente
        if (isset($u->role)) {
            $is_admin = $u->role === 'admin';
            $is_moderator = $u->role === 'moderator';
        }
        // Método 2: Verificar con método getter
        else if (method_exists($u, 'getRole')) {
            $role = $u->getRole();
            $is_admin = $role === 'admin';
            $is_moderator = $role === 'moderator';
        }
        // Método 3: Verificar con método hasRole
        else if (method_exists($u, 'hasRole')) {
            $is_admin = $u->hasRole('admin');
            $is_moderator = $u->hasRole('moderator');
        }
    }
    // Si es un array
    else if (is_array($u)) {
        if (isset($u['role'])) {
            $is_admin = $u['role'] === 'admin';
            $is_moderator = $u['role'] === 'moderator';
        }
    }
}
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Nebusa</title>
  <link rel="stylesheet" href="<?php echo htmlspecialchars(asset_url('assets/css/app.css')); ?>">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --primary: #6366f1;
      --primary-dark: #4f46e5;
      --secondary: #f8fafc;
      --dark: #0f172a;
      --dark-light: #1e293b;
      --text: #334155;
      --text-light: #64748b;
      --border: #e2e8f0;
      --success: #10b981;
      --warning: #f59e0b;
      --danger: #ef4444;
      --radius: 12px;
      --shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
      --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
    }
    
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
      color: #f8fafc;
      min-height: 100vh;
      line-height: 1.6;
    }
    
    .topbar {
      background: rgba(15, 23, 42, 0.8);
      backdrop-filter: blur(10px);
      border-bottom: 1px solid rgba(255, 255, 255, 0.1);
      padding: 1rem 0;
      position: sticky;
      top: 0;
      z-index: 100;
    }
    
    .topbar .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 0 1.5rem;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    
    .brand {
      font-size: 1.75rem;
      font-weight: 700;
      background: linear-gradient(135deg, #6366f1, #8b5cf6);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }
    
    .topbar nav {
      display: flex;
      align-items: center;
      gap: 1rem;
    }
    
    .topbar nav a, .topbar nav button {
      color: #cbd5e1;
      text-decoration: none;
      font-weight: 500;
      font-size: 0.9rem;
      transition: all 0.2s ease;
      padding: 0.5rem 0.75rem;
      border-radius: 8px;
      position: relative;
      white-space: nowrap;
    }
    
    .topbar nav a:hover, .topbar nav button:hover {
      color: #f8fafc;
      background: rgba(255, 255, 255, 0.05);
    }
    
    .topbar nav a.btn {
      background: var(--primary);
      color: white;
      padding: 0.5rem 1.25rem;
      border-radius: 8px;
    }
    
    .topbar nav a.btn:hover {
      background: var(--primary-dark);
      transform: translateY(-1px);
      box-shadow: var(--shadow);
    }
    
    .bell { 
      position: relative;
      display: inline-flex;
      align-items: center;
    }
    
    .bell-icon { 
      display: flex;
      align-items: center;
      justify-content: center;
      width: 40px;
      height: 40px;
      border-radius: 8px;
      transition: all 0.2s ease;
      color: #fcd34d;
      text-decoration: none;
    }
    
    .bell-icon:hover {
      color: #fde047;
      background: rgba(252, 211, 77, 0.1);
      transform: scale(1.1);
    }
    
    .bell-svg {
      width: 20px;
      height: 20px;
      fill: currentColor;
    }
    
    .topbar .bell .badge {
      position: absolute;
      top: -6px;
      right: -6px;
      background: var(--danger);
      color: white;
      font-size: 0.7rem;
      font-weight: 600;
      border-radius: 10px;
      padding: 2px 6px;
      min-width: 18px;
      text-align: center;
      box-shadow: 0 2px 4px rgba(0,0,0,0.2);
      z-index: 1001;
    }
    
    .notif-dropdown {
      position: absolute;
      right: 0;
      top: 100%;
      width: 420px;
      max-width: 90vw;
      background: rgba(30, 41, 59, 0.95);
      backdrop-filter: blur(20px);
      border: 1px solid rgba(255, 255, 255, 0.1);
      border-radius: 12px;
      box-shadow: var(--shadow-lg);
      display: none;
      z-index: 1000;
      margin-top: 8px;
      overflow: hidden;
    }
    
    .notif-dropdown.show {
      display: block;
      animation: fadeIn 0.2s ease;
    }
    
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(-10px); }
      to { opacity: 1; transform: translateY(0); }
    }
    
    .notif-dropdown header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 1rem 1.25rem;
      border-bottom: 1px solid rgba(255, 255, 255, 0.1);
      font-weight: 600;
      background: rgba(15, 23, 42, 0.5);
    }
    
    .notif-dropdown ul {
      list-style: none;
      margin: 0;
      padding: 0;
      max-height: 400px;
      overflow-y: auto;
    }
    
    .notif-item {
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      padding: 1rem 1.25rem;
      border-bottom: 1px solid rgba(255, 255, 255, 0.05);
      transition: background 0.2s ease;
      gap: 0.75rem;
    }
    
    .notif-item:hover {
      background: rgba(255, 255, 255, 0.05);
    }
    
    .notif-item:last-child {
      border-bottom: none;
    }
    
    .notif-content {
      flex: 1;
      min-width: 0;
      cursor: pointer;
    }
    
    .notif-text {
      font-size: 0.9rem;
      line-height: 1.4;
      margin-bottom: 0.25rem;
    }
    
    .notif-time {
      font-size: 0.75rem;
      color: #94a3b8;
    }
    
    .notif-actions {
      display: flex;
      gap: 0.5rem;
      opacity: 0;
      transition: opacity 0.2s ease;
    }
    
    .notif-item:hover .notif-actions {
      opacity: 1;
    }
    
    .notif-delete {
      background: rgba(239, 68, 68, 0.2);
      border: none;
      color: #ef4444;
      width: 28px;
      height: 28px;
      border-radius: 6px;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      font-size: 0.8rem;
      transition: all 0.2s ease;
    }
    
    .notif-delete:hover {
      background: rgba(239, 68, 68, 0.3);
      transform: scale(1.1);
    }
    
    .notif-dropdown .empty {
      padding: 2rem 1.25rem;
      text-align: center;
      color: #94a3b8;
      font-style: italic;
    }
    
    .btn.ghost {
      background: transparent;
      border: 1px solid rgba(255, 255, 255, 0.2);
      color: #cbd5e1;
      padding: 0.375rem 0.75rem;
      font-size: 0.8rem;
    }
    
    .btn.ghost:hover {
      background: rgba(255, 255, 255, 0.1);
      border-color: rgba(255, 255, 255, 0.3);
    }
    
    .linklike {
      background: none;
      border: none;
      cursor: pointer;
      font: inherit;
    }
    
    .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 0 1.5rem;
    }
    
    main.container {
      padding-top: 2rem;
      padding-bottom: 2rem;
      min-height: calc(100vh - 140px);
    }
    
    .flash {
      background: var(--primary);
      color: white;
      padding: 1rem 1.5rem;
      border-radius: var(--radius);
      margin-bottom: 2rem;
      box-shadow: var(--shadow);
      animation: slideIn 0.3s ease;
    }
    
    @keyframes slideIn {
      from { opacity: 0; transform: translateY(-10px); }
      to { opacity: 1; transform: translateY(0); }
    }
    
    .toast-stack {
      position: fixed;
      right: 20px;
      bottom: 20px;
      display: flex;
      flex-direction: column;
      gap: 10px;
      z-index: 10000;
    }
    
    .toast {
      background: rgba(30, 41, 59, 0.95);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(255, 255, 255, 0.1);
      color: #f8fafc;
      padding: 1rem 1.25rem;
      border-radius: 12px;
      min-width: 280px;
      box-shadow: var(--shadow-lg);
      animation: toastIn 0.3s ease;
      transition: all 0.3s ease;
      cursor: pointer;
    }
    
    .toast:hover {
      background: rgba(30, 41, 59, 0.98);
      transform: translateX(-5px);
    }
    
    @keyframes toastIn {
      from { 
        opacity: 0; 
        transform: translateX(100px); 
      }
      to { 
        opacity: 1; 
        transform: translateX(0); 
      }
    }
    
    .toast.fade-out {
      opacity: 0;
      transform: translateX(100px);
    }
    
    /* Avatars */
    .user-avatar { width: 36px; height: 36px; border-radius: 50%; object-fit: cover; display:inline-block; }
    .post-avatar .user-avatar { width: 40px; height: 40px; }
    .avatar-image { width: 120px; height: 120px; border-radius: 50%; object-fit: cover; }
    .avatar-placeholder { width: 36px; height: 36px; border-radius: 50%; display:flex; align-items:center; justify-content:center; font-weight:700; background:#eee; color:#666; }
    .profile-avatar .avatar-placeholder { width: 120px; height: 120px; font-size: 42px; }
    .comment-avatar { display:inline-block; margin-right:8px; vertical-align:middle; }

    /* Estilos MEJORADOS y COMPACTOS para el panel de administración */
    .admin-panel-link {
      position: relative;
      background: rgba(99, 102, 241, 0.1);
      border: 1px solid rgba(99, 102, 241, 0.3);
      padding: 0.4rem 0.8rem !important;
      border-radius: 8px;
      transition: all 0.2s ease;
      text-decoration: none;
      color: #6366f1 !important;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: 0.4rem;
      font-size: 0.85rem !important;
      line-height: 1;
      white-space: nowrap;
    }
    
    .admin-panel-link:hover {
      background: rgba(99, 102, 241, 0.2);
      transform: translateY(-1px);
      box-shadow: 0 2px 8px rgba(99, 102, 241, 0.2);
      color: #4f46e5 !important;
    }
    
    .admin-panel-link.admin {
      background: rgba(239, 68, 68, 0.1);
      border-color: rgba(239, 68, 68, 0.3);
      color: #ef4444 !important;
    }
    
    .admin-panel-link.admin:hover {
      background: rgba(239, 68, 68, 0.2);
      box-shadow: 0 2px 8px rgba(239, 68, 68, 0.2);
    }
    
    .admin-panel-link.moderator {
      background: rgba(245, 158, 11, 0.1);
      border-color: rgba(245, 158, 11, 0.3);
      color: #f59e0b !important;
    }
    
    .admin-panel-link.moderator:hover {
      background: rgba(245, 158, 11, 0.2);
      box-shadow: 0 2px 8px rgba(245, 158, 11, 0.2);
    }
    
    .role-badge {
      padding: 1px 6px;
      border-radius: 4px;
      font-size: 0.65rem;
      font-weight: 700;
      line-height: 1;
    }
    
    .role-admin {
      background: linear-gradient(135deg, #ef4444, #dc2626);
      color: white;
    }
    
    .role-moderator {
      background: linear-gradient(135deg, #f59e0b, #d97706);
      color: white;
    }

    /* Icono para el panel - más pequeño */
    .panel-icon {
      width: 14px;
      height: 14px;
      fill: currentColor;
      flex-shrink: 0;
    }

    /* Versión compacta para el botón de admin */
    .admin-panel-link.compact {
      padding: 0.35rem 0.7rem !important;
      font-size: 0.8rem !important;
    }
    
    .admin-panel-link.compact .panel-icon {
      width: 12px;
      height: 12px;
    }
    
    .admin-panel-link.compact .role-badge {
      padding: 1px 4px;
      font-size: 0.6rem;
    }

    @media (max-width: 768px) {
      .topbar .container {
        flex-direction: column;
        gap: 1rem;
      }
      
      .topbar nav {
        flex-wrap: wrap;
        justify-content: center;
        gap: 0.5rem;
      }
      
      .topbar nav a, .topbar nav button {
        font-size: 0.8rem;
        padding: 0.35rem 0.5rem;
      }
      
      .notif-dropdown {
        width: 350px;
        right: -50%;
        transform: translateX(50%);
      }
      
      .toast-stack {
        right: 10px;
        left: 10px;
        bottom: 10px;
      }
      
      .toast {
        min-width: auto;
        width: 100%;
      }
      
      .notif-actions {
        opacity: 1;
      }

      .admin-panel-link {
        padding: 0.3rem 0.6rem !important;
        font-size: 0.75rem !important;
      }
      
      .admin-panel-link .panel-icon {
        width: 12px;
        height: 12px;
      }
      
      .role-badge {
        padding: 1px 4px;
        font-size: 0.6rem;
      }
    }
    
    @media (max-width: 480px) {
      .notif-dropdown {
        width: 300px;
      }
      
      .topbar nav {
        gap: 0.4rem;
      }
      
      .topbar nav a, .topbar nav button {
        font-size: 0.75rem;
        padding: 0.3rem 0.4rem;
      }
      
      /* En móviles muy pequeños, hacer el botón de admin más compacto */
      .admin-panel-link {
        padding: 0.25rem 0.5rem !important;
        font-size: 0.7rem !important;
        gap: 0.3rem;
      }
      
      .admin-panel-link span:first-child {
        display: none; /* Ocultar el texto "Panel Admin" en móviles muy pequeños */
      }
    }
  </style>
</head>
<body>
<header class="topbar">
  <div class="container">
    <div class="brand">Nebusa</div>
    <nav>
      <a href="<?php echo htmlspecialchars(base_url('/')); ?>">Inicio</a>
      <?php if (isset($u) && $u): ?>
        <a href="<?php echo htmlspecialchars(base_url('/photos/upload')); ?>">Subir foto</a>
        <a href="<?php echo htmlspecialchars(base_url('/friends')); ?>">Amigos</a>
        <a href="<?php echo htmlspecialchars(base_url('/friends/search')); ?>">Buscar</a>
        <a href="<?php echo htmlspecialchars(base_url('/profile')); ?>">Mi perfil</a>
        <a href="<?php echo htmlspecialchars(base_url('/invites')); ?>">Invitaciones</a>
        <span class="bell">
          <a href="<?php echo htmlspecialchars(base_url('/notifications')); ?>" id="notif-bell-link" class="bell-icon">
            <svg class="bell-svg" viewBox="0 0 24 24">
              <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"></path>
              <path d="M13.73 21a2 2 0 0 1-3.46 0"></path>
            </svg>
            <span id="notif-badge" class="badge" style="display:none;">0</span>
          </a>
          <div id="notif-menu" class="notif-dropdown">
            <header>
              <span>Notificaciones</span>
              <a href="<?php echo htmlspecialchars(base_url('/notifications')); ?>" class="btn ghost">Ver todas</a>
            </header>
            <ul id="notif-menu-list">
              <li class="empty">Sin notificaciones</li>
            </ul>
          </div>
        </span>
        
        <!-- Panel de Administración/Moderación - SOLO mostrar en vistas normales -->
        <?php if (!$is_admin_panel): ?>
          <?php if ($is_admin): ?>
            <a href="<?php echo htmlspecialchars(base_url('/admin')); ?>" class="admin-panel-link admin compact">
              <svg class="panel-icon" viewBox="0 0 24 24">
                <path d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v2h8z"/>
              </svg>
              <span>Admin</span>
              <span class="role-badge role-admin">A</span>
            </a>
          <?php elseif ($is_moderator): ?>
            <a href="<?php echo htmlspecialchars(base_url('/moderator')); ?>" class="admin-panel-link moderator compact">
              <svg class="panel-icon" viewBox="0 0 24 24">
                <path d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
              </svg>
              <span>Mod</span>
              <span class="role-badge role-moderator">M</span>
            </a>
          <?php endif; ?>
        <?php else: ?>
          <!-- Enlace para volver al sitio principal cuando estamos en el panel -->
          <a href="<?php echo htmlspecialchars(base_url('/')); ?>" class="admin-panel-link compact">
            <svg class="panel-icon" viewBox="0 0 24 24">
              <path d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
            </svg>
            <span>Inicio</span>
          </a>
        <?php endif; ?>
        
        <form method="post" action="<?php echo htmlspecialchars(base_url('/logout')); ?>" style="display:inline;">
          <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
          <button type="submit" class="linklike">Salir</button>
        </form>
      <?php else: ?>
        <a href="<?php echo htmlspecialchars(base_url('/login')); ?>">Entrar</a>
        <a href="<?php echo htmlspecialchars(base_url('/register')); ?>" class="btn">Crear cuenta</a>
      <?php endif; ?>
    </nav>
  </div>
</header>
<!-- Resto del código se mantiene igual -->