<div class="container">
  <h2>Notificaciones</h2>

  <div class="notifications-actions">
    <form method="post" action="<?= htmlspecialchars(base_url('/notifications/mark-read')); ?>" style="display:inline;">
      <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()); ?>">
      <button type="submit" class="btn btn-ghost">
        <span class="btn-icon">✓</span>
        Marcar Todas como Leídas
      </button>
    </form>
    <form method="post" action="<?= htmlspecialchars(base_url('/notifications/delete-all-read')); ?>" style="display:inline;">
      <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()); ?>">
      <button type="submit" class="btn btn-danger" onclick="return confirm('¿Eliminar todas las notificaciones leídas?')">
        <span class="btn-icon">🗑️</span>
        Eliminar Leídas
      </button>
    </form>
  </div>

  <?php if (empty($items)): ?>
    <div class="no-notifications">
      <div class="no-notifications-icon">🔔</div>
      <p>No tienes notificaciones</p>
      <p class="no-notifications-subtitle">Las notificaciones aparecerán aquí cuando recibas actividad</p>
    </div>
  <?php else: ?>
    <ul class="notifications">
      <?php foreach ($items as $n): 
        $data = json_decode($n['payload'] ?? '{}', true) ?: [];
        $type = htmlspecialchars($n['type']);
        $fecha = htmlspecialchars($n['created_at']);
        $is_read = !empty($n['read_at']);
        $from_user_id = $data['from_user_id'] ?? null;
        $post_id = $data['post_id'] ?? null;
        $body = $data['body'] ?? '';
        $by_user_id = $data['by_user_id'] ?? null;
        
        // Determinar icono y clase según el tipo
        $icon = '📢';
        $indicator_class = 'indicator-general';
        if ($type === 'like') {
          $icon = '❤️';
          $indicator_class = 'indicator-like';
        } elseif ($type === 'comment') {
          $icon = '💬';
          $indicator_class = 'indicator-comment';
        } elseif ($type === 'friend_request' || $type === 'friend_accept') {
          $icon = '🤝';
          $indicator_class = 'indicator-friend';
        }
      ?>
        <li class="<?php echo $is_read ? 'read' : 'unread'; ?>">
          <a href="<?= htmlspecialchars(base_url('/notifications/redirect?id=' . $n['id'])); ?>" class="notification-content">
            <div class="notification-header">
              <div style="display: flex; align-items: center; gap: 12px;">
                <div class="notification-indicator <?= $indicator_class ?>">
                  <?= $icon ?>
                </div>
                <div>
                  <span class="notification-type">
                    <?= ucfirst(str_replace('_', ' ', $type)) ?>
                    <?php if (!$is_read): ?>
                      <span class="notification-badge">Nueva</span>
                    <?php endif; ?>
                  </span>
                </div>
              </div>
              <span class="notification-date"><?= formatNotificationDate($fecha) ?></span>
            </div>
            
            <div class="notification-message">
              <?php if ($type === 'like' && $from_user_id): ?>
                Tu publicación recibió un "Me gusta"
              <?php elseif ($type === 'comment' && $from_user_id): ?>
                Nuevo comentario en tu publicación
                <?php if ($body): ?>
                  <blockquote><?= htmlspecialchars($body) ?></blockquote>
                <?php endif; ?>
              <?php elseif ($type === 'friend_request' && $from_user_id): ?>
                Tienes una nueva solicitud de amistad
              <?php elseif ($type === 'friend_accept' && $by_user_id): ?>
                Tu solicitud de amistad ha sido aceptada
              <?php else: ?>
                Tienes una nueva notificación
              <?php endif; ?>
            </div>
          </a>
          
          <div class="notification-actions">
            <?php if (!$is_read): ?>
              <form method="post" action="<?= htmlspecialchars(base_url('/notifications/mark-read')); ?>" class="inline-form">
                <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()); ?>">
                <input type="hidden" name="id" value="<?= (int)$n['id']; ?>">
                <button type="submit" class="btn btn-ghost btn-sm">
                  <span class="btn-icon">✓</span>
                  Marcar leído
                </button>
              </form>
            <?php endif; ?>
            
            <form method="post" action="<?= htmlspecialchars(base_url('/notifications/delete')); ?>" class="inline-form">
              <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()); ?>">
              <input type="hidden" name="id" value="<?= (int)$n['id']; ?>">
              <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('¿Eliminar esta notificación?')">
                <span class="btn-icon">🗑️</span>
                Eliminar
              </button>
            </form>
          </div>
        </li>
      <?php endforeach; ?>
    </ul>
  <?php endif; ?>
</div>

<style>
.container {
  max-width: 1200px;
  margin: 0 auto;
  padding: 16px;
}

.notifications-actions {
  margin-bottom: 24px;
  display: flex;
  gap: 12px;
  flex-wrap: wrap;
  align-items: center;
  padding: 16px;
  background: #1a1d23;
  border: 1px solid #2b3138;
  border-radius: 12px;
}

.notifications {
  list-style: none;
  padding-left: 0;
  margin: 0;
}

.notifications li {
  padding: 20px;
  border-radius: 12px;
  background: #1a1d23;
  margin-bottom: 16px;
  border: 1px solid #2b3138;
  transition: all 0.3s ease;
  position: relative;
}

.notifications li:hover {
  background: rgba(255,255,255,0.02);
  border-color: #3f4752;
  transform: translateY(-2px);
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
}

.notifications li.read {
  opacity: 0.8;
  background: #1a1d23;
}

.notifications li.unread {
  border-left: 4px solid #10b981;
  background: rgba(16, 185, 129, 0.05);
}

.notifications li.unread::before {
  content: "";
  position: absolute;
  left: 4px;
  top: 50%;
  transform: translateY(-50%);
  width: 6px;
  height: 6px;
  background: #10b981;
  border-radius: 50%;
}

.notifications blockquote {
  margin: 12px 0 0 0;
  padding: 12px 16px;
  border-left: 3px solid #6366f1;
  background: #2b3138;
  border-radius: 6px;
  font-style: italic;
  color: #e5e7eb;
  line-height: 1.5;
}

.notification-content {
  cursor: pointer;
  margin-bottom: 16px;
  text-decoration: none;
  display: block;
  color: inherit;
}

.notification-actions {
  display: flex;
  gap: 8px;
  flex-wrap: wrap;
  align-items: center;
}

.notification-header {
  display: flex;
  justify-content: space-between;
  align-items: flex-start;
  margin-bottom: 12px;
  flex-wrap: wrap;
  gap: 8px;
}

.notification-type {
  font-weight: 600;
  color: #f8fafc;
  font-size: 1.1rem;
  display: flex;
  align-items: center;
  gap: 8px;
}

.notification-date {
  color: #94a3b8;
  font-size: 0.85rem;
  font-weight: 500;
}

.notification-badge {
  background: #10b981;
  color: white;
  padding: 4px 10px;
  border-radius: 12px;
  font-size: 0.75rem;
  font-weight: 600;
  text-transform: uppercase;
  letter-spacing: 0.5px;
}

.notification-message {
  color: #e5e7eb;
  line-height: 1.5;
  font-size: 0.95rem;
}

.btn {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  padding: 10px 16px;
  border: none;
  border-radius: 8px;
  font-weight: 500;
  text-decoration: none;
  cursor: pointer;
  transition: all 0.2s ease;
  font-size: 0.9rem;
  gap: 6px;
}

.btn-primary {
  background: #6366f1;
  color: white;
}

.btn-primary:hover {
  background: #4f46e5;
  transform: translateY(-1px);
}

.btn-ghost {
  background: transparent;
  color: #94a3b8;
  border: 1px solid #2b3138;
}

.btn-ghost:hover {
  background: rgba(255,255,255,0.05);
  color: #f8fafc;
  border-color: #3f4752;
}

.btn-danger {
  background: #ef4444;
  color: white;
}

.btn-danger:hover {
  background: #dc2626;
  transform: translateY(-1px);
}

.btn-sm {
  padding: 8px 14px;
  font-size: 0.85rem;
}

.btn-icon {
  font-size: 1rem;
}

.inline-form {
  display: inline;
  margin: 0;
}

.no-notifications {
  text-align: center;
  padding: 4rem 2rem;
  color: #94a3b8;
  background: #1a1d23;
  border: 1px solid #2b3138;
  border-radius: 12px;
}

.no-notifications-icon {
  font-size: 4rem;
  margin-bottom: 1.5rem;
  opacity: 0.5;
}

.no-notifications p {
  margin: 0;
  font-size: 1.1rem;
  color: #cbd5e1;
}

.no-notifications-subtitle {
  margin-top: 8px;
  font-size: 0.95rem;
  opacity: 0.8;
}

/* Indicadores de tipo de notificación */
.notification-indicator {
  width: 32px;
  height: 32px;
  border-radius: 8px;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 1.1rem;
}

.indicator-like {
  background: rgba(239, 68, 68, 0.1);
  color: #ef4444;
}

.indicator-comment {
  background: rgba(59, 130, 246, 0.1);
  color: #3b82f6;
}

.indicator-friend {
  background: rgba(16, 185, 129, 0.1);
  color: #10b981;
}

.indicator-general {
  background: rgba(139, 92, 246, 0.1);
  color: #8b5cf6;
}

/* Estados de interacción */
.notification-content:hover {
  text-decoration: none;
}

.notification-content:active {
  opacity: 0.8;
}

/* Mejoras de accesibilidad */
.notifications li:focus-within {
  border-color: #6366f1;
  box-shadow: 0 0 0 2px rgba(99, 102, 241, 0.2);
}

@media (max-width: 768px) {
  .container {
    padding: 12px;
  }
  
  .notifications-actions {
    flex-direction: column;
    align-items: stretch;
    gap: 10px;
  }
  
  .notifications-actions .btn,
  .notifications-actions form {
    width: 100%;
    text-align: center;
  }
  
  .notification-header {
    flex-direction: column;
    gap: 8px;
    align-items: flex-start;
  }
  
  .notification-actions {
    justify-content: center;
  }
  
  .notifications li {
    padding: 16px;
  }
  
  .notification-type {
    font-size: 1rem;
  }
}

@media (max-width: 480px) {
  .notification-actions {
    flex-direction: column;
    align-items: stretch;
  }
  
  .notification-actions .btn {
    width: 100%;
    justify-content: center;
  }
}
</style>

<?php
// Función helper para formatear fechas de notificaciones
function formatNotificationDate($date) {
  $datetime = new DateTime($date);
  $now = new DateTime();
  $diff = $now->diff($datetime);
  
  if ($diff->days == 0) {
    if ($diff->h == 0) {
      if ($diff->i < 1) return 'Ahora mismo';
      return "Hace {$diff->i} min";
    }
    return "Hace {$diff->h} h";
  }
  if ($diff->days == 1) return 'Ayer';
  if ($diff->days < 7) return "Hace {$diff->days} días";
  if ($diff->days < 30) return "Hace " . floor($diff->days / 7) . " sem";
  
  return $datetime->format('d/m/Y');
}
?>