<h2>Gestión de Invitaciones</h2>


<div class="invites-container">
    <!-- Tarjeta de Resumen -->
    <section class="card summary-card">
        <div class="summary-header">
            <h3>Resumen de Invitaciones</h3>
            <div class="invite-count-badge <?php echo $remaining <= 0 ? 'empty' : 'available'; ?>">
                <?php echo (int)$remaining; ?>
            </div>
        </div>
        <p class="summary-text">
            <?php if($remaining > 0): ?>
                Tienes <strong><?php echo (int)$remaining; ?></strong> invitaciones disponibles para compartir.
            <?php else: ?>
                No tienes invitaciones disponibles en este momento.
            <?php endif; ?>
        </p>
        <form method="post" action="<?php echo htmlspecialchars(base_url('/invites/create')); ?>">
            <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
            <button class="btn btn-primary generate-btn" <?php echo $remaining<=0?'disabled':''; ?>>
                <span class="btn-icon">+</span>
                Generar Nueva Invitación
            </button>
        </form>
    </section>

    <!-- Tarjeta de Códigos -->
    <section class="card codes-card">
        <div class="card-header">
            <h3>Mis Códigos de Invitación</h3>
            <span class="codes-count"><?php echo count($codes); ?> código(s)</span>
        </div>

        <?php if(empty($codes)): ?>
            <div class="empty-state">
                <div class="empty-icon">📨</div>
                <p>Aún no has generado códigos de invitación.</p>
                <p class="empty-hint">Genera tu primer código usando el botón de arriba.</p>
            </div>
        <?php else: ?>
            <div class="codes-list">
                <?php foreach($codes as $c): ?>
                    <div class="code-item <?php echo $c['status']; ?>">
                        <div class="code-info">
                            <div class="code-header">
                                <span class="code-value"><?php echo htmlspecialchars($c['code']); ?></span>
                                <span class="status-badge status-<?php echo htmlspecialchars($c['status']); ?>">
                                    <?php 
                                    $statusLabels = [
                                        'active' => 'Activo',
                                        'revoked' => 'Revocado', 
                                        'used' => 'Usado'
                                    ];
                                    echo $statusLabels[$c['status']] ?? $c['status'];
                                    ?>
                                </span>
                            </div>
                            
                            <div class="code-details">
                                <div class="detail">
                                    <span class="detail-label">Usos:</span>
                                    <span class="detail-value">
                                        <?php echo (int)$c['uses']; ?>/<?php echo (int)$c['max_uses']; ?>
                                    </span>
                                </div>
                                
                                <div class="detail">
                                    <span class="detail-label">Creado:</span>
                                    <span class="detail-value">
                                        <?php 
                                        $created = new DateTime($c['created_at']);
                                        echo $created->format('d/m/Y H:i');
                                        ?>
                                    </span>
                                </div>
                                
                                <?php if($c['expires_at']): ?>
                                <div class="detail">
                                    <span class="detail-label">Expira:</span>
                                    <span class="detail-value">
                                        <?php 
                                        $expires = new DateTime($c['expires_at']);
                                        echo $expires->format('d/m/Y H:i');
                                        ?>
                                    </span>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <?php if($c['status']==='active' && (int)$c['uses']===0): ?>
                        <div class="code-actions">
                            <form method="post" action="<?php echo htmlspecialchars(base_url('/invites/revoke')); ?>">
                                <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
                                <input type="hidden" name="invite_id" value="<?php echo (int)$c['id']; ?>">
                                <button class="btn btn-ghost revoke-btn" type="submit" title="Revocar invitación">
                                    <span class="btn-icon">×</span>
                                    Revocar
                                </button>
                            </form>
                        </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </section>
</div>

<style>
.invites-container {
    max-width: 800px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

/* Tarjetas principales con el mismo negro que show.php */
.card {
    background: #1a1d23;
    border: 1px solid #2b3138;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    overflow: hidden;
}

.summary-card {
    padding: 1.5rem;
    text-align: center;
}

.summary-header {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 1rem;
    margin-bottom: 1rem;
}

.summary-header h3 {
    margin: 0;
    color: #f8fafc;
    font-size: 1.25rem;
    font-weight: 600;
}

.invite-count-badge {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 1.2rem;
    color: white;
    border: 2px solid #6366f1;
}

.invite-count-badge.available {
    background: linear-gradient(135deg, #6366f1, #8b5cf6);
}

.invite-count-badge.empty {
    background: #64748b;
}

.summary-text {
    color: #cbd5e1;
    margin-bottom: 1.5rem;
    font-size: 1rem;
}

.summary-text strong {
    color: #f8fafc;
}

/* Botón principal con el mismo estilo que show.php */
.btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 10px 16px;
    border-radius: 8px;
    font-weight: 500;
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: all 0.2s ease;
    font-size: 0.9rem;
}

.btn-primary {
    background: #6366f1;
    color: white;
}

.btn-primary:hover:not(:disabled) {
    background: #4f46e5;
    transform: translateY(-1px);
}

.btn-primary:disabled {
    background: #64748b;
    color: #94a3b8;
    cursor: not-allowed;
    transform: none;
}

.btn-ghost {
    background: transparent;
    color: #94a3b8;
    border: 1px solid #2b3138;
}

.btn-ghost:hover {
    background: rgba(255,255,255,0.05);
    color: #f8fafc;
}

.btn-icon {
    font-size: 1.1rem;
}

.codes-card {
    padding: 0;
}

.card-header {
    padding: 1.5rem 1.5rem 1rem;
    border-bottom: 1px solid #2b3138;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.card-header h3 {
    margin: 0;
    color: #f8fafc;
    font-size: 1.25rem;
    font-weight: 600;
}

.codes-count {
    background: #2b3138;
    color: #94a3b8;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 500;
}

.empty-state {
    padding: 3rem 1.5rem;
    text-align: center;
    color: #94a3b8;
}

.empty-icon {
    font-size: 3rem;
    margin-bottom: 1rem;
    opacity: 0.5;
}

.empty-hint {
    font-size: 0.9rem;
    margin-top: 0.5rem;
    opacity: 0.7;
}

.codes-list {
    padding: 0;
}

/* Items de código con el mismo estilo que las tarjetas de show.php */
.code-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.25rem 1.5rem;
    border-bottom: 1px solid #2b3138;
    background: #1a1d23;
    transition: all 0.2s ease;
}

.code-item:hover {
    background: rgba(255,255,255,0.02);
}

.code-item:last-child {
    border-bottom: none;
}

.code-info {
    flex: 1;
}

.code-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 0.75rem;
}

.code-value {
    font-family: 'Courier New', monospace;
    font-weight: bold;
    color: #f8fafc;
    font-size: 1.1rem;
    letter-spacing: 1px;
    background: #2b3138;
    padding: 0.25rem 0.5rem;
    border-radius: 4px;
}

.status-badge {
    padding: 0.25rem 0.75rem;
    border-radius: 12px;
    font-size: 0.75rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.status-active {
    background: #10b98120;
    color: #10b981;
    border: 1px solid #10b98140;
}

.status-revoked {
    background: #ef444420;
    color: #ef4444;
    border: 1px solid #ef444440;
}

.status-used {
    background: #64748b20;
    color: #64748b;
    border: 1px solid #64748b40;
}

.code-details {
    display: flex;
    gap: 1.5rem;
    flex-wrap: wrap;
}

.detail {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.detail-label {
    font-size: 0.875rem;
    color: #94a3b8;
    font-weight: 500;
}

.detail-value {
    font-size: 0.875rem;
    color: #f8fafc;
    font-weight: 600;
}

.code-actions {
    margin-left: 1rem;
}

.revoke-btn {
    padding: 0.5rem 1rem;
    border-radius: 6px;
    font-size: 0.875rem;
}

@media (max-width: 768px) {
    .invites-container {
        gap: 1rem;
    }
    
    .card {
        border-radius: 8px;
    }
    
    .summary-card,
    .card-header {
        padding: 1.25rem;
    }
    
    .code-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .code-actions {
        margin-left: 0;
        width: 100%;
    }
    
    .revoke-btn {
        width: 100%;
        justify-content: center;
    }
    
    .code-details {
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .summary-header {
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .card-header {
        flex-direction: column;
        gap: 0.5rem;
        align-items: flex-start;
    }
}
</style>