<?php // content-only ?>
<section style="max-width:1400px; margin:20px auto; padding:0 16px">
  <!-- Header -->
  <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px;">
    <div>
      <h1 style="margin: 0; color: #1a1d23; font-size: 1.8rem;">Gestión de Reportes</h1>
      <p style="margin: 4px 0 0 0; color: #64748b; font-size: 0.9rem;">
        Revisa y gestiona reportes de usuarios, fotos y comentarios
      </p>
    </div>
    <div style="display: flex; gap: 12px; align-items: center;">
      <a href="<?php echo base_url('/admin'); ?>" 
         style="padding: 10px 16px; background: #f1f5f9; color: #374151; text-decoration: none; border-radius: 8px; border: 1px solid #e2e8f0; font-size: 0.9rem;">
        ← Dashboard
      </a>
    </div>
  </div>

  <!-- Filtros y búsqueda -->
  <div style="background: white; border: 1px solid #e2e8f0; border-radius: 12px; padding: 20px; margin-bottom: 24px;">
    <form method="get" action="<?php echo base_url('/admin/reports'); ?>" style="display: grid; grid-template-columns: 1fr auto auto auto; gap: 12px; align-items: end;">
      <div>
        <label style="display: block; font-size: 0.8rem; color: #374151; margin-bottom: 4px; font-weight: 500;">Buscar</label>
        <input type="text" name="q" value="<?php echo htmlspecialchars($_GET['q'] ?? ''); ?>" 
               placeholder="Buscar por usuario, motivo..." 
               style="width: 100%; padding: 8px 12px; border: 1px solid #d1d5db; border-radius: 6px; font-size: 0.9rem;">
      </div>
      
      <div>
        <label style="display: block; font-size: 0.8rem; color: #374151; margin-bottom: 4px; font-weight: 500;">Tipo</label>
        <select name="type" style="padding: 8px 12px; border: 1px solid #d1d5db; border-radius: 6px; font-size: 0.9rem; width: 100%;">
          <option value="">Todos los tipos</option>
          <option value="user" <?php echo ($_GET['type'] ?? '') === 'user' ? 'selected' : ''; ?>>Usuario</option>
          <option value="photo" <?php echo ($_GET['type'] ?? '') === 'photo' ? 'selected' : ''; ?>>Foto</option>
          <option value="comment" <?php echo ($_GET['type'] ?? '') === 'comment' ? 'selected' : ''; ?>>Comentario</option>
        </select>
      </div>
      
      <div>
        <label style="display: block; font-size: 0.8rem; color: #374151; margin-bottom: 4px; font-weight: 500;">Estado</label>
        <select name="status" style="padding: 8px 12px; border: 1px solid #d1d5db; border-radius: 6px; font-size: 0.9rem; width: 100%;">
          <option value="pending" <?php echo ($_GET['status'] ?? 'pending') === 'pending' ? 'selected' : ''; ?>>Pendientes</option>
          <option value="resolved" <?php echo ($_GET['status'] ?? '') === 'resolved' ? 'selected' : ''; ?>>Resueltos</option>
          <option value="dismissed" <?php echo ($_GET['status'] ?? '') === 'dismissed' ? 'selected' : ''; ?>>Descartados</option>
        </select>
      </div>
      
      <div style="display: flex; gap: 8px;">
        <button type="submit" 
                style="padding: 8px 16px; background: #6366f1; color: white; border: none; border-radius: 6px; font-size: 0.9rem; cursor: pointer;">
          🔍 Filtrar
        </button>
        <a href="<?php echo base_url('/admin/reports'); ?>" 
           style="padding: 8px 16px; background: #f1f5f9; color: #374151; text-decoration: none; border-radius: 6px; border: 1px solid #e2e8f0; font-size: 0.9rem;">
          🔄 Limpiar
        </a>
      </div>
    </form>
  </div>

  <!-- Filtros rápidos y estadísticas -->
  <div style="display: grid; grid-template-columns: 1fr auto; gap: 24px; margin-bottom: 24px;">
    <!-- Filtros rápidos -->
    <div style="display: flex; gap: 12px; flex-wrap: wrap;">
      <a href="<?php echo base_url('/admin/reports?status=pending' . (!empty($_GET['q']) ? '&q=' . urlencode($_GET['q']) : '') . (!empty($_GET['type']) ? '&type=' . urlencode($_GET['type']) : '')); ?>" 
         style="padding: 8px 16px; background: <?php echo ($_GET['status'] ?? '') === 'pending' ? '#fef3c7' : '#f8fafc'; ?>; color: <?php echo ($_GET['status'] ?? '') === 'pending' ? '#92400e' : '#374151'; ?>; text-decoration: none; border-radius: 8px; border: 1px solid #e2e8f0; font-size: 0.9rem;">
        ⚠️ Pendientes (<?php echo $stats['pending'] ?? 0; ?>)
      </a>
      <a href="<?php echo base_url('/admin/reports?status=resolved' . (!empty($_GET['q']) ? '&q=' . urlencode($_GET['q']) : '') . (!empty($_GET['type']) ? '&type=' . urlencode($_GET['type']) : '')); ?>" 
         style="padding: 8px 16px; background: <?php echo ($_GET['status'] ?? '') === 'resolved' ? '#d1fae5' : '#f8fafc'; ?>; color: <?php echo ($_GET['status'] ?? '') === 'resolved' ? '#065f46' : '#374151'; ?>; text-decoration: none; border-radius: 8px; border: 1px solid #e2e8f0; font-size: 0.9rem;">
        ✅ Resueltos (<?php echo $stats['resolved'] ?? 0; ?>)
      </a>
      <a href="<?php echo base_url('/admin/reports?status=dismissed' . (!empty($_GET['q']) ? '&q=' . urlencode($_GET['q']) : '') . (!empty($_GET['type']) ? '&type=' . urlencode($_GET['type']) : '')); ?>" 
         style="padding: 8px 16px; background: <?php echo ($_GET['status'] ?? '') === 'dismissed' ? '#f1f5f9' : '#f8fafc'; ?>; color: <?php echo ($_GET['status'] ?? '') === 'dismissed' ? '#374151' : '#374151'; ?>; text-decoration: none; border-radius: 8px; border: 1px solid #e2e8f0; font-size: 0.9rem;">
        ❌ Descartados (<?php echo $stats['dismissed'] ?? 0; ?>)
      </a>
    </div>

    <!-- Estadísticas rápidas -->
    <div style="display: flex; gap: 16px; font-size: 0.9rem;">
      <div style="text-align: center;">
        <div style="font-weight: 600; color: #1a1d23;"><?php echo $stats['total'] ?? 0; ?></div>
        <div style="color: #64748b;">Total</div>
      </div>
      <div style="width: 1px; background: #e2e8f0;"></div>
      <div style="text-align: center;">
        <div style="font-weight: 600; color: #ef4444;"><?php echo $stats['pending'] ?? 0; ?></div>
        <div style="color: #64748b;">Pendientes</div>
      </div>
    </div>
  </div>

  <!-- Mensajes Flash -->
  <?php if (!empty($_SESSION['flash'])): ?>
    <div style="padding: 12px 16px; background: #dbeafe; border: 1px solid #93c5fd; border-radius: 8px; margin-bottom: 20px; color: #1e40af;">
      <?php echo htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?>
    </div>
  <?php endif; ?>

  <!-- Lista de reportes compacta -->
  <div style="background: white; border: 1px solid #e2e8f0; border-radius: 12px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
    <?php if (!empty($reports)): ?>
      <?php foreach ($reports as $report): ?>
        <!-- Tarjeta de reporte compacta -->
        <div style="border-bottom: 1px solid #f1f5f9; padding: 16px; transition: background 0.2s; cursor: pointer;" 
             onclick="toggleReportDetails(<?php echo $report['id']; ?>)">
          <div style="display: grid; grid-template-columns: auto 1fr auto; gap: 12px; align-items: center;">
            <!-- Icono del tipo -->
            <div style="flex-shrink: 0;">
              <?php if ($report['target_type'] === 'user'): ?>
                <div style="width: 40px; height: 40px; background: #6366f1; border-radius: 8px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1rem;">
                  👤
                </div>
              <?php elseif ($report['target_type'] === 'photo'): ?>
                <div style="width: 40px; height: 40px; background: #10b981; border-radius: 8px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1rem;">
                  🖼️
                </div>
              <?php else: ?>
                <div style="width: 40px; height: 40px; background: #f59e0b; border-radius: 8px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1rem;">
                  💬
                </div>
              <?php endif; ?>
            </div>
            
            <!-- Información principal -->
            <div style="flex: 1;">
              <div style="font-weight: 600; color: #1a1d23; margin-bottom: 4px; font-size: 0.95rem;">
                <?php if ($report['target_type'] === 'user'): ?>
                  Reporte de Usuario
                <?php elseif ($report['target_type'] === 'photo'): ?>
                  Reporte de Foto
                <?php else: ?>
                  Reporte de Comentario
                <?php endif; ?>
              </div>
              
              <div style="font-size: 0.85rem; color: #64748b; margin-bottom: 4px;">
                <strong><?php echo htmlspecialchars($report['reporter_nick'] ?? 'Usuario'); ?></strong>
                <?php if (!empty($report['reported_nick'])): ?>
                  → <strong><?php echo htmlspecialchars($report['reported_nick']); ?></strong>
                <?php endif; ?>
              </div>
              
              <div style="font-size: 0.8rem; color: #94a3b8;">
                <?php echo date('d/m/Y H:i', strtotime($report['created_at'])); ?>
                • 
                <span style="color: #64748b; max-width: 300px; display: inline-block; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; vertical-align: bottom;">
                  <?php echo htmlspecialchars(mb_substr($report['reason'], 0, 60) . (mb_strlen($report['reason']) > 60 ? '...' : '')); ?>
                </span>
              </div>
            </div>
            
            <!-- Estado y flecha -->
            <div style="display: flex; align-items: center; gap: 12px;">
              <?php if ($report['status'] === 'pending'): ?>
                <span style="padding: 4px 8px; background: #fef3c7; color: #92400e; border-radius: 12px; font-size: 0.75rem; font-weight: 500;">
                  ⚠️ PENDIENTE
                </span>
              <?php elseif ($report['status'] === 'resolved'): ?>
                <span style="padding: 4px 8px; background: #d1fae5; color: #065f46; border-radius: 12px; font-size: 0.75rem; font-weight: 500;">
                  ✅ RESUELTO
                </span>
              <?php else: ?>
                <span style="padding: 4px 8px; background: #f1f5f9; color: #374151; border-radius: 12px; font-size: 0.75rem; font-weight: 500;">
                  ❌ DESCARTADO
                </span>
              <?php endif; ?>
              
              <span style="color: #64748b; font-size: 0.9rem;">▼</span>
            </div>
          </div>
        </div>
        
        <!-- Detalles expandibles (ocultos por defecto) -->
        <div id="report-details-<?php echo $report['id']; ?>" style="display: none; background: #f8fafc; border-bottom: 1px solid #e2e8f0; padding: 20px;">
          <div style="max-width: 800px; margin: 0 auto;">
            <!-- Información expandida -->
            <div style="display: grid; gap: 16px;">
              <!-- Motivo completo -->
              <div style="background: white; padding: 16px; border-radius: 8px; border: 1px solid #e2e8f0;">
                <div style="font-size: 0.9rem; color: #374151; font-weight: 500; margin-bottom: 8px;">Motivo del reporte:</div>
                <div style="font-size: 0.9rem; color: #64748b; line-height: 1.5;"><?php echo htmlspecialchars($report['reason']); ?></div>
              </div>

              <!-- Información específica del target -->
              <?php if ($report['target_type'] === 'photo' && !empty($report['photo_text'])): ?>
                <div style="background: #f0f9ff; padding: 16px; border-radius: 8px; border: 1px solid #bae6fd;">
                  <div style="font-size: 0.9rem; color: #0369a1; font-weight: 500; margin-bottom: 8px;">Descripción de la foto:</div>
                  <div style="font-size: 0.9rem; color: #0c4a6e; line-height: 1.5;">"<?php echo htmlspecialchars($report['photo_text']); ?>"</div>
                </div>
              <?php endif; ?>

              <!-- Notas del moderador (si existen) -->
              <?php if (!empty($report['moderator_notes'])): ?>
                <div style="background: #fffbeb; padding: 16px; border-radius: 8px; border: 1px solid #fef08a;">
                  <div style="font-size: 0.9rem; color: #92400e; font-weight: 500; margin-bottom: 8px;">Notas del moderador:</div>
                  <div style="font-size: 0.9rem; color: #78350f; line-height: 1.5;"><?php echo htmlspecialchars($report['moderator_notes']); ?></div>
                </div>
              <?php endif; ?>

              <!-- Acciones (solo para pendientes) -->
              <?php if ($report['status'] === 'pending'): ?>
                <div style="background: white; padding: 16px; border-radius: 8px; border: 1px solid #e2e8f0;">
                  <div style="font-size: 0.9rem; color: #374151; font-weight: 500; margin-bottom: 12px;">Acciones de moderación:</div>
                  
                  <div style="display: flex; gap: 12px; flex-wrap: wrap; align-items: start;">
                    <!-- Enlaces para ver contenido -->
                    <?php if ($report['target_type'] === 'user'): ?>
                      <a href="<?php echo base_url('/admin/users/profile?id=' . (int)$report['reported_user_id']); ?>" 
                         target="_blank"
                         style="padding: 8px 12px; background: #f1f5f9; color: #374151; text-decoration: none; border-radius: 6px; font-size: 0.8rem; border: 1px solid #e2e8f0;">
                        👁️ Ver Usuario
                      </a>
                    <?php elseif ($report['target_type'] === 'photo'): ?>
                      <a href="<?php echo base_url('/photo?id=' . (int)$report['target_id']); ?>" 
                         target="_blank"
                         style="padding: 8px 12px; background: #f1f5f9; color: #374151; text-decoration: none; border-radius: 6px; font-size: 0.8rem; border: 1px solid #e2e8f0;">
                        👁️ Ver Foto
                      </a>
                    <?php endif; ?>

                    <!-- Botones de moderación rápida -->
                    <div style="display: flex; gap: 8px; flex-wrap: wrap;">
                      <?php if ($report['target_type'] === 'user'): ?>
                        <form method="post" action="<?php echo base_url('/admin/users/update_status'); ?>" style="margin: 0;">
                          <input type="hidden" name="id" value="<?php echo (int)$report['reported_user_id']; ?>">
                          <input type="hidden" name="status" value="banned">
                          <input type="hidden" name="ban_duration" value="7">
                          <input type="hidden" name="ban_reason" value="Reporte: <?php echo htmlspecialchars($report['reason']); ?>">
                          <button type="submit" onclick="return confirm('¿Banear al usuario por 7 días?')" 
                                  style="padding: 8px 12px; background: #ef4444; color: white; border: none; border-radius: 6px; font-size: 0.8rem; cursor: pointer;">
                            ⚡ Banear 7 días
                          </button>
                        </form>
                        
                        <form method="post" action="<?php echo base_url('/admin/users/update_status'); ?>" style="margin: 0;">
                          <input type="hidden" name="id" value="<?php echo (int)$report['reported_user_id']; ?>">
                          <input type="hidden" name="status" value="banned">
                          <input type="hidden" name="ban_duration" value="30">
                          <input type="hidden" name="ban_reason" value="Reporte: <?php echo htmlspecialchars($report['reason']); ?>">
                          <button type="submit" onclick="return confirm('¿Banear al usuario por 30 días?')" 
                                  style="padding: 8px 12px; background: #dc2626; color: white; border: none; border-radius: 6px; font-size: 0.8rem; cursor: pointer;">
                            🔥 Banear 30 días
                          </button>
                        </form>
                        
                      <?php elseif ($report['target_type'] === 'photo'): ?>
                        <form method="post" action="<?php echo base_url('/admin/photos/update_status'); ?>" style="margin: 0;">
                          <input type="hidden" name="id" value="<?php echo (int)$report['target_id']; ?>">
                          <input type="hidden" name="status" value="hidden">
                          <button type="submit" onclick="return confirm('¿Ocultar esta foto?')" 
                                  style="padding: 8px 12px; background: #f59e0b; color: white; border: none; border-radius: 6px; font-size: 0.8rem; cursor: pointer;">
                            🚫 Ocultar Foto
                          </button>
                        </form>
                        
                        <form method="post" action="<?php echo base_url('/admin/photos/delete'); ?>" style="margin: 0;">
                          <input type="hidden" name="id" value="<?php echo (int)$report['target_id']; ?>">
                          <button type="submit" onclick="return confirm('¿Eliminar permanentemente esta foto?')" 
                                  style="padding: 8px 12px; background: #ef4444; color: white; border: none; border-radius: 6px; font-size: 0.8rem; cursor: pointer;">
                            🗑️ Eliminar Foto
                          </button>
                        </form>
                        
                      <?php elseif ($report['target_type'] === 'comment'): ?>
                        <form method="post" action="<?php echo base_url('/admin/comments/delete'); ?>" style="margin: 0;">
                          <input type="hidden" name="id" value="<?php echo (int)$report['target_id']; ?>">
                          <button type="submit" onclick="return confirm('¿Eliminar este comentario?')" 
                                  style="padding: 8px 12px; background: #ef4444; color: white; border: none; border-radius: 6px; font-size: 0.8rem; cursor: pointer;">
                            🗑️ Eliminar Comentario
                          </button>
                        </form>
                      <?php endif; ?>
                    </div>
                  </div>

                  <!-- Formulario de acciones del reporte -->
                  <form method="post" action="<?php echo base_url('/admin/reports/update'); ?>" style="margin: 20px 0 0 0;">
                    <input type="hidden" name="id" value="<?php echo (int)$report['id']; ?>">
                    <input type="hidden" name="action" value="resolve">
                    
                    <textarea name="moderator_notes" placeholder="Agregar notas de moderación (opcional)..." 
                              style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 6px; font-size: 0.8rem; margin-bottom: 12px; resize: vertical; min-height: 80px; font-family: inherit;"></textarea>
                    
                    <div style="display: flex; gap: 8px;">
                      <button type="submit" 
                              style="padding: 10px 16px; background: #10b981; color: white; border: none; border-radius: 6px; font-size: 0.8rem; cursor: pointer; flex: 1;">
                        ✅ Marcar como Resuelto
                      </button>
                      
                      <button type="submit" 
                              formaction="<?php echo base_url('/admin/reports/update'); ?>"
                              onclick="this.form.querySelector('input[name=\"action\"]').value='dismiss';"
                              style="padding: 10px 16px; background: #6b7280; color: white; border: none; border-radius: 6px; font-size: 0.8rem; cursor: pointer; flex: 1;">
                        ❌ Descartar Reporte
                      </button>
                    </div>
                  </form>
                </div>
              <?php else: ?>
                <div style="font-size: 0.8rem; color: #64748b; text-align: center;">
                  Gestionado el <?php echo !empty($report['resolved_at']) ? date('d/m/Y H:i', strtotime($report['resolved_at'])) : '—'; ?>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
      
      <!-- Paginación -->
      <?php if (($total_pages ?? 1) > 1): ?>
        <div style="padding: 20px; border-top: 1px solid #e2e8f0; display: flex; justify-content: center; align-items: center; gap: 8px;">
          <!-- Botón Anterior -->
          <?php if (($current_page ?? 1) > 1): ?>
            <a href="<?php echo base_url('/admin/reports?' . http_build_query(array_merge($_GET, ['page' => ($current_page ?? 1) - 1]))); ?>" 
               style="padding: 8px 12px; background: #f1f5f9; color: #374151; text-decoration: none; border-radius: 6px; border: 1px solid #e2e8f0; font-size: 0.8rem;">
              ← Anterior
            </a>
          <?php else: ?>
            <span style="padding: 8px 12px; background: #f8fafc; color: #94a3b8; border-radius: 6px; border: 1px solid #e2e8f0; font-size: 0.8rem; cursor: not-allowed;">
              ← Anterior
            </span>
          <?php endif; ?>

          <!-- Números de página -->
          <?php 
          $start_page = max(1, ($current_page ?? 1) - 2);
          $end_page = min(($total_pages ?? 1), ($current_page ?? 1) + 2);
          
          for ($i = $start_page; $i <= $end_page; $i++): 
          ?>
            <?php if ($i == ($current_page ?? 1)): ?>
              <span style="padding: 8px 12px; background: #6366f1; color: white; border-radius: 6px; font-size: 0.8rem; font-weight: 500;">
                <?php echo $i; ?>
              </span>
            <?php else: ?>
              <a href="<?php echo base_url('/admin/reports?' . http_build_query(array_merge($_GET, ['page' => $i]))); ?>" 
                 style="padding: 8px 12px; background: #f1f5f9; color: #374151; text-decoration: none; border-radius: 6px; border: 1px solid #e2e8f0; font-size: 0.8rem;">
                <?php echo $i; ?>
              </a>
            <?php endif; ?>
          <?php endfor; ?>

          <!-- Botón Siguiente -->
          <?php if (($current_page ?? 1) < ($total_pages ?? 1)): ?>
            <a href="<?php echo base_url('/admin/reports?' . http_build_query(array_merge($_GET, ['page' => ($current_page ?? 1) + 1]))); ?>" 
               style="padding: 8px 12px; background: #f1f5f9; color: #374151; text-decoration: none; border-radius: 6px; border: 1px solid #e2e8f0; font-size: 0.8rem;">
              Siguiente →
            </a>
          <?php else: ?>
            <span style="padding: 8px 12px; background: #f8fafc; color: #94a3b8; border-radius: 6px; border: 1px solid #e2e8f0; font-size: 0.8rem; cursor: not-allowed;">
              Siguiente →
            </span>
          <?php endif; ?>
        </div>
        
        <!-- Información de paginación -->
        <div style="padding: 12px 20px; background: #f8fafc; border-top: 1px solid #e2e8f0; text-align: center; font-size: 0.8rem; color: #64748b;">
          Mostrando <?php echo (($current_page ?? 1) - 1) * ($per_page ?? 20) + 1; ?> - 
          <?php echo min(($current_page ?? 1) * ($per_page ?? 20), ($total_reports ?? 0)); ?> 
          de <?php echo $total_reports ?? 0; ?> reportes
          (Página <?php echo $current_page ?? 1; ?> de <?php echo $total_pages ?? 1; ?>)
        </div>
      <?php endif; ?>
      
    <?php else: ?>
      <div style="padding: 60px 20px; text-align: center; color: #64748b;">
        <div style="font-size: 3rem; margin-bottom: 16px;">📝</div>
        <div style="font-size: 1.2rem; margin-bottom: 8px; font-weight: 500;">No hay reportes</div>
        <div style="font-size: 0.9rem; color: #94a3b8;">
          <?php if (!empty($_GET['status']) || !empty($_GET['q']) || !empty($_GET['type'])): ?>
            No se encontraron reportes con los filtros aplicados
          <?php else: ?>
            No hay reportes en el sistema
          <?php endif; ?>
        </div>
      </div>
    <?php endif; ?>
  </div>

  <!-- Información para moderadores -->
  <div style="margin-top: 24px; display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
    <div style="padding: 16px; background: #f0f9ff; border: 1px solid #bae6fd; border-radius: 8px;">
      <div style="display: flex; gap: 12px; align-items: start;">
        <div style="font-size: 1.2rem;">💡</div>
        <div>
          <div style="font-weight: 600; color: #0369a1; margin-bottom: 4px;">Guía de Moderación</div>
          <div style="font-size: 0.9rem; color: #0369a1;">
            • <strong>Resolver</strong>: Cuando el reporte es válido y se tomó acción<br>
            • <strong>Descartar</strong>: Cuando el reporte es infundado<br>
            • Siempre documenta tus decisiones
          </div>
        </div>
      </div>
    </div>
    
    <div style="padding: 16px; background: #fefce8; border: 1px solid #fef08a; border-radius: 8px;">
      <div style="display: flex; gap: 12px; align-items: start;">
        <div style="font-size: 1.2rem;">⏱️</div>
        <div>
          <div style="font-weight: 600; color: #ca8a04; margin-bottom: 4px;">Acciones Rápidas</div>
          <div style="font-size: 0.9rem; color: #ca8a04;">
            • <strong>⚡</strong>: Ban temporal 7 días<br>
            • <strong>🔥</strong>: Ban temporal 30 días<br>
            • <strong>🚫</strong>: Ocultar contenido
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<script>
function toggleReportDetails(reportId) {
  const detailsElement = document.getElementById('report-details-' + reportId);
  const isVisible = detailsElement.style.display === 'block';
  
  // Cerrar todos los detalles primero
  document.querySelectorAll('[id^="report-details-"]').forEach(el => {
    el.style.display = 'none';
  });
  
  // Abrir el seleccionado si no estaba visible
  if (!isVisible) {
    detailsElement.style.display = 'block';
  }
}

// Cerrar detalles al hacer clic fuera
document.addEventListener('click', function(event) {
  if (!event.target.closest('[id^="report-details-"]') && !event.target.closest('[onclick^="toggleReportDetails"]')) {
    document.querySelectorAll('[id^="report-details-"]').forEach(el => {
      el.style.display = 'none';
    });
  }
});

// Prevenir que los formularios de acciones rápidas abran/cierren los detalles
document.querySelectorAll('form button').forEach(button => {
  button.addEventListener('click', function(e) {
    e.stopPropagation();
  });
});

// Resaltar reporte específico si viene de un enlace
function highlightSpecificReport() {
    const urlParams = new URLSearchParams(window.location.search);
    const targetId = urlParams.get('highlight');
    const targetType = urlParams.get('target_type');
    
    if (targetId && targetType) {
        // Buscar el reporte que coincida
        const reports = document.querySelectorAll('[onclick^="toggleReportDetails"]');
        reports.forEach(report => {
            const reportText = report.textContent;
            if (reportText.includes(`#${targetId}`) || reportText.includes(targetType)) {
                // Simular clic para expandir
                const reportId = report.getAttribute('onclick').match(/\d+/)[0];
                toggleReportDetails(reportId);
                
                // Resaltar visualmente
                report.style.background = '#fef3c7';
                report.style.borderLeft = '4px solid #f59e0b';
                
                // Scroll a la posición
                report.scrollIntoView({ behavior: 'smooth', block: 'center' });
            }
        });
    }
}

// Ejecutar cuando la página cargue
document.addEventListener('DOMContentLoaded', highlightSpecificReport);
</script>

<style>
form:hover { background: transparent !important; }

button:hover { transform: translateY(-1px); box-shadow: 0 2px 4px rgba(0,0,0,0.1); }

a:hover { background: #e2e8f0 !important; transform: translateY(-1px); }

/* Efecto hover para las tarjetas de reporte */
div[onclick^="toggleReportDetails"]:hover { 
  background: #f8fafc !important; 
}

/* Estilos para botones de acciones rápidas */
form button[style*="background: #ef4444"]:hover { background: #dc2626 !important; }
form button[style*="background: #dc2626"]:hover { background: #b91c1c !important; }
form button[style*="background: #f59e0b"]:hover { background: #d97706 !important; }

@media (max-width: 768px) {
  section {
    padding: 0 12px !important;
  }
  
  .stats-grid {
    grid-template-columns: 1fr 1fr !important;
  }
  
  div[onclick^="toggleReportDetails"] {
    padding: 12px !important;
  }
  
  /* Formulario responsive */
  form[style*="grid-template-columns: 1fr auto auto auto"] {
    grid-template-columns: 1fr !important;
    gap: 16px !important;
  }
  
  /* Paginación responsive */
  .pagination {
    flex-wrap: wrap !important;
    gap: 4px !important;
  }
}
</style>