<?php // content-only ?>
<section style="max-width:1200px; margin:20px auto; padding:0 16px">
  <!-- Header -->
  <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px;">
    <div>
      <h1 style="margin: 0; color: #1a1d23; font-size: 1.8rem;">Gestión de Baneos</h1>
      <p style="margin: 4px 0 0 0; color: #64748b; font-size: 0.9rem;">
        Administra baneos temporales y permanentes
      </p>
    </div>
    <div style="display: flex; gap: 12px;">
      <a href="<?php echo base_url('/admin/users'); ?>" 
         style="padding: 10px 16px; background: #f1f5f9; color: #374151; text-decoration: none; border-radius: 8px; border: 1px solid #e2e8f0; font-size: 0.9rem;">
        ← Volver a Usuarios
      </a>
      <form method="post" action="<?php echo base_url('/admin/check-expired-bans'); ?>" style="margin: 0;">
        <button type="submit" style="padding: 10px 16px; background: #10b981; color: white; border: none; border-radius: 8px; font-size: 0.9rem; cursor: pointer;">
          🔄 Revisar Baneos Expirados
        </button>
      </form>
    </div>
  </div>

  <!-- Estadísticas de baneos -->
  <?php
  $temp_bans = 0;
  $perm_bans = 0;
  $expiring_soon = 0;
  
  foreach ($bans ?? [] as $ban) {
      if (!empty($ban['banned_until'])) {
          $temp_bans++;
          // Baneos que expiran en menos de 3 días
          if (strtotime($ban['banned_until']) - time() < (3 * 24 * 60 * 60)) {
              $expiring_soon++;
          }
      } else {
          $perm_bans++;
      }
  }
  ?>
  
  <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 16px; margin-bottom: 24px;">
    <div style="background: white; border: 1px solid #e2e8f0; border-radius: 12px; padding: 20px; text-align: center;">
      <div style="font-size: 2rem; margin-bottom: 8px;">🔴</div>
      <div style="font-size: 1.5rem; font-weight: 600; color: #1a1d23;"><?php echo count($bans ?? []); ?></div>
      <div style="color: #64748b; font-size: 0.9rem;">Total Baneados</div>
    </div>
    
    <div style="background: white; border: 1px solid #e2e8f0; border-radius: 12px; padding: 20px; text-align: center;">
      <div style="font-size: 2rem; margin-bottom: 8px;">⏳</div>
      <div style="font-size: 1.5rem; font-weight: 600; color: #1a1d23;"><?php echo $temp_bans; ?></div>
      <div style="color: #64748b; font-size: 0.9rem;">Temporales</div>
    </div>
    
    <div style="background: white; border: 1px solid #e2e8f0; border-radius: 12px; padding: 20px; text-align: center;">
      <div style="font-size: 2rem; margin-bottom: 8px;">🚫</div>
      <div style="font-size: 1.5rem; font-weight: 600; color: #1a1d23;"><?php echo $perm_bans; ?></div>
      <div style="color: #64748b; font-size: 0.9rem;">Permanentes</div>
    </div>
    
    <div style="background: white; border: 1px solid #e2e8f0; border-radius: 12px; padding: 20px; text-align: center;">
      <div style="font-size: 2rem; margin-bottom: 8px;">⚠️</div>
      <div style="font-size: 1.5rem; font-weight: 600; color: #1a1d23;"><?php echo $expiring_soon; ?></div>
      <div style="color: #64748b; font-size: 0.9rem;">Por Expirar</div>
    </div>
  </div>

  <!-- Mensajes Flash -->
  <?php if (!empty($_SESSION['flash'])): ?>
    <div style="padding: 12px 16px; background: #dbeafe; border: 1px solid #93c5fd; border-radius: 8px; margin-bottom: 20px; color: #1e40af;">
      <?php echo htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?>
    </div>
  <?php endif; ?>

  <!-- Tabla de baneos -->
  <div style="background: white; border: 1px solid #e2e8f0; border-radius: 12px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
    <div style="overflow: auto;">
      <table style="width: 100%; border-collapse: collapse; min-width: 1000px;">
        <thead>
          <tr style="background: #f8fafc; border-bottom: 1px solid #e2e8f0;">
            <th style="padding: 16px; text-align: left; font-weight: 600; color: #374151; font-size: 0.9rem;">Usuario</th>
            <th style="padding: 16px; text-align: left; font-weight: 600; color: #374151; font-size: 0.9rem;">Tipo</th>
            <th style="padding: 16px; text-align: left; font-weight: 600; color: #374151; font-size: 0.9rem;">Fecha de Ban</th>
            <th style="padding: 16px; text-align: left; font-weight: 600; color: #374151; font-size: 0.9rem;">Expira</th>
            <th style="padding: 16px; text-align: left; font-weight: 600; color: #374151; font-size: 0.9rem;">Administrador</th>
            <th style="padding: 16px; text-align: left; font-weight: 600; color: #374151; font-size: 0.9rem;">Motivo</th>
            <th style="padding: 16px; text-align: left; font-weight: 600; color: #374151; font-size: 0.9rem;">Acciones</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($bans)): ?>
            <?php foreach ($bans as $ban): ?>
              <?php
              $is_expired = !empty($ban['banned_until']) && strtotime($ban['banned_until']) < time();
              $expires_soon = !empty($ban['banned_until']) && (strtotime($ban['banned_until']) - time() < (3 * 24 * 60 * 60));
              $row_class = '';
              if ($is_expired) {
                  $row_class = 'background: #fef2f2;';
              } elseif ($expires_soon) {
                  $row_class = 'background: #fffbeb;';
              }
              ?>
              <tr style="border-bottom: 1px solid #f1f5f9; <?php echo $row_class; ?>">
                <td style="padding: 16px;">
                  <div style="font-weight: 600; color: #1a1d23;"><?php echo htmlspecialchars($ban['nick']); ?></div>
                  <div style="font-size: 0.8rem; color: #64748b;"><?php echo htmlspecialchars($ban['email']); ?></div>
                </td>
                
                <td style="padding: 16px;">
                  <?php if (empty($ban['banned_until'])): ?>
                    <span style="padding: 4px 8px; background: #ef4444; color: white; border-radius: 12px; font-size: 0.8rem; font-weight: 500;">
                      PERMANENTE
                    </span>
                  <?php else: ?>
                    <span style="padding: 4px 8px; background: #f59e0b; color: white; border-radius: 12px; font-size: 0.8rem; font-weight: 500;">
                      TEMPORAL
                    </span>
                    <div style="font-size: 0.75rem; color: #64748b; margin-top: 4px;">
                      <?php echo $ban['ban_duration_days'] ?? '?' ?> días
                    </div>
                  <?php endif; ?>
                </td>
                
                <td style="padding: 16px; font-size: 0.9rem; color: #64748b;">
                  <?php echo !empty($ban['ban_date']) ? date('d/m/Y H:i', strtotime($ban['ban_date'])) : '—'; ?>
                </td>
                
                <td style="padding: 16px;">
                  <?php if (!empty($ban['banned_until'])): ?>
                    <?php
                    $expire_date = date('d/m/Y H:i', strtotime($ban['banned_until']));
                    $time_left = strtotime($ban['banned_until']) - time();
                    $days_left = floor($time_left / (60 * 60 * 24));
                    $hours_left = floor(($time_left % (60 * 60 * 24)) / (60 * 60));
                    ?>
                    <div style="font-weight: 500; color: #1a1d23;"><?php echo $expire_date; ?></div>
                    <div style="font-size: 0.75rem; color: <?php echo $is_expired ? '#ef4444' : ($expires_soon ? '#f59e0b' : '#64748b'); ?>;">
                      <?php if ($is_expired): ?>
                        <strong>EXPIRADO</strong>
                      <?php else: ?>
                        <?php echo $days_left > 0 ? "{$days_left}d {$hours_left}h" : "{$hours_left}h"; ?>
                      <?php endif; ?>
                    </div>
                  <?php else: ?>
                    <span style="color: #94a3b8;">—</span>
                  <?php endif; ?>
                </td>
                
                <td style="padding: 16px; font-size: 0.9rem; color: #64748b;">
                  <?php echo htmlspecialchars($ban['admin_nick'] ?? 'Sistema'); ?>
                </td>
                
                <td style="padding: 16px; font-size: 0.9rem; color: #64748b; max-width: 200px;">
                  <?php if (!empty($ban['ban_reason'])): ?>
                    <div style="word-break: break-word;">
                      <?php echo htmlspecialchars($ban['ban_reason']); ?>
                    </div>
                  <?php else: ?>
                    <span style="color: #94a3b8;">Sin motivo especificado</span>
                  <?php endif; ?>
                </td>
                
                <td style="padding: 16px;">
                  <div style="display: flex; gap: 6px; flex-wrap: wrap;">
                    <a href="<?php echo base_url('/admin/users/profile?id=' . (int)$ban['id']); ?>" 
                       target="_blank"
                       style="padding: 6px 10px; background: #f1f5f9; color: #374151; text-decoration: none; border-radius: 6px; font-size: 0.8rem; border: 1px solid #e2e8f0;">
                      👁️ Perfil
                    </a>
                    
                    <form method="post" action="<?php echo base_url('/admin/users/unban'); ?>" style="margin: 0;">
                      <input type="hidden" name="id" value="<?php echo (int)$ban['id']; ?>">
                      <button type="submit" 
                              style="padding: 6px 10px; background: #10b981; color: white; border: none; border-radius: 6px; font-size: 0.8rem; cursor: pointer;">
                        ✅ Desbanear
                      </button>
                    </form>
                    
                    <?php if (!empty($ban['banned_until']) && !$is_expired): ?>
                      <form method="post" action="<?php echo base_url('/admin/users/status'); ?>" style="margin: 0;">
                        <input type="hidden" name="id" value="<?php echo (int)$ban['id']; ?>">
                        <input type="hidden" name="status" value="banned">
                        <input type="hidden" name="ban_duration" value="0">
                        <input type="hidden" name="ban_reason" value="<?php echo htmlspecialchars($ban['ban_reason'] ?? 'Convertido a permanente'); ?>">
                        <button type="submit" onclick="return confirm('¿Convertir a ban permanente?')" 
                                style="padding: 6px 10px; background: #ef4444; color: white; border: none; border-radius: 6px; font-size: 0.8rem; cursor: pointer;">
                          🔄 Permanente
                        </button>
                      </form>
                    <?php endif; ?>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr>
              <td colspan="7" style="padding: 60px 20px; text-align: center; color: #64748b;">
                <div style="font-size: 3rem; margin-bottom: 16px;">🕊️</div>
                <div style="font-size: 1.2rem; margin-bottom: 8px; font-weight: 500;">No hay usuarios baneados</div>
                <div style="font-size: 0.9rem; color: #94a3b8;">
                  Todos los usuarios están activos en este momento
                </div>
              </td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Información adicional -->
  <div style="margin-top: 24px; display: grid; grid-template-columns: 1fr 1fr; gap: 16px;">
    <div style="padding: 16px; background: #f0f9ff; border: 1px solid #bae6fd; border-radius: 8px;">
      <div style="display: flex; gap: 12px; align-items: start;">
        <div style="font-size: 1.2rem;">💡</div>
        <div>
          <div style="font-weight: 600; color: #0369a1; margin-bottom: 4px;">Tipos de Baneo</div>
          <div style="font-size: 0.9rem; color: #0369a1;">
            • <strong>Temporal</strong>: 1-90 días para infracciones leves<br>
            • <strong>Permanente</strong>: Reincidencias graves<br>
            • Los temporales se levantan automáticamente
          </div>
        </div>
      </div>
    </div>
    
    <div style="padding: 16px; background: #fefce8; border: 1px solid #fef08a; border-radius: 8px;">
      <div style="display: flex; gap: 12px; align-items: start;">
        <div style="font-size: 1.2rem;">🔄</div>
        <div>
          <div style="font-weight: 600; color: #ca8a04; margin-bottom: 4px;">Mantenimiento</div>
          <div style="font-size: 0.9rem; color: #ca8a04;">
            • Revisa baneos expirados regularmente<br>
            • Documenta siempre los motivos<br>
            • Considera escalar temporales a permanentes
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
tr:hover { background: #f8fafc !important; }

button:hover { transform: translateY(-1px); box-shadow: 0 2px 4px rgba(0,0,0,0.1); }

@media (max-width: 768px) {
  section {
    padding: 0 12px !important;
  }
  
  .stats-grid {
    grid-template-columns: 1fr 1fr !important;
  }
}
</style>