<div class="container" style="max-width:1400px;margin:20px auto;padding:0 12px">
  <h1>Panel de Administración</h1>
  
  <!-- Navegación rápida -->
  <div style="display:flex;gap:12px;margin-bottom:24px;flex-wrap:wrap;">
    <a href="<?php echo base_url('/admin/users'); ?>" style="padding:8px 16px;background:var(--primary);color:white;border-radius:6px;text-decoration:none;">Usuarios</a>
    <a href="<?php echo base_url('/admin/photos'); ?>" style="padding:8px 16px;background:var(--primary);color:white;border-radius:6px;text-decoration:none;">Fotos</a>
    <a href="<?php echo base_url('/admin/reports'); ?>" style="padding:8px 16px;background:var(--warning);color:white;border-radius:6px;text-decoration:none;">
      Reportes (<?php echo $stats['reports'] ?? 0; ?>)
    </a>
    <a href="<?php echo base_url('/admin/ban-management'); ?>" style="padding:8px 16px;background:var(--danger);color:white;border-radius:6px;text-decoration:none;">Baneos</a>
    <a href="<?php echo base_url('/admin/system/logs'); ?>" style="padding:8px 16px;background:var(--dark-light);color:white;border-radius:6px;text-decoration:none;">Logs</a>
  </div>
  
  <!-- Estadísticas principales -->
  <div style="display:grid;grid-template-columns:repeat(auto-fit, minmax(200px, 1fr));gap:12px;margin-top:12px">
    <?php foreach([
      'users' => ['label' => 'Usuarios', 'color' => '#6366f1'],
      'photos' => ['label' => 'Fotos', 'color' => '#10b981'],
      'comments' => ['label' => 'Comentarios', 'color' => '#f59e0b'],
      'friends' => ['label' => 'Amistades', 'color' => '#8b5cf6'],
      'reports' => ['label' => 'Reportes Pendientes', 'color' => '#ef4444'],
      'moderators' => ['label' => 'Staff', 'color' => '#06b6d4'],
      'banned_users' => ['label' => 'Usuarios Baneados', 'color' => '#dc2626'],
      'temp_banned_users' => ['label' => 'Baneos Temp.', 'color' => '#ea580c']
    ] as $k => $item): ?>
      <div style="border:1px solid var(--border);border-radius:12px;padding:14px;background:rgba(255,255,255,0.05);">
        <div style="font-size:12px;color:#777"><?php echo $item['label']; ?></div>
        <div style="font-size:28px;font-weight:700;color:<?php echo $item['color']; ?>"><?php echo (int)($stats[$k] ?? 0); ?></div>
      </div>
    <?php endforeach; ?>
  </div>
  
  <!-- Acciones rápidas -->
  <div style="margin-top:32px;display:grid;grid-template-columns:repeat(auto-fit, minmax(300px, 1fr));gap:16px;">
    <div style="border:1px solid var(--border);border-radius:12px;padding:20px;background:rgba(255,255,255,0.05);">
      <h3 style="margin-bottom:16px;">Acciones Rápidas</h3>
      <div style="display:flex;flex-direction:column;gap:8px;">
        <a href="<?php echo base_url('/admin/users?role=admin'); ?>" style="padding:8px 12px;background:rgba(99,102,241,0.2);border-radius:6px;text-decoration:none;color:var(--primary);">
          👑 Ver Administradores
        </a>
        <a href="<?php echo base_url('/admin/users?role=moderator'); ?>" style="padding:8px 12px;background:rgba(245,158,11,0.2);border-radius:6px;text-decoration:none;color:var(--warning);">
          🛡️ Ver Moderadores
        </a>
        <a href="<?php echo base_url('/admin/reports?status=pending'); ?>" style="padding:8px 12px;background:rgba(239,68,68,0.2);border-radius:6px;text-decoration:none;color:var(--danger);">
          ⚠️ Reportes Pendientes (<?php echo $stats['reports'] ?? 0; ?>)
        </a>
        <a href="<?php echo base_url('/admin/ban-management'); ?>" style="padding:8px 12px;background:rgba(220,38,38,0.2);border-radius:6px;text-decoration:none;color:#dc2626;">
          🚫 Gestión de Baneos
        </a>
      </div>
    </div>
    
    <div style="border:1px solid var(--border);border-radius:12px;padding:20px;background:rgba(255,255,255,0.05);">
      <h3 style="margin-bottom:16px;">Actividad Reciente</h3>
      <div style="font-size:14px;color:#94a3b8;">
        <?php
        $DB = nebusa_pdo();
        if ($DB instanceof \PDO) {
          try {
            $st = $DB->query("SELECT event_type, COUNT(*) as count FROM security_events WHERE created_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR) GROUP BY event_type ORDER BY count DESC LIMIT 5");
            $events = $st->fetchAll(\PDO::FETCH_ASSOC);
            if (!empty($events)) {
              foreach($events as $event) {
                echo "<div style='margin-bottom:4px;'>• {$event['event_type']}: {$event['count']}</div>";
              }
            } else {
              echo "<div>No hay actividad reciente</div>";
            }
          } catch (\Throwable $e) {
            echo "<div>No se pudo cargar la actividad</div>";
          }
        }
        ?>
      </div>
    </div>

    <div style="border:1px solid var(--border);border-radius:12px;padding:20px;background:rgba(255,255,255,0.05);">
      <h3 style="margin-bottom:16px;">Moderación</h3>
      <div style="display:flex;flex-direction:column;gap:8px;">
        <a href="<?php echo base_url('/admin/users?status=banned'); ?>" style="padding:8px 12px;background:rgba(220,38,38,0.2);border-radius:6px;text-decoration:none;color:#dc2626;">
          🔴 Usuarios Baneados (<?php echo $stats['banned_users'] ?? 0; ?>)
        </a>
        <!-- CORREGIDO: Cambiado a form para POST -->
        <form method="post" action="<?php echo base_url('/admin/check-expired-bans'); ?>" style="margin:0;">
          <button type="submit" style="width:100%;padding:8px 12px;background:rgba(5,150,105,0.2);border-radius:6px;text-decoration:none;color:#059669;border:none;cursor:pointer;text-align:left;">
            🔄 Revisar Baneos Expirados
          </button>
        </form>
        <a href="<?php echo base_url('/admin/photos'); ?>" style="padding:8px 12px;background:rgba(16,185,129,0.2);border-radius:6px;text-decoration:none;color:#10b981;">
          🖼️ Moderar Fotos
        </a>
      </div>
    </div>
  </div>
</div>