<?php
use Thirty\controllers\AuthController;
use Thirty\controllers\DashboardController;
use Thirty\controllers\FriendsController;
use Thirty\controllers\InvitesController;
use Thirty\controllers\ProfileController;
use Thirty\controllers\PhotoController;
use Thirty\controllers\LikeController;
use Thirty\controllers\CommentController;
use Thirty\controllers\NotificationController;

// Landing
$router->get('/', function(){ 
    if (user()) {
        header('Location: ' . base_url('/dashboard'));
        exit;
    }
    view('landing'); 
});

// Auth
$router->get('/login', [AuthController::class, 'showLogin']);
$router->post('/login', [AuthController::class, 'login']);
$router->get('/register', [AuthController::class, 'showRegister']);
$router->post('/register', [AuthController::class, 'register']);
$router->post('/logout', [AuthController::class, 'logout']);

// App
$router->get('/dashboard', [DashboardController::class, 'show']);

// Friends
$router->get('/friends', [FriendsController::class, 'index']);
$router->get('/friends/search', [FriendsController::class, 'search']);
$router->post('/friends/request', [FriendsController::class, 'request']);
$router->post('/friends/accept', [FriendsController::class, 'accept']);
$router->post('/friends/reject', [FriendsController::class, 'reject']);
$router->post('/friends/cancel', [FriendsController::class, 'cancel']);
$router->post('/friends/unfriend', [FriendsController::class, 'unfriend']);

// Invites
$router->get('/invites', [InvitesController::class, 'index']);
$router->post('/invites/create', [InvitesController::class, 'create']);
$router->post('/invites/revoke', [InvitesController::class, 'revoke']);

// Profile
$router->get('/profile', [ProfileController::class, 'show']);
$router->post('/profile/check-email', [ProfileController::class, 'checkEmail']);
$router->post('/profile/check-nick', [ProfileController::class, 'checkNick']);
$router->post('/profile/avatar', function(){
    \Thirty\controllers\ProfileController::updateAvatar();
});
$router->get('/profile/edit', function(){
    \Thirty\controllers\ProfileController::edit();
});
$router->post('/profile/update', function(){
    \Thirty\controllers\ProfileController::update();
});

// Photos
$router->get('/photos/upload', [PhotoController::class, 'form']);
$router->post('/photos/upload', [PhotoController::class, 'upload']);
$router->get('/photos/mine', [PhotoController::class, 'mine']);
$router->post('/photos/update', [PhotoController::class, 'update']);
$router->post('/photos/delete', [PhotoController::class, 'delete']);

// Fotos individuales
$router->get('/photo', function() {
    $id = (int)($_GET['id'] ?? 0);
    if ($id <= 0) {
        http_response_code(404);
        echo "Foto no encontrada";
        return;
    }
    PhotoController::show($id);
});

$router->post('/photo/like', function() {
    $id = (int)($_POST['photo_id'] ?? 0);
    if ($id <= 0) {
        http_response_code(404);
        echo "Foto no encontrada";
        return;
    }
    PhotoController::like($id);
});

$router->post('/photo/comment', function() {
    $id = (int)($_POST['photo_id'] ?? 0);
    if ($id <= 0) {
        http_response_code(404);
        echo "Foto no encontrada";
        return;
    }
    PhotoController::comment($id);
});

// Likes y comentarios
$router->post('/like/toggle', [LikeController::class, 'toggle']);
$router->post('/comment/add', [CommentController::class, 'add']);
$router->post('/photo/delete_comment', [PhotoController::class, 'delete_comment']);

// Notifications
$router->get('/notifications', [NotificationController::class, 'index']);
$router->get('/notifications/stream', [NotificationController::class, 'stream']);
$router->post('/notifications/mark-read', [NotificationController::class, 'mark_read']);
$router->get('/notifications/unread-count', [NotificationController::class, 'unread_count']);
$router->get('/notifications/latest', [NotificationController::class, 'latest']);
$router->post('/notifications/mark-all-json', [NotificationController::class, 'mark_all_read_json']);
$router->get('/notifications/redirect', [NotificationController::class, 'redirect_to_content']);
$router->post('/notifications/delete', [NotificationController::class, 'delete']);
$router->post('/notifications/delete-all-read', [NotificationController::class, 'delete_all_read']);

// ==================== RUTAS DE UBICACIÓN ====================
$router->get('/location/provinces', function() {
    global $DB;
    try {
        $stmt = $DB->query("SELECT code, name FROM provinces ORDER BY name");
        $provinces = $stmt->fetchAll();
        
        header('Content-Type: application/json');
        echo json_encode([
            'success' => true,
            'data' => $provinces
        ]);
    } catch (\Exception $e) {
        error_log("Error getting provinces: " . $e->getMessage());
        header('Content-Type: application/json');
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'error' => 'Error cargando provincias'
        ]);
    }
});

$router->get('/location/municipalities', function() {
    global $DB;
    $provinceCode = $_GET['province'] ?? '';
    
    if (empty($provinceCode)) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'error' => 'Código de provincia requerido'
        ]);
        return;
    }
    
    try {
        $stmt = $DB->prepare("SELECT code, name FROM municipalities WHERE province_code = ? ORDER BY name");
        $stmt->execute([$provinceCode]);
        $municipalities = $stmt->fetchAll();
        
        header('Content-Type: application/json');
        echo json_encode([
            'success' => true,
            'data' => $municipalities
        ]);
    } catch (\Exception $e) {
        error_log("Error getting municipalities: " . $e->getMessage());
        header('Content-Type: application/json');
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'error' => 'Error cargando municipios'
        ]);
    }
});

$router->get('/location/postal-codes', function() {
    global $DB;
    $municipalityCode = $_GET['municipality'] ?? '';
    
    if (empty($municipalityCode)) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'error' => 'Código de municipio requerido'
        ]);
        return;
    }
    
    try {
        $stmt = $DB->prepare("SELECT code FROM postal_codes WHERE municipality_code = ? ORDER BY code");
        $stmt->execute([$municipalityCode]);
        $postalCodes = $stmt->fetchAll();
        
        header('Content-Type: application/json');
        echo json_encode([
            'success' => true,
            'data' => $postalCodes
        ]);
    } catch (\Exception $e) {
        error_log("Error getting postal codes: " . $e->getMessage());
        header('Content-Type: application/json');
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'error' => 'Error cargando códigos postales'
        ]);
    }
});



use Thirty\controllers\AdminController;
$router->get('/admin', [AdminController::class, 'dashboard']);
$router->get('/admin/users', [AdminController::class, 'users']);
$router->post('/admin/users/role', [AdminController::class, 'users_update_role']);
$router->post('/admin/users/status', [AdminController::class, 'users_update_status']);
$router->get('/admin/photos', [AdminController::class, 'photos']);
$router->post('/admin/photos/update_status', [AdminController::class, 'photos_update_status']);
$router->post('/admin/photos/delete', [AdminController::class, 'photos_delete']);
$router->get('/admin/ban-management', [AdminController::class, 'ban_management']);
$router->post('/admin/check-expired-bans', [AdminController::class, 'check_expired_bans']);
$router->post('/admin/users/unban', [AdminController::class, 'users_unban']);

// NUEVA RUTA PARA VER PERFILES COMO ADMIN
$router->get('/admin/users/profile', [AdminController::class, 'view_user_profile']);

// Reports
$router->get('/admin/reports', [AdminController::class, 'reports']);
$router->post('/admin/reports/update', [AdminController::class, 'reports_update']);

// Logs del sistema
$router->get('/admin/system/logs', [AdminController::class, 'system_logs']);

$router->post('/admin/photos/set-status', [AdminController::class, 'photos_set_status']);
// Detalle de usuario
$router->get('/admin/users/detail', [AdminController::class, 'user_detail']);