<?php
namespace Thirty\controllers;

require_once __DIR__ . '/../admin_guard.php';

class ModeratorController {
    public static function dashboard(){
        require_moderator();
        $DB = nebusa_pdo();
        $stats = [
            'pending_reports' => 0,
            'recent_photos' => 0,
            'recent_comments' => 0
        ];
        
        if ($DB instanceof \PDO) {
          try { 
            $stats['pending_reports'] = (int)$DB->query("SELECT COUNT(*) FROM reports WHERE status = 'pending'")->fetchColumn(); 
            $stats['recent_photos'] = (int)$DB->query("SELECT COUNT(*) FROM photos WHERE created_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR)")->fetchColumn(); 
            $stats['recent_comments'] = (int)$DB->query("SELECT COUNT(*) FROM comments WHERE created_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR)")->fetchColumn();
          } catch (\Throwable $e) {}
        }
        
        include __DIR__ . '/../views/partials/admin_header.php';
        include __DIR__ . '/../views/moderator/dashboard.php';
        include __DIR__ . '/../views/partials/admin_footer.php';
    }
    
    public static function reports(){
        require_moderator();
        $DB = nebusa_pdo();
        $reports = [];
        
        if ($DB instanceof \PDO) {
          $st = $DB->query("
            SELECT r.*, 
                   u_reporter.nick as reporter_nick,
                   u_reported.nick as reported_nick,
                   p.caption as photo_caption
            FROM reports r
            LEFT JOIN users u_reporter ON u_reporter.id = r.reporter_user_id
            LEFT JOIN users u_reported ON u_reported.id = r.reported_user_id
            LEFT JOIN photos p ON p.id = r.target_id AND r.target_type = 'photo'
            WHERE r.status = 'pending'
            ORDER BY r.created_at DESC
            LIMIT 100
          ");
          $reports = $st->fetchAll(\PDO::FETCH_ASSOC);
        }
        
        include __DIR__ . '/../views/partials/admin_header.php';
        include __DIR__ . '/../views/moderator/reports.php';
        include __DIR__ . '/../views/partials/admin_footer.php';
    }
    
    public static function photos(){
        require_moderator();
        $DB = nebusa_pdo();
        $photos = [];
        
        if ($DB instanceof \PDO) {
          $st = $DB->query("
            SELECT p.id, p.user_id, p.caption, p.path, p.created_at, 
                   u.nick, u.email,
                   (SELECT COUNT(*) FROM reports WHERE target_type='photo' AND target_id=p.id AND status='pending') as pending_reports
            FROM photos p 
            JOIN users u ON u.id=p.user_id 
            WHERE p.status = 'active'
            ORDER BY pending_reports DESC, p.created_at DESC 
            LIMIT 100
          ");
          $photos = $st->fetchAll(\PDO::FETCH_ASSOC);
        }
        
        include __DIR__ . '/../views/partials/admin_header.php';
        include __DIR__ . '/../views/moderator/photos.php';
        include __DIR__ . '/../views/partials/admin_footer.php';
    }
    
    public static function moderate_photo(){
        require_moderator();
        $DB = nebusa_pdo();
        $id = (int)($_POST['id'] ?? 0);
        $action = $_POST['action'] ?? '';
        
        if ($id > 0 && $DB instanceof \PDO) {
          if ($action === 'hide') {
            $st = $DB->prepare("UPDATE photos SET status='hidden' WHERE id=?");
            $st->execute([$id]);
            set_flash('Foto oculta correctamente.', 'success');
          } elseif ($action === 'approve') {
            // Marcar reportes relacionados como resueltos
            $DB->prepare("UPDATE reports SET status='resolved', resolved_at=NOW() WHERE target_type='photo' AND target_id=?")
               ->execute([$id]);
            set_flash('Foto aprobada y reportes resueltos.', 'success');
          }
        }
        header('Location: ' . (function_exists('base_url') ? base_url('/moderator/photos') : '/moderator/photos'));
        exit;
    }
}