<?php
if (!function_exists('nebusa_pdo')) {
  function nebusa_pdo() {
    try { 
        if (function_exists('db')) return db(); 
    } catch (\Throwable $e) {}
    
    if (isset($GLOBALS['DB']) && $GLOBALS['DB'] instanceof \PDO) return $GLOBALS['DB'];
    global $DB; 
    if (isset($DB) && $DB instanceof \PDO) return $DB;
    
    // Intentar conectar directamente si no hay conexión
    try {
        $host = $_ENV['DB_HOST'] ?? 'localhost';
        $dbname = $_ENV['DB_NAME'] ?? 'nebusa';
        $user = $_ENV['DB_USER'] ?? 'root';
        $pass = $_ENV['DB_PASS'] ?? '';
        
        return new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    } catch (Exception $e) {
        return null;
    }
  }
}

if (!function_exists('get_user_role')) {
  function get_user_role() {
    // Primero verificar si tenemos el rol en la sesión
    $u = function_exists('user') ? user() : (isset($_SESSION['user']) ? $_SESSION['user'] : null);
    
    if (!$u) return 'guest';
    
    // Si ya tenemos el rol en la sesión, usarlo
    if (isset($u['role']) && in_array($u['role'], ['user', 'moderator', 'admin'])) {
        return $u['role'];
    }
    
    // Si no, buscar en la base de datos
    try {
        $pdo = nebusa_pdo();
        if ($pdo instanceof PDO) {
            $id = (int)($u['id'] ?? 0);
            if ($id > 0) {
                $st = $pdo->prepare("SELECT role FROM users WHERE id = ? LIMIT 1");
                $st->execute([$id]);
                $role = $st->fetchColumn();
                
                if ($role && in_array($role, ['user', 'moderator', 'admin'])) {
                    // Actualizar la sesión con el rol correcto
                    if (isset($_SESSION['user'])) {
                        $_SESSION['user']['role'] = $role;
                    }
                    return $role;
                }
            }
        }
    } catch (Throwable $e) {
        error_log("Error getting user role: " . $e->getMessage());
    }
    
    return 'user'; // Por defecto
  }
}

if (!function_exists('is_admin')) {
  function is_admin() {
    return get_user_role() === 'admin';
  }
}

if (!function_exists('is_moderator')) {
  function is_moderator() {
    $role = get_user_role();
    return $role === 'moderator' || $role === 'admin';
  }
}

if (!function_exists('require_admin')) {
  function require_admin() {
    $isLogged = function_exists('user') ? (bool)user() : isset($_SESSION['user']);
    if (!$isLogged) {
      header('Location: ' . (function_exists('base_url') ? base_url('/login') : '/login'));
      exit;
    }
    if (!is_admin()) {
      http_response_code(403);
      echo "<h1 style='font-family: system-ui; padding: 2rem'>403 — Acceso restringido</h1>";
      exit;
    }
  }
}

if (!function_exists('require_moderator')) {
  function require_moderator() {
    $isLogged = function_exists('user') ? (bool)user() : isset($_SESSION['user']);
    if (!$isLogged) {
      header('Location: ' . (function_exists('base_url') ? base_url('/login') : '/login'));
      exit;
    }
    if (!is_moderator()) {
      http_response_code(403);
      echo "<h1 style='font-family: system-ui; padding: 2rem'>403 — Acceso restringido</h1>";
      exit;
    }
  }
}

if (!function_exists('require_admin_or_moderator')) {
  function require_admin_or_moderator() {
    $logged = function_exists('user') ? (bool)user() : isset($_SESSION['user']);
    if (!$logged) {
      header('Location: ' . (function_exists('base_url') ? base_url('/login') : '/login'));
      exit;
    }
    if (!(function_exists('is_admin') && is_admin()) && !(function_exists('is_moderator') && is_moderator())) {
      http_response_code(403);
      echo "<h1 style='font-family: system-ui; padding: 2rem'>403 — Acceso restringido</h1>";
      exit;
    }
  }
}
