
// Basic notification polling for production (no framework needed)
(function () {
  const POLL_MS = 15000;
  const bell = document.querySelector('[data-notify-bell]');
  const badge = document.querySelector('[data-notify-count]');
  const list = document.querySelector('[data-notify-list]');

  async function fetchJSON(url) {
    try {
      const res = await fetch(url, { credentials: 'same-origin', headers: { 'Accept': 'application/json' } });
      if (!res.ok) throw new Error('HTTP ' + res.status);
      return await res.json();
    } catch (e) {
      console.error('Notify fetch error:', e);
      return null;
    }
  }

  async function refreshCount() {
    const data = await fetchJSON('/notifications/unread-count');
    if (data && typeof data.count === 'number') {
      if (badge) {
        badge.textContent = String(data.count);
        badge.style.display = data.count > 0 ? 'inline-flex' : 'none';
      }
      if (bell) bell.classList.toggle('has-unread', data.count > 0);
    }
  }

  async function refreshList() {
    if (!list) return;
    const data = await fetchJSON('/notifications/list?limit=10');
    if (!data || !Array.isArray(data.items)) return;
    list.innerHTML = '';
    for (const it of data.items) {
      const li = document.createElement('li');
      li.className = 'notif-item';
      li.innerHTML = `<div class="notif-title">${it.title ?? 'Notificación'}</div>
        <div class="notif-body">${it.body ?? ''}</div>
        <time class="notif-time">${it.time ?? ''}</time>`;
      list.appendChild(li);
    }
  }

  async function cycle() {
    await refreshCount();
    // only refresh list if dropdown/menu is open
    if (document.querySelector('[data-notify-open="true"]')) await refreshList();
  }

  // mark as read when opening menu
  document.addEventListener('click', async (e) => {
    const t = e.target.closest('[data-notify-toggle]');
    if (!t) return;
    const panel = document.querySelector('[data-notify-panel]');
    if (panel) {
      const open = panel.getAttribute('data-notify-open') === 'true';
      panel.setAttribute('data-notify-open', open ? 'false' : 'true');
    }
    const res = await fetch('/notifications/mark-read', { method: 'POST', credentials: 'same-origin' });
    await cycle();
  });

  // initial and interval
  cycle();
  setInterval(cycle, POLL_MS);
})();
