#!/usr/bin/env bash
set -euo pipefail

# ========= CONFIGURA AQUI =========
HOST="${HOST:-localhost}"
DB="${DB:-thirty}"
USER="${USER:-Fresh}"
PASS="${PASS:-TU_PASSWORD_AQUI}"
PHP_BIN="${PHP_BIN:-php}"
# PHP_BIN="/usr/bin/php"
# ==================================

BASE="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
CSV_MUN="$BASE/municipalities_full.csv"
CSV_CP="$BASE/postal_codes_full.csv"
IMPORT_PHP="$BASE/import_locations.php"

echo
echo "== 1) Dependencias Python: requests =="
python -c "import requests" 2>/dev/null || python -m pip install --user requests

echo
echo "== 2) Generando municipalities_full.csv =="
python "$BASE/build_municipalities_csv.py"

echo
echo "== 3) Generando postal_codes_full.csv =="
python "$BASE/build_postal_codes_csv.py"

echo
echo "== 4) Importando en MySQL (provincias + municipios + C.P.) =="
"$PHP_BIN" "$IMPORT_PHP" --host="$HOST" --db="$DB" --user="$USER" --pass="$PASS" --seed-provinces --municipalities="$CSV_MUN" --postalcodes="$CSV_CP"

echo
echo "==== TODO LISTO ===="
