<?php
// import_locations.php - Script para importar ubicaciones de España

// Configuración de la base de datos (ajusta según tu proyecto)
$host = 'localhost';
$dbname = 'thirty'; // nombre de tu base de datos
$username = 'Fresh'; // tu usuario de MySQL
$password = '9j\V<2&2-f02Pre5(R=~E<$wg}.N:B'; // tu contraseña de MySQL

try {
    // Conexión a la base de datos
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "✅ Conectado a la base de datos\n";
} catch (PDOException $e) {
    die("❌ Error de conexión: " . $e->getMessage());
}

function importSpanishLocations($pdo) {
    echo "🚀 Iniciando importación de ubicaciones de España...\n";
    
    try {
        $pdo->beginTransaction();
        
        // 1. Importar Provincias
        echo "📦 Importando provincias...\n";
        $provinces = [
            ['01', 'Araba/Álava'],
            ['02', 'Albacete'],
            ['03', 'Alicante'],
            ['04', 'Almería'],
            ['05', 'Ávila'],
            ['06', 'Badajoz'],
            ['07', 'Balears, Illes'],
            ['08', 'Barcelona'],
            ['09', 'Burgos'],
            ['10', 'Cáceres'],
            ['11', 'Cádiz'],
            ['12', 'Castellón'],
            ['13', 'Ciudad Real'],
            ['14', 'Córdoba'],
            ['15', 'Coruña, A'],
            ['16', 'Cuenca'],
            ['17', 'Girona'],
            ['18', 'Granada'],
            ['19', 'Guadalajara'],
            ['20', 'Gipuzkoa'],
            ['21', 'Huelva'],
            ['22', 'Huesca'],
            ['23', 'Jaén'],
            ['24', 'León'],
            ['25', 'Lleida'],
            ['26', 'Rioja, La'],
            ['27', 'Lugo'],
            ['28', 'Madrid'],
            ['29', 'Málaga'],
            ['30', 'Murcia'],
            ['31', 'Navarra'],
            ['32', 'Ourense'],
            ['33', 'Asturias'],
            ['34', 'Palencia'],
            ['35', 'Palmas, Las'],
            ['36', 'Pontevedra'],
            ['37', 'Salamanca'],
            ['38', 'Santa Cruz de Tenerife'],
            ['39', 'Cantabria'],
            ['40', 'Segovia'],
            ['41', 'Sevilla'],
            ['42', 'Soria'],
            ['43', 'Tarragona'],
            ['44', 'Teruel'],
            ['45', 'Toledo'],
            ['46', 'Valencia'],
            ['47', 'Valladolid'],
            ['48', 'Bizkaia'],
            ['49', 'Zamora'],
            ['50', 'Zaragoza'],
            ['51', 'Ceuta'],
            ['52', 'Melilla']
        ];
        
        $provinceStmt = $pdo->prepare('INSERT IGNORE INTO provinces (code, name) VALUES (?, ?)');
        $provinceCount = 0;
        foreach ($provinces as $province) {
            try {
                $provinceStmt->execute($province);
                $provinceCount++;
            } catch (PDOException $e) {
                echo "⚠️ Error con provincia {$province[0]}: " . $e->getMessage() . "\n";
            }
        }
        echo "✅ $provinceCount provincias importadas\n";
        
        // 2. Importar algunos municipios de ejemplo
        echo "🏘️ Importando municipios...\n";
        $municipalities = [
            // Madrid (28)
            ['28079', 'Madrid', '28'],
            ['28080', 'Alcalá de Henares', '28'],
            ['28081', 'Getafe', '28'],
            ['28082', 'Móstoles', '28'],
            ['28083', 'Leganés', '28'],
            ['28084', 'Alcorcón', '28'],
            ['28085', 'Fuenlabrada', '28'],
            
            // Barcelona (08)
            ['08019', 'Barcelona', '08'],
            ['08020', 'Hospitalet de Llobregat', '08'],
            ['08021', 'Badalona', '08'],
            ['08022', 'Sabadell', '08'],
            ['08023', 'Tarrasa', '08'],
            ['08024', 'Mataró', '08'],
            ['08025', 'Santa Coloma de Gramenet', '08'],
            
            // Valencia (46)
            ['46070', 'Valencia', '46'],
            ['46071', 'Torrent', '46'],
            ['46072', 'Gandia', '46'],
            ['46073', 'Paterna', '46'],
            ['46074', 'Sagunto', '46'],
            ['46075', 'Alzira', '46'],
            
            // Sevilla (41)
            ['41091', 'Sevilla', '41'],
            ['41092', 'Dos Hermanas', '41'],
            ['41093', 'Alcalá de Guadaíra', '41'],
            ['41094', 'Utrera', '41'],
            ['41095', 'Écija', '41'],
            
            // Otras capitales importantes
            ['50079', 'Zaragoza', '50'],
            ['29067', 'Málaga', '29'],
            ['30030', 'Murcia', '30'],
            ['07040', 'Palma de Mallorca', '07'],
            ['48020', 'Bilbao', '48'],
            ['03014', 'Alicante', '03'],
            ['03015', 'Elche', '03'],
            ['45070', 'Toledo', '45'],
            ['47080', 'Valladolid', '47'],
            ['33044', 'Oviedo', '33'],
            ['36038', 'Pontevedra', '36'],
            ['32054', 'Ourense', '32'],
            ['27028', 'Lugo', '27'],
            ['15030', 'La Coruña', '15'],
            ['31080', 'Pamplona', '31'],
            ['26089', 'Logroño', '26'],
            ['44001', 'Teruel', '44'],
            ['42003', 'Soria', '42'],
            ['34014', 'Palencia', '34'],
            ['37074', 'Salamanca', '37'],
            ['49075', 'Zamora', '49'],
            ['24089', 'León', '24'],
            ['09059', 'Burgos', '09'],
            ['19082', 'Guadalajara', '19'],
            ['16078', 'Cuenca', '16'],
            ['02019', 'Albacete', '02'],
            ['13034', 'Ciudad Real', '13'],
            ['14021', 'Córdoba', '14'],
            ['18087', 'Granada', '18'],
            ['23050', 'Jaén', '23'],
            ['21041', 'Huelva', '21'],
            ['11012', 'Cádiz', '11'],
            ['04013', 'Almería', '04'],
            ['18058', 'Motril', '18']
        ];
        
        $municipalityStmt = $pdo->prepare('INSERT IGNORE INTO municipalities (code, name, province_code) VALUES (?, ?, ?)');
        $municipalityCount = 0;
        foreach ($municipalities as $municipality) {
            try {
                $municipalityStmt->execute($municipality);
                $municipalityCount++;
            } catch (PDOException $e) {
                echo "⚠️ Error con municipio {$municipality[0]}: " . $e->getMessage() . "\n";
            }
        }
        echo "✅ $municipalityCount municipios importados\n";
        
        // 3. Importar códigos postales
        echo "📮 Importando códigos postales...\n";
        $postalCodes = [
            // Madrid
            ['28001', '28079'], ['28002', '28079'], ['28003', '28079'], ['28004', '28079'], ['28005', '28079'],
            ['28006', '28079'], ['28007', '28079'], ['28008', '28079'], ['28009', '28079'], ['28010', '28079'],
            ['28801', '28080'], ['28802', '28080'], ['28803', '28080'], ['28804', '28080'], ['28805', '28080'],
            ['28901', '28081'], ['28902', '28081'], ['28903', '28081'], ['28904', '28081'], ['28905', '28081'],
            ['28931', '28082'], ['28932', '28082'], ['28933', '28082'], ['28934', '28082'], ['28935', '28082'],
            ['28911', '28083'], ['28912', '28083'], ['28913', '28083'], ['28914', '28083'], ['28915', '28083'],
            ['28921', '28084'], ['28922', '28084'], ['28923', '28084'], ['28924', '28084'], ['28925', '28084'],
            
            // Barcelona
            ['08001', '08019'], ['08002', '08019'], ['08003', '08019'], ['08004', '08019'], ['08005', '08019'],
            ['08006', '08019'], ['08007', '08019'], ['08008', '08019'], ['08009', '08019'], ['08010', '08019'],
            ['08901', '08020'], ['08902', '08020'], ['08903', '08020'], ['08904', '08020'], ['08905', '08020'],
            ['08910', '08021'], ['08911', '08021'], ['08912', '08021'], ['08913', '08021'], ['08914', '08021'],
            ['08201', '08022'], ['08202', '08022'], ['08203', '08022'], ['08204', '08022'], ['08205', '08022'],
            
            // Valencia
            ['46001', '46070'], ['46002', '46070'], ['46003', '46070'], ['46004', '46070'], ['46005', '46070'],
            ['46006', '46070'], ['46007', '46070'], ['46008', '46070'], ['46009', '46070'], ['46010', '46070'],
            ['46900', '46071'], ['46901', '46071'], ['46902', '46071'], ['46903', '46071'],
            ['46700', '46072'], ['46701', '46072'], ['46702', '46072'],
            ['46980', '46073'], ['46981', '46073'], ['46982', '46073'],
            
            // Sevilla
            ['41001', '41091'], ['41002', '41091'], ['41003', '41091'], ['41004', '41091'], ['41005', '41091'],
            ['41006', '41091'], ['41007', '41091'], ['41008', '41091'], ['41009', '41091'], ['41010', '41091'],
            ['41700', '41092'], ['41701', '41092'], ['41702', '41092'],
            ['41500', '41093'], ['41501', '41093'], ['41502', '41093'],
            
            // Otras ciudades
            ['50001', '50079'], ['50002', '50079'], ['50003', '50079'], ['50004', '50079'],
            ['29001', '29067'], ['29002', '29067'], ['29003', '29067'], ['29004', '29067'],
            ['30001', '30030'], ['30002', '30030'], ['30003', '30030'], ['30004', '30030'],
            ['07001', '07040'], ['07002', '07040'], ['07003', '07040'], ['07004', '07040'],
            ['48001', '48020'], ['48002', '48020'], ['48003', '48020'], ['48004', '48020'],
            ['03001', '03014'], ['03002', '03014'], ['03003', '03014'], ['03004', '03014'],
            ['03201', '03015'], ['03202', '03015'], ['03203', '03015']
        ];
        
        $postalStmt = $pdo->prepare('INSERT IGNORE INTO postal_codes (code, municipality_code) VALUES (?, ?)');
        $postalCount = 0;
        foreach ($postalCodes as $postalCode) {
            try {
                $postalStmt->execute($postalCode);
                $postalCount++;
            } catch (PDOException $e) {
                echo "⚠️ Error con código postal {$postalCode[0]}: " . $e->getMessage() . "\n";
            }
        }
        echo "✅ $postalCount códigos postales importados\n";
        
        $pdo->commit();
        
        echo "\n🎉 ¡Importación completada exitosamente!\n";
        echo "📊 Resumen:\n";
        echo "   - Provincias: $provinceCount\n";
        echo "   - Municipios: $municipalityCount\n";
        echo "   - Códigos postales: $postalCount\n";
        echo "\n💡 Ahora puedes usar el formulario de registro con ubicaciones reales.\n";
        
    } catch (Exception $e) {
        $pdo->rollBack();
        echo "❌ Error en la importación: " . $e->getMessage() . "\n";
    }
}

// Verificar que las tablas existen
try {
    $tables = ['provinces', 'municipalities', 'postal_codes'];
    foreach ($tables as $table) {
        $pdo->query("SELECT 1 FROM $table LIMIT 1");
    }
    echo "✅ Todas las tablas existen\n";
    
    // Ejecutar importación
    importSpanishLocations($pdo);
    
} catch (PDOException $e) {
    echo "❌ Error: Una o más tablas no existen. Ejecuta primero el SQL de creación de tablas.\n";
    echo "💡 Asegúrate de que las tablas provinces, municipalities y postal_codes estén creadas.\n";
}