<?php 
// Verificar si la función user() existe y obtener el usuario
$u = function_exists('user') ? user() : null;
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Nebusa</title>
  <link rel="stylesheet" href="<?php echo htmlspecialchars(asset_url('assets/css/app.css')); ?>">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --primary: #6366f1;
      --primary-dark: #4f46e5;
      --secondary: #f8fafc;
      --dark: #0f172a;
      --dark-light: #1e293b;
      --text: #334155;
      --text-light: #64748b;
      --border: #e2e8f0;
      --success: #10b981;
      --warning: #f59e0b;
      --danger: #ef4444;
      --radius: 12px;
      --shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
      --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
    }
    
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
      color: #f8fafc;
      min-height: 100vh;
      line-height: 1.6;
    }
    
    .topbar {
      background: rgba(15, 23, 42, 0.8);
      backdrop-filter: blur(10px);
      border-bottom: 1px solid rgba(255, 255, 255, 0.1);
      padding: 1rem 0;
      position: sticky;
      top: 0;
      z-index: 100;
    }
    
    .topbar .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 0 1.5rem;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    
    .brand {
      font-size: 1.75rem;
      font-weight: 700;
      background: linear-gradient(135deg, #6366f1, #8b5cf6);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }
    
    .topbar nav {
      display: flex;
      align-items: center;
      gap: 1.5rem;
    }
    
    .topbar nav a, .topbar nav button {
      color: #cbd5e1;
      text-decoration: none;
      font-weight: 500;
      font-size: 0.9rem;
      transition: all 0.2s ease;
      padding: 0.5rem 0.75rem;
      border-radius: 8px;
      position: relative;
    }
    
    .topbar nav a:hover, .topbar nav button:hover {
      color: #f8fafc;
      background: rgba(255, 255, 255, 0.05);
    }
    
    .topbar nav a.btn {
      background: var(--primary);
      color: white;
      padding: 0.5rem 1.25rem;
      border-radius: 8px;
    }
    
    .topbar nav a.btn:hover {
      background: var(--primary-dark);
      transform: translateY(-1px);
      box-shadow: var(--shadow);
    }
    
    .bell { position: relative;
      position: relative;
      display: inline-flex;
      align-items: center;
    }
    
    .bell-icon { position: relative;
      display: flex;
      align-items: center;
      justify-content: center;
      width: 40px;
      height: 40px;
      border-radius: 8px;
      transition: all 0.2s ease;
      color: #fcd34d;
      text-decoration: none;
    }
    
    .bell-icon:hover {
      color: #fde047;
      background: rgba(252, 211, 77, 0.1);
      transform: scale(1.1);
    }
    
    .bell-svg {
      width: 20px;
      height: 20px;
      fill: currentColor;
    }
    
    .topbar .bell .badge {
      position: absolute;
      top: -6px;
      right: -6px;
      background: var(--danger);
      color: white;
      font-size: 0.7rem;
      font-weight: 600;
      border-radius: 10px;
      padding: 2px 6px;
      min-width: 18px;
      text-align: center;
      box-shadow: 0 2px 4px rgba(0,0,0,0.2);
      z-index: 1001;
    }
    
    .notif-dropdown {
      position: absolute;
      right: 0;
      top: 100%;
      width: 420px;
      max-width: 90vw;
      background: rgba(30, 41, 59, 0.95);
      backdrop-filter: blur(20px);
      border: 1px solid rgba(255, 255, 255, 0.1);
      border-radius: 12px;
      box-shadow: var(--shadow-lg);
      display: none;
      z-index: 1000;
      margin-top: 8px;
      overflow: hidden;
    }
    
    .notif-dropdown.show {
      display: block;
      animation: fadeIn 0.2s ease;
    }
    
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(-10px); }
      to { opacity: 1; transform: translateY(0); }
    }
    
    .notif-dropdown header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 1rem 1.25rem;
      border-bottom: 1px solid rgba(255, 255, 255, 0.1);
      font-weight: 600;
      background: rgba(15, 23, 42, 0.5);
    }
    
    .notif-dropdown ul {
      list-style: none;
      margin: 0;
      padding: 0;
      max-height: 400px;
      overflow-y: auto;
    }
    
    .notif-item {
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      padding: 1rem 1.25rem;
      border-bottom: 1px solid rgba(255, 255, 255, 0.05);
      transition: background 0.2s ease;
      gap: 0.75rem;
    }
    
    .notif-item:hover {
      background: rgba(255, 255, 255, 0.05);
    }
    
    .notif-item:last-child {
      border-bottom: none;
    }
    
    .notif-content {
      flex: 1;
      min-width: 0;
      cursor: pointer;
    }
    
    .notif-text {
      font-size: 0.9rem;
      line-height: 1.4;
      margin-bottom: 0.25rem;
    }
    
    .notif-time {
      font-size: 0.75rem;
      color: #94a3b8;
    }
    
    .notif-actions {
      display: flex;
      gap: 0.5rem;
      opacity: 0;
      transition: opacity 0.2s ease;
    }
    
    .notif-item:hover .notif-actions {
      opacity: 1;
    }
    
    .notif-delete {
      background: rgba(239, 68, 68, 0.2);
      border: none;
      color: #ef4444;
      width: 28px;
      height: 28px;
      border-radius: 6px;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      font-size: 0.8rem;
      transition: all 0.2s ease;
    }
    
    .notif-delete:hover {
      background: rgba(239, 68, 68, 0.3);
      transform: scale(1.1);
    }
    
    .notif-dropdown .empty {
      padding: 2rem 1.25rem;
      text-align: center;
      color: #94a3b8;
      font-style: italic;
    }
    
    .btn.ghost {
      background: transparent;
      border: 1px solid rgba(255, 255, 255, 0.2);
      color: #cbd5e1;
      padding: 0.375rem 0.75rem;
      font-size: 0.8rem;
    }
    
    .btn.ghost:hover {
      background: rgba(255, 255, 255, 0.1);
      border-color: rgba(255, 255, 255, 0.3);
    }
    
    .linklike {
      background: none;
      border: none;
      cursor: pointer;
      font: inherit;
    }
    
    .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 0 1.5rem;
    }
    
    main.container {
      padding-top: 2rem;
      padding-bottom: 2rem;
      min-height: calc(100vh - 140px);
    }
    
    .flash {
      background: var(--primary);
      color: white;
      padding: 1rem 1.5rem;
      border-radius: var(--radius);
      margin-bottom: 2rem;
      box-shadow: var(--shadow);
      animation: slideIn 0.3s ease;
    }
    
    @keyframes slideIn {
      from { opacity: 0; transform: translateY(-10px); }
      to { opacity: 1; transform: translateY(0); }
    }
    
    .toast-stack {
      position: fixed;
      right: 20px;
      bottom: 20px;
      display: flex;
      flex-direction: column;
      gap: 10px;
      z-index: 10000;
    }
    
    .toast {
      background: rgba(30, 41, 59, 0.95);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(255, 255, 255, 0.1);
      color: #f8fafc;
      padding: 1rem 1.25rem;
      border-radius: 12px;
      min-width: 280px;
      box-shadow: var(--shadow-lg);
      animation: toastIn 0.3s ease;
      transition: all 0.3s ease;
      cursor: pointer;
    }
    
    .toast:hover {
      background: rgba(30, 41, 59, 0.98);
      transform: translateX(-5px);
    }
    
    @keyframes toastIn {
      from { 
        opacity: 0; 
        transform: translateX(100px); 
      }
      to { 
        opacity: 1; 
        transform: translateX(0); 
      }
    }
    
    .toast.fade-out {
      opacity: 0;
      transform: translateX(100px);
    }
    
    @media (max-width: 768px) {
      .topbar .container {
        flex-direction: column;
        gap: 1rem;
      }
      
      .topbar nav {
        flex-wrap: wrap;
        justify-content: center;
        gap: 0.75rem;
      }
      
      .topbar nav a, .topbar nav button {
        font-size: 0.85rem;
        padding: 0.4rem 0.6rem;
      }
      
      .notif-dropdown {
        width: 350px;
        right: -50%;
        transform: translateX(50%);
      }
      
      .toast-stack {
        right: 10px;
        left: 10px;
        bottom: 10px;
      }
      
      .toast {
        min-width: auto;
        width: 100%;
      }
      
      .notif-actions {
        opacity: 1;
      }
    }
    
    @media (max-width: 480px) {
      .notif-dropdown {
        width: 300px;
      }
    }
  
/* Avatars */
.user-avatar { width: 36px; height: 36px; border-radius: 50%; object-fit: cover; display:inline-block; }
.post-avatar .user-avatar { width: 40px; height: 40px; }
.avatar-image { width: 120px; height: 120px; border-radius: 50%; object-fit: cover; }
.avatar-placeholder { width: 36px; height: 36px; border-radius: 50%; display:flex; align-items:center; justify-content:center; font-weight:700; background:#eee; color:#666; }
.profile-avatar .avatar-placeholder { width: 120px; height: 120px; font-size: 42px; }
.comment-avatar { display:inline-block; margin-right:8px; vertical-align:middle; }


/* modal-open guard removed */
</style>
</head>
<body>
<header class="topbar">
  <div class="container">
    <div class="brand">Nebusa</div>
    <nav>
      <a href="<?php echo htmlspecialchars(base_url('/')); ?>">Inicio</a>
      <?php if (isset($u) && $u): ?>
        <a href="<?php echo htmlspecialchars(base_url('/photos/upload')); ?>">Subir foto</a>
        <a href="<?php echo htmlspecialchars(base_url('/friends')); ?>">Amigos</a>
        <a href="<?php echo htmlspecialchars(base_url('/friends/search')); ?>">Buscar</a>
        <a href="<?php echo htmlspecialchars(base_url('/profile')); ?>">Mi perfil</a>
        <a href="<?php echo htmlspecialchars(base_url('/invites')); ?>">Invitaciones</a>
        <span class="bell">
          <a href="<?php echo htmlspecialchars(base_url('/notifications')); ?>" id="notif-bell-link" class="bell-icon">
            <svg class="bell-svg" viewBox="0 0 24 24">
              <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"></path>
              <path d="M13.73 21a2 2 0 0 1-3.46 0"></path>
            </svg>
            <span id="notif-badge" class="badge" style="display:none;">0</span>
          </a>
          <div id="notif-menu" class="notif-dropdown">
            <header>
              <span>Notificaciones</span>
              <a href="<?php echo htmlspecialchars(base_url('/notifications')); ?>" class="btn ghost">Ver todas</a>
            </header>
            <ul id="notif-menu-list">
              <li class="empty">Sin notificaciones</li>
            </ul>
          </div>
        </span>
        <form method="post" action="<?php echo htmlspecialchars(base_url('/logout')); ?>" style="display:inline;">
          <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
          <button type="submit" class="linklike">Salir</button>
        </form>
      <?php else: ?>
        <a href="<?php echo htmlspecialchars(base_url('/login')); ?>">Entrar</a>
        <a href="<?php echo htmlspecialchars(base_url('/register')); ?>" class="btn">Crear cuenta</a>
      <?php endif; ?>
    </nav>
  </div>
</header>
<main class="container">
<?php 
// Verificar si la función get_flash() existe antes de usarla
if (function_exists('get_flash') && $msg = get_flash()): ?>
  <div class="flash"><?php echo htmlspecialchars($msg, ENT_QUOTES, 'UTF-8'); ?></div>
<?php endif; ?>
<div class="toast-stack" id="toast-stack"></div>

<!-- Formulario oculto para eliminar notificaciones -->
<form id="delete-notif-form" method="post" action="<?php echo htmlspecialchars(base_url('/notifications/delete')); ?>" style="display: none;">
  <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
  <input type="hidden" name="id" id="delete-notif-id">
</form>

<script>
// Función global para eliminar notificaciones
function deleteNotification(notifId, element) {
    if (!confirm('¿Eliminar esta notificación?')) return;
    
    // Usar el formulario oculto
    document.getElementById('delete-notif-id').value = notifId;
    document.getElementById('delete-notif-form').submit();
}

(function(){
  <?php if (isset($u) && $u): ?>
  var es = null, lastTick = 0, fallbackTimer = null;
  var bellLink = document.getElementById('notif-bell-link');
  var menu = document.getElementById('notif-menu');
  var list = document.getElementById('notif-menu-list');
  var badge = document.getElementById('notif-badge');
  var stack = document.getElementById('toast-stack');

  function setBadge(n){
    if(!badge) return;
    badge.textContent = String(n);
    badge.style.display = n > 0 ? 'inline-block' : 'none';
  }

  function humanize(it){
    try{
      var t = it.type, p = it.payload || {};
      if(t === 'like') return 'Me gusta en tu publicación';
      if(t === 'comment') return 'Comentario en tu publicación: ' + (p.body ? p.body.substring(0, 50) + (p.body.length > 50 ? '...' : '') : '');
      if(t === 'friend_request') return 'Nueva solicitud de amistad';
      if(t === 'friend_accept') return 'Han aceptado tu solicitud de amistad';
      return 'Notificación';
    }catch(e){
      return 'Notificación';
    }
  }

  function getNotificationUrl(notif){
    try{
      var t = notif.type, p = notif.payload || {};
      
      if(t === 'like' && p.post_id) 
        return '<?php echo base_url('/photo'); ?>?id=' + p.post_id;
      
      if(t === 'comment' && p.post_id) 
        return '<?php echo base_url('/photo'); ?>?id=' + p.post_id;
      
      // SOLUCIÓN DEFINITIVA: Para notificaciones de amistad, redirigir a la vista de amigos
      if(t === 'friend_request' || t === 'friend_accept') 
        return '<?php echo base_url('/friends'); ?>';
      
      return '<?php echo base_url('/notifications'); ?>';
    }catch(e){
      console.error('Error en getNotificationUrl:', e);
      return '<?php echo base_url('/notifications'); ?>';
    }
  }

  async function pushToast(notif){
    if(!stack) return;
    
    await fetchUnreadCount();
    
    var d = document.createElement('div');
    d.className = 'toast';
    d.textContent = humanize(notif);
    d.onclick = function(){
      window.location.href = getNotificationUrl(notif);
    };
    stack.appendChild(d);
    
    setTimeout(() => { 
      d.classList.add('fade-out');
      setTimeout(() => d.remove(), 300); 
    }, 4000);
  }

  async function fetchUnreadCount(){
    try{
      const res = await fetch('<?php echo htmlspecialchars(base_url('/notifications/unread-count')); ?>?t=' + Date.now(), {
        cache: 'no-store',
        headers: {
          'X-Requested-With': 'XMLHttpRequest'
        }
      });
      const json = await res.json();
      if(json && json.ok === true) {
        setBadge(json.count || 0);
      }
    }catch(e){
      console.error('Error fetching unread count:', e);
    }
  }

  async function fetchLatest(){
    try{
      const res = await fetch('<?php echo htmlspecialchars(base_url('/notifications/latest')); ?>?t=' + Date.now(), {
        cache: 'no-store',
        headers: {
          'X-Requested-With': 'XMLHttpRequest'
        }
      });
      const json = await res.json();
      if(json && json.ok === true){
        var items = json.items || [];
        if(items.length === 0){
          list.innerHTML = '<li class="empty">Sin notificaciones</li>';
        } else {
          list.innerHTML = items.map(function(it){
            var url = getNotificationUrl(it);
            var timeText = it.created_at ? new Date(it.created_at).toLocaleTimeString('es-ES', {hour: '2-digit', minute: '2-digit'}) : '';
            var isUnread = !it.read_at;
            
            return '<li class="notif-item ' + (isUnread ? 'unread' : 'read') + '">' +
                     '<div class="notif-content" onclick="window.location.href=\'' + url + '\'">' +
                       '<div class="notif-text">' + humanize(it) + '</div>' +
                       '<div class="notif-time">' + timeText + '</div>' +
                     '</div>' +
                     '<div class="notif-actions">' +
                       '<button type="button" class="notif-delete" onclick="event.stopPropagation(); deleteNotification(' + it.id + ', this)">X</button>' +
                     '</div>' +
                   '</li>';
          }).join('');
        }
        setBadge(json.unread_count || 0);
      }
    }catch(e){
      console.error('Error fetching notifications:', e);
    }
  }

  async function markAllAsRead(){
    try{
      const res = await fetch('<?php echo htmlspecialchars(base_url('/notifications/mark-all-json')); ?>', {
        method: 'POST', 
        headers: {
          'X-Requested-With': 'XMLHttpRequest',
          'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: '_csrf=<?php echo htmlspecialchars(csrf_token()); ?>'
      });
      const json = await res.json();
      if(json && json.ok === true){
        setBadge(0);
        document.querySelectorAll('.notif-item.unread').forEach(item => {
          item.classList.remove('unread');
          item.classList.add('read');
        });
      }
    }catch(e){
      console.error('Error marking notifications as read:', e);
    }
  }

  if(bellLink) {
    bellLink.addEventListener('click', function(e){
      e.preventDefault();
      menu.classList.toggle('show');
      if(menu.classList.contains('show')){
        fetchLatest();
        markAllAsRead();
      }
    });
  }

  document.addEventListener('click', function(ev){
    if(menu && !menu.contains(ev.target) && ev.target !== bellLink && !bellLink.contains(ev.target)){
      menu.classList.remove('show');
    }
  });

  function startFallback(){
    if(fallbackTimer) return;
    console.warn('[Thirty] SSE inestable; activando polling.');
    fallbackTimer = setInterval(async function(){
      try{
        await fetchUnreadCount();
      }catch(e){
        console.error('Error in fallback:', e);
      }
    }, 8000);
  }

  function stopFallback(){
    if(fallbackTimer){
      clearInterval(fallbackTimer);
      fallbackTimer = null;
    }
  }

  function startSSE(){
    if(es || document.hidden) return;
    try{
      es = new EventSource('<?php echo htmlspecialchars(base_url('/notifications/stream')); ?>?last_id=0&t=' + Date.now());
      
      es.addEventListener('open', function(){
        console.log('[Thirty] SSE conectado');
        lastTick = Date.now();
        stopFallback();
        fetchUnreadCount();
      });
      
      es.addEventListener('error', function(){
        console.warn('[Thirty] SSE error');
        startFallback();
      });

      es.addEventListener('init', function(ev){
        try{
          var data = JSON.parse(ev.data || '{}');
          if(typeof data.unread === 'number') {
            setBadge(data.unread);
          }
          lastTick = Date.now();
        }catch(e){
          console.error('Error parsing init event:', e);
        }
      });

      es.addEventListener('notify', function(ev){
        try{
          var data = JSON.parse(ev.data || '{}');
          console.log('[Thirty] Notify:', data);
          fetchUnreadCount();
          pushToast(data);
          lastTick = Date.now();
        }catch(e){
          console.error('Error parsing notify event:', e);
        }
      });

      setInterval(function(){
        if(!es) return;
        if(Date.now() - lastTick > 20000) startFallback();
      }, 5000);

    }catch(e){
      console.error('SSE failed:', e);
      startFallback();
    }
  }

  function stopSSE(){
    if(es){
      es.close();
      es = null;
    }
  }

  document.addEventListener('visibilitychange', function(){
    if(document.hidden){
      stopSSE();
      startFallback();
    } else {
      stopFallback();
      startSSE();
    }
  });

  window.addEventListener('load', function(){
    fetchUnreadCount();
    setTimeout(startSSE, 400);
  });
  <?php endif; ?>
})();
</script>