<?php require_once __DIR__ . '/_admin_head.php'; ?>
<div class="toolbar"><h1>Usuarios</h1><div class="actions"><a href="/admin" class="btn">Dashboard</a></div></div>
<form class="controls" method="get">
  <input type="text" name="q" value="<?= htmlspecialchars($_GET['q'] ?? '') ?>" placeholder="Buscar por email o ID">
  <select name="role">
    <option value="">Rol (todos)</option>
    <?php foreach(['user','admin','moderator'] as $r): ?>
      <option value="<?= $r ?>" <?= (($_GET['role'] ?? '')===$r)?'selected':'' ?>><?= $r ?></option>
    <?php endforeach; ?>
  </select>
  <select name="active">
    <option value="">Estado</option>
    <option value="1" <?= (($_GET['active'] ?? '')==='1')?'selected':'' ?>>Activo</option>
    <option value="0" <?= (($_GET['active'] ?? '')==='0')?'selected':'' ?>>Inactivo</option>
  </select>
  <button class="btn btn-primary">Filtrar</button>
  <a class="btn" href="<?= strtok($_SERVER['REQUEST_URI'],'?') ?>">Limpiar</a>
</form>

<form method="post" action="/admin/users/bulk">
  <?php require_once __DIR__ . '/../../lib/csrf.php'; echo csrf_field(); ?>
  <div class="controls">
    <select name="action" required>
      <option value="">Acción en bloque</option>
      <option value="activate">Activar</option>
      <option value="deactivate">Desactivar</option>
      <option value="make_admin">Hacer admin</option>
    </select>
    <button class="btn btn-primary">Aplicar</button>
  </div>

  <div class="table-wrap"><table class="table">
    <thead><tr><th></th><th>ID</th><th>Email</th><th>Rol</th><th>Activo</th><th>Creado</th></tr></thead>
    <tbody>
    <?php foreach(($rows ?? []) as $r): ?>
      <tr>
        <td data-label="Sel."><input class="chk" type="checkbox" name="ids[]" value="<?= (int)$r['id'] ?>"></td>
        <td data-label="ID"><?= (int)$r['id'] ?></td>
        <td data-label="Email"><?= htmlspecialchars($r['email'] ?? '') ?></td>
        <td data-label="Rol"><?= htmlspecialchars($r['role'] ?? 'user') ?></td>
        <td data-label="Activo"><?= (int)($r['is_active'] ?? 1) ?></td>
        <td data-label="Creado"><?= htmlspecialchars($r['created_at'] ?? '') ?></td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table></div>
</form>
<?php require_once __DIR__ . '/_admin_foot.php'; ?>