<?php require_once __DIR__ . '/_admin_head.php'; ?>
<div class="toolbar"><h1>Reportes / Denuncias</h1><div class="actions"><a href="/admin/content" class="btn">Revisar contenido</a></div></div>
<div class="table-wrap"><table class="table">
  <thead><tr><th>ID</th><th>Reportante</th><th>Tipo</th><th>Target</th><th>Motivo</th><th>Estado</th><th>Fecha</th><th>Acciones</th></tr></thead>
  <tbody>
  <?php foreach(($rows ?? []) as $r): ?>
    <tr>
      <td data-label="ID"><?= (int)$r['id'] ?></td>
      <td data-label="Reportante"><?= (int)$r['reporter_id'] ?></td>
      <td data-label="Tipo"><?= htmlspecialchars($r['target_type'] ?? '') ?></td>
      <td data-label="Target"><?= (int)$r['target_id'] ?></td>
      <td data-label="Motivo"><?= htmlspecialchars($r['reason'] ?? '') ?></td>
      <td data-label="Estado"><?= htmlspecialchars($r['status'] ?? '') ?></td>
      <td data-label="Fecha"><?= htmlspecialchars($r['created_at'] ?? '') ?></td>
      <td data-label="Acciones">
        <form method="post" action="/admin/reports/resolve">
          <?php require_once __DIR__ . '/../../lib/csrf.php'; echo csrf_field(); ?>
          <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
          <select name="status"><option>resolved</option><option>dismissed</option><option>pending</option></select>
          <button class="btn btn-primary">Actualizar</button>
        </form>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table></div>
<?php require_once __DIR__ . '/_admin_foot.php'; ?>