<?php require_once __DIR__ . '/_admin_head.php'; ?>
<div class="toolbar"><h1>Moderación de contenido</h1><div class="actions"><a href="/admin/reports" class="btn">Ir a reportes</a></div></div>

<h2>Posts</h2>
<div class="table-wrap"><table class="table">
  <thead><tr><th>ID</th><th>User</th><th>Visibilidad</th><th>Texto</th><th>Acciones</th></tr></thead>
  <tbody>
  <?php foreach(($posts ?? []) as $p): ?>
    <tr>
      <td data-label="ID"><?= (int)$p['id'] ?></td>
      <td data-label="User"><?= (int)$p['user_id'] ?></td>
      <td data-label="Visibilidad"><?= htmlspecialchars($p['visibility'] ?? '') ?></td>
      <td data-label="Texto"><?= htmlspecialchars($p['text'] ?? '') ?></td>
      <td data-label="Acciones">
        <form method="post" action="/admin/content/moderate" onsubmit="return confirm('¿Eliminar post?')">
          <?php require_once __DIR__ . '/../../lib/csrf.php'; echo csrf_field(); ?>
          <input type="hidden" name="type" value="post"><input type="hidden" name="id" value="<?= (int)$p['id'] ?>">
          <button class="btn btn-danger" name="action" value="delete">Eliminar</button>
        </form>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table></div>

<h2>Comentarios</h2>
<div class="table-wrap"><table class="table">
  <thead><tr><th>ID</th><th>Post</th><th>User</th><th>Texto</th><th>Fecha</th><th>Acciones</th></tr></thead>
  <tbody>
  <?php foreach(($comments ?? []) as $c): ?>
    <tr>
      <td data-label="ID"><?= (int)$c['id'] ?></td>
      <td data-label="Post"><?= (int)$c['post_id'] ?></td>
      <td data-label="User"><?= (int)$c['user_id'] ?></td>
      <td data-label="Texto"><?= htmlspecialchars($c['body'] ?? '') ?></td>
      <td data-label="Fecha"><?= htmlspecialchars($c['created_at'] ?? '') ?></td>
      <td data-label="Acciones">
        <form method="post" action="/admin/content/moderate" onsubmit="return confirm('¿Eliminar comentario?')">
          <?php require_once __DIR__ . '/../../lib/csrf.php'; echo csrf_field(); ?>
          <input type="hidden" name="type" value="comment"><input type="hidden" name="id" value="<?= (int)$c['id'] ?>">
          <button class="btn btn-danger" name="action" value="delete">Eliminar</button>
        </form>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table></div>
<?php require_once __DIR__ . '/_admin_foot.php'; ?>