<?php
use Thirty\controllers\AuthController;
use Thirty\controllers\DashboardController;
use Thirty\controllers\FriendsController;
use Thirty\controllers\InvitesController;
use Thirty\controllers\ProfileController;
use Thirty\controllers\PhotoController;
use Thirty\controllers\LikeController;
use Thirty\controllers\CommentController;
use Thirty\controllers\NotificationController;

// Landing
$router->get('/', function(){ 
    if (user()) {
        header('Location: ' . base_url('/dashboard'));
        exit;
    }
    view('landing'); 
});

// Auth
$router->get('/login', [AuthController::class, 'showLogin']);
$router->post('/login', [AuthController::class, 'login']);
$router->get('/register', [AuthController::class, 'showRegister']);
$router->post('/register', [AuthController::class, 'register']);
$router->post('/logout', [AuthController::class, 'logout']);

// App
$router->get('/dashboard', [DashboardController::class, 'show']);

// Friends
$router->get('/friends', [FriendsController::class, 'index']);
$router->get('/friends/search', [FriendsController::class, 'search']);
$router->post('/friends/request', [FriendsController::class, 'request']);
$router->post('/friends/accept', [FriendsController::class, 'accept']);
$router->post('/friends/reject', [FriendsController::class, 'reject']);
$router->post('/friends/cancel', [FriendsController::class, 'cancel']);
$router->post('/friends/unfriend', [FriendsController::class, 'unfriend']);

// Invites
$router->get('/invites', [InvitesController::class, 'index']);
$router->post('/invites/create', [InvitesController::class, 'create']);
$router->post('/invites/revoke', [InvitesController::class, 'revoke']);

// Profile
$router->get('/profile', [ProfileController::class, 'show']);
// En tu archivo de rutas (routes.php)
$router->post('/profile/check-email', [ProfileController::class, 'checkEmail']);
$router->post('/profile/check-nick', [ProfileController::class, 'checkNick']);

// Avatar upload
$router->post('/profile/avatar', function(){
    \Thirty\controllers\ProfileController::updateAvatar();
});



$router->get('/profile/edit', function(){
    \Thirty\controllers\ProfileController::edit();
});
$router->post('/profile/update', function(){
    \Thirty\controllers\ProfileController::update();
});

// Photos
$router->get('/photos/upload', [PhotoController::class, 'form']);
$router->post('/photos/upload', [PhotoController::class, 'upload']);
$router->get('/photos/mine', [PhotoController::class, 'mine']);
$router->post('/photos/update', [PhotoController::class, 'update']);
$router->post('/photos/delete', [PhotoController::class, 'delete']);

// Fotos individuales
$router->get('/photo', function() {
    $id = (int)($_GET['id'] ?? 0);
    if ($id <= 0) {
        http_response_code(404);
        echo "Foto no encontrada";
        return;
    }
    PhotoController::show($id);
});

$router->post('/photo/like', function() {
    $id = (int)($_POST['photo_id'] ?? 0);
    if ($id <= 0) {
        http_response_code(404);
        echo "Foto no encontrada";
        return;
    }
    PhotoController::like($id);
});

$router->post('/photo/comment', function() {
    $id = (int)($_POST['photo_id'] ?? 0);
    if ($id <= 0) {
        http_response_code(404);
        echo "Foto no encontrada";
        return;
    }
    PhotoController::comment($id);
});

// Likes y comentarios
$router->post('/like/toggle', [LikeController::class, 'toggle']);
$router->post('/comment/add', [CommentController::class, 'add']);
$router->post('/photo/delete_comment', [PhotoController::class, 'delete_comment']);

// Notifications
$router->get('/notifications', [NotificationController::class, 'index']);
$router->get('/notifications/stream', [NotificationController::class, 'stream']);
$router->post('/notifications/mark-read', [NotificationController::class, 'mark_read']);
$router->get('/notifications/unread-count', [NotificationController::class, 'unread_count']);
$router->get('/notifications/latest', [NotificationController::class, 'latest']);
$router->post('/notifications/mark-all-json', [NotificationController::class, 'mark_all_read_json']);
$router->get('/notifications/redirect', [NotificationController::class, 'redirect_to_content']);
$router->post('/notifications/delete', [NotificationController::class, 'delete']);
$router->post('/notifications/delete-all-read', [NotificationController::class, 'delete_all_read']);

// ==================== RUTAS DE UBICACIÓN ====================
$router->get('/location/provinces', function() {
    global $DB;
    try {
        $stmt = $DB->query("SELECT code, name FROM provinces ORDER BY name");
        $provinces = $stmt->fetchAll();
        
        header('Content-Type: application/json');
        echo json_encode([
            'success' => true,
            'data' => $provinces
        ]);
    } catch (\Exception $e) {
        error_log("Error getting provinces: " . $e->getMessage());
        header('Content-Type: application/json');
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'error' => 'Error cargando provincias'
        ]);
    }
});

$router->get('/location/municipalities', function() {
    global $DB;
    $provinceCode = $_GET['province'] ?? '';
    
    if (empty($provinceCode)) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'error' => 'Código de provincia requerido'
        ]);
        return;
    }
    
    try {
        $stmt = $DB->prepare("SELECT code, name FROM municipalities WHERE province_code = ? ORDER BY name");
        $stmt->execute([$provinceCode]);
        $municipalities = $stmt->fetchAll();
        
        header('Content-Type: application/json');
        echo json_encode([
            'success' => true,
            'data' => $municipalities
        ]);
    } catch (\Exception $e) {
        error_log("Error getting municipalities: " . $e->getMessage());
        header('Content-Type: application/json');
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'error' => 'Error cargando municipios'
        ]);
    }
});

$router->get('/location/postal-codes', function() {
    global $DB;
    $municipalityCode = $_GET['municipality'] ?? '';
    
    if (empty($municipalityCode)) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'error' => 'Código de municipio requerido'
        ]);
        return;
    }
    
    try {
        $stmt = $DB->prepare("SELECT code FROM postal_codes WHERE municipality_code = ? ORDER BY code");
        $stmt->execute([$municipalityCode]);
        $postalCodes = $stmt->fetchAll();
        
        header('Content-Type: application/json');
        echo json_encode([
            'success' => true,
            'data' => $postalCodes
        ]);
    } catch (\Exception $e) {
        error_log("Error getting postal codes: " . $e->getMessage());
        header('Content-Type: application/json');
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'error' => 'Error cargando códigos postales'
        ]);
    }
});


/* Admin autoload (safe) */
if (!function_exists('__admin_require')) {
  function __admin_require() {
    $b = __DIR__;
    @require_once $b . '/maintenance_guard.php';
    @require_once $b . '/admin_guard.php';
    @require_once $b . '/lib/csrf.php';
    @require_once $b . '/lib/pagination.php';
    @require_once $b . '/controllers/AdminController.php';
    @require_once $b . '/controllers/AdminUsersController.php';
    @require_once $b . '/controllers/AdminContentController.php';
    @require_once $b . '/controllers/AdminReportsController.php';
    @require_once $b . '/controllers/AdminAdsController.php';
    @require_once $b . '/controllers/AdminLogsController.php';
    @require_once $b . '/controllers/AdminSettingsController.php';
  }
}
if (isset($router)) {
  __admin_require();
  if (!defined('__ADMIN_ROUTES_REGISTERED__')) {
    define('__ADMIN_ROUTES_REGISTERED__', true);
    $router->get('/admin', function(){ $c = new \Thirty\controllers\AdminController(); return $c->dashboard(); });
    $router->get('/admin/users', function(){ $c = new \Thirty\controllers\AdminUsersController(); return $c->index(); });
    $router->post('/admin/users/bulk', function(){ $c = new \Thirty\controllers\AdminUsersController(); return $c->bulk(); });
    $router->get('/admin/content', function(){ $c = new \Thirty\controllers\AdminContentController(); return $c->index(); });
    $router->post('/admin/content/moderate', function(){ $c = new \Thirty\controllers\AdminContentController(); return $c->moderate(); });
    $router->get('/admin/reports', function(){ $c = new \Thirty\controllers\AdminReportsController(); return $c->index(); });
    $router->post('/admin/reports/resolve', function(){ $c = new \Thirty\controllers\AdminReportsController(); return $c->resolve(); });
    $router->get('/admin/ads', function(){ $c = new \Thirty\controllers\AdminAdsController(); return $c->index(); });
    $router->post('/admin/ads/save', function(){ $c = new \Thirty\controllers\AdminAdsController(); return $c->save(); });
    $router->get('/admin/logs', function(){ $c = new \Thirty\controllers\AdminLogsController(); return $c->index(); });
    $router->get('/admin/settings', function(){ $c = new \Thirty\controllers\AdminSettingsController(); return $c->index(); });
    $router->post('/admin/settings/save', function(){ $c = new \Thirty\controllers\AdminSettingsController(); return $c->save(); });
  }
}
