<?php
namespace Thirty\controllers;

class LocationController {
    
    public static function getProvinces() {
        global $DB;
        
        try {
            $stmt = $DB->query("SELECT code, name FROM provinces ORDER BY name");
            $provinces = $stmt->fetchAll();
            
            header('Content-Type: application/json');
            echo json_encode([
                'success' => true,
                'data' => $provinces
            ]);
            
        } catch (\Exception $e) {
            error_log("Error getting provinces: " . $e->getMessage());
            header('Content-Type: application/json');
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'error' => 'Error loading provinces'
            ]);
        }
    }
    
    public static function getMunicipalities() {
        global $DB;
        $provinceCode = $_GET['province'] ?? '';
        
        if (empty($provinceCode)) {
            header('Content-Type: application/json');
            echo json_encode([
                'success' => false,
                'error' => 'Province code is required'
            ]);
            return;
        }
        
        try {
            $stmt = $DB->prepare("
                SELECT code, name 
                FROM municipalities 
                WHERE province_code = ? 
                ORDER BY name
            ");
            $stmt->execute([$provinceCode]);
            $municipalities = $stmt->fetchAll();
            
            header('Content-Type: application/json');
            echo json_encode([
                'success' => true,
                'data' => $municipalities
            ]);
            
        } catch (\Exception $e) {
            error_log("Error getting municipalities: " . $e->getMessage());
            header('Content-Type: application/json');
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'error' => 'Error loading municipalities'
            ]);
        }
    }
    
    public static function getPostalCodes() {
        global $DB;
        $municipalityCode = $_GET['municipality'] ?? '';
        
        if (empty($municipalityCode)) {
            header('Content-Type: application/json');
            echo json_encode([
                'success' => false,
                'error' => 'Municipality code is required'
            ]);
            return;
        }
        
        try {
            $stmt = $DB->prepare("
                SELECT code 
                FROM postal_codes 
                WHERE municipality_code = ? 
                ORDER BY code
            ");
            $stmt->execute([$municipalityCode]);
            $postalCodes = $stmt->fetchAll();
            
            header('Content-Type: application/json');
            echo json_encode([
                'success' => true,
                'data' => $postalCodes
            ]);
            
        } catch (\Exception $e) {
            error_log("Error getting postal codes: " . $e->getMessage());
            header('Content-Type: application/json');
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'error' => 'Error loading postal codes'
            ]);
        }
    }
}