<?php
namespace Thirty\controllers;
class AdminUsersController {
  public function index(){
    require_once __DIR__ . '/../admin_guard.php'; requireAdmin();
    require_once __DIR__ . '/../lib/pagination.php';
    $pdo = $this->db(); list($page,$per,$off) = paginateParams();

    $q = trim((string)($_GET['q'] ?? ''));
    $role = $_GET['role'] ?? '';
    $active = $_GET['active'] ?? '';

    $where = []; $bind = [];
    if ($q !== '') { $where[] = '(email LIKE ? OR id = ?)'; $bind[] = "%$q%"; $bind[] = (int)$q; }
    if ($role !== '') { $where[] = 'role = ?'; $bind[] = $role; }
    if ($active !== '') { $where[] = 'is_active = ?'; $bind[] = (int)$active; }
    $wsql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';

    $st = $pdo->prepare("SELECT COUNT(*) FROM users $wsql"); $st->execute($bind);
    $total = (int)$st->fetchColumn();

    $st = $pdo->prepare("SELECT id,email,role,is_active,created_at FROM users $wsql ORDER BY created_at DESC LIMIT $per OFFSET $off");
    $st->execute($bind);
    $rows = $st->fetchAll(\PDO::FETCH_ASSOC);

    include __DIR__ . '/../views/admin/users.php';
  }

  public function bulk(){
    require_once __DIR__ . '/../admin_guard.php'; requireAdmin();
    require_once __DIR__ . '/../lib/csrf.php'; csrf_guard();
    $ids = array_map('intval', $_POST['ids'] ?? []);
    $action = $_POST['action'] ?? '';
    if (!$ids) { header('Location: /admin/users'); exit; }
    $pdo = $this->db();
    $in = implode(',', $ids);
    if ($action === 'activate') { $pdo->exec("UPDATE users SET is_active=1 WHERE id IN ($in)"); }
    elseif ($action === 'deactivate') { $pdo->exec("UPDATE users SET is_active=0 WHERE id IN ($in)"); }
    elseif ($action === 'make_admin') { $pdo->exec("UPDATE users SET role='admin' WHERE id IN ($in)"); }
    header('Location: /admin/users'); exit;
  }

  private function db(){
    $dsn = getenv('DB_DSN') ?: 'mysql:host=localhost;dbname=thirty;charset=utf8mb4';
    $user = getenv('DB_USER') ?: 'root'; $pass = getenv('DB_PASS') ?: '';
    return new \PDO($dsn,$user,$pass,[\PDO::ATTR_ERRMODE=>\PDO::ERRMODE_EXCEPTION]);
  }
}
