<?php
namespace Thirty\controllers;
class AdminReportsController {
  public function index(){
    require_once __DIR__ . '/../admin_guard.php'; requireAdmin();
    $pdo=$this->db();
    $rows=$this->safe($pdo,"SELECT id,reporter_id,target_type,target_id,reason,status,created_at FROM reports ORDER BY created_at DESC LIMIT 200");
    include __DIR__ . '/../views/admin/reports.php';
  }
  public function resolve(){
    require_once __DIR__ . '/../admin_guard.php'; requireAdmin();
    require_once __DIR__ . '/../lib/csrf.php'; csrf_guard();
    $pdo=$this->db(); $id=$_POST['id']??null; $status=$_POST['status']??'resolved';
    if ($id){ $pdo->prepare("UPDATE reports SET status=? WHERE id=?")->execute([$status,$id]); }
    header('Location: /admin/reports'); exit;
  }
  private function db(){ $dsn=getenv('DB_DSN')?:'mysql:host=localhost;dbname=thirty;charset=utf8mb4'; $u=getenv('DB_USER')?:'root'; $p=getenv('DB_PASS')?:''; return new \PDO($dsn,$u,$p,[\PDO::ATTR_ERRMODE=>\PDO::ERRMODE_EXCEPTION]); }
  private function safe($pdo,$sql){ try{ return $pdo->query($sql)->fetchAll(\PDO::FETCH_ASSOC); }catch(\Throwable $e){ return []; } }
}
