<?php
namespace Thirty\controllers;
class AdminLogsController {
  public function index(){
    require_once __DIR__ . '/../admin_guard.php'; requireAdmin();
    require_once __DIR__ . '/../lib/pagination.php';
    $pdo=$this->db(); list($page,$per,$off)=paginateParams();
    $level=$_GET['level']??''; $from=$_GET['from']??''; $to=$_GET['to']??'';
    $where=[];$bind=[];
    if($level!==''){ $where[]='level=?'; $bind[]=$level; }
    if($from!==''){ $where[]='created_at>=?'; $bind[]=$from; }
    if($to!==''){ $where[]='created_at<=?'; $bind[]=$to; }
    $wsql=$where?('WHERE '.implode(' AND ',$where)):'';

    if (isset($_GET['export']) && $_GET['export']==='csv'){
      header('Content-Type: text/csv; charset=utf-8');
      header('Content-Disposition: attachment; filename=logs.csv');
      $out=fopen('php://output','w'); fputcsv($out,['created_at','level','message','context']);
      $st=$pdo->prepare("SELECT created_at,level,message,context FROM logs $wsql ORDER BY created_at DESC"); $st->execute($bind);
      while($r=$st->fetch(\PDO::FETCH_ASSOC)) fputcsv($out,$r);
      exit;
    }

    $st=$pdo->prepare("SELECT COUNT(*) FROM logs $wsql"); $st->execute($bind); $total=(int)$st->fetchColumn();
    $st=$pdo->prepare("SELECT created_at,level,message,context FROM logs $wsql ORDER BY created_at DESC LIMIT $per OFFSET $off"); $st->execute($bind);
    $logs=$st->fetchAll(\PDO::FETCH_ASSOC);
    include __DIR__ . '/../views/admin/logs.php';
  }
  private function db(){ $dsn=getenv('DB_DSN')?:'mysql:host=localhost;dbname=thirty;charset=utf8mb4'; $u=getenv('DB_USER')?:'root'; $p=getenv('DB_PASS')?:''; return new \PDO($dsn,$u,$p,[\PDO::ATTR_ERRMODE=>\PDO::ERRMODE_EXCEPTION]); }
}
