<?php
namespace Thirty\controllers;
class AdminContentController {
  public function index(){
    require_once __DIR__ . '/../admin_guard.php'; requireAdmin();
    $pdo = $this->db();
    $posts = $this->safe($pdo, "SELECT id,user_id,text,visibility,created_at FROM posts ORDER BY created_at DESC LIMIT 200");
    $comments = $this->safe($pdo, "SELECT id,post_id,user_id,body,created_at FROM post_comments ORDER BY created_at DESC LIMIT 200");
    include __DIR__ . '/../views/admin/content.php';
  }
  public function moderate(){
    require_once __DIR__ . '/../admin_guard.php'; requireAdmin();
    require_once __DIR__ . '/../lib/csrf.php'; csrf_guard();
    $pdo=$this->db();
    $id=$_POST['id']??null; $type=$_POST['type']??null; $action=$_POST['action']??null;
    if ($id && in_array($type,['post','comment']) && $action==='delete') {
      $table = $type==='post' ? 'posts' : 'post_comments';
      $st=$pdo->prepare("DELETE FROM `$table` WHERE id=?"); $st->execute([$id]);
    }
    header('Location: /admin/content'); exit;
  }
  private function db(){ $dsn=getenv('DB_DSN')?:'mysql:host=localhost;dbname=thirty;charset=utf8mb4'; $u=getenv('DB_USER')?:'root'; $p=getenv('DB_PASS')?:''; return new \PDO($dsn,$u,$p,[\PDO::ATTR_ERRMODE=>\PDO::ERRMODE_EXCEPTION]); }
  private function safe($pdo,$sql){ try{ return $pdo->query($sql)->fetchAll(\PDO::FETCH_ASSOC); }catch(\Throwable $e){ return []; } }
}
