<?php
namespace Thirty\controllers;
class AdminAdsController {
  public function index(){
    require_once __DIR__ . '/../admin_guard.php'; requireAdmin();
    $pdo=$this->db();
    $ads=$this->safe($pdo,"SELECT id,title,type,placement,status,start_at,end_at,created_at FROM ads ORDER BY created_at DESC LIMIT 200");
    include __DIR__ . '/../views/admin/ads.php';
  }
  public function save(){
    require_once __DIR__ . '/../admin_guard.php'; requireAdmin();
    require_once __DIR__ . '/../lib/csrf.php'; csrf_guard();
    $pdo=$this->db();
    $id=$_POST['id']??null; $title=$_POST['title']??''; $type=$_POST['type']??'banner'; $placement=$_POST['placement']??'feed'; $status=$_POST['status']??'inactive'; $start=$_POST['start_at']??null; $end=$_POST['end_at']??null;
    if ($id){ $pdo->prepare("UPDATE ads SET title=?,type=?,placement=?,status=?,start_at=?,end_at=? WHERE id=?")->execute([$title,$type,$placement,$status,$start,$end,$id]); }
    else { $pdo->prepare("INSERT INTO ads(title,type,placement,status,start_at,end_at,created_at) VALUES(?,?,?,?,?,?,NOW())")->execute([$title,$type,$placement,$status,$start,$end]); }
    header('Location: /admin/ads'); exit;
  }
  private function db(){ $dsn=getenv('DB_DSN')?:'mysql:host=localhost;dbname=thirty;charset=utf8mb4'; $u=getenv('DB_USER')?:'root'; $p=getenv('DB_PASS')?:''; return new \PDO($dsn,$u,$p,[\PDO::ATTR_ERRMODE=>\PDO::ERRMODE_EXCEPTION]); }
  private function safe($pdo,$sql){ try{ return $pdo->query($sql)->fetchAll(\PDO::FETCH_ASSOC); }catch(\Throwable $e){ return []; } }
}
