<div class="photo-detail-layout">
    <!-- Foto principal -->
    <div class="photo-main">
        <div class="photo-card">
            <!-- Header de la foto -->
            <div class="photo-header">
                <div class="user-info">
                    <a href="<?php echo htmlspecialchars(base_url('/profile?nick=' . $photo['user_nick'])); ?>" class="user-link">
                        <?php if(!empty($photo['avatar_url'])): ?>
                            <img src="<?php echo htmlspecialchars($photo['avatar_url']); ?>" alt="avatar" class="user-avatar">
                        <?php else: ?>
                            <div class="avatar-placeholder">
                                <?php echo htmlspecialchars(strtoupper(substr($photo['user_nick'],0,1))); ?>
                            </div>
                        <?php endif; ?>
                        <div class="user-details">
                            <strong>@<?php echo htmlspecialchars($photo['user_nick']); ?></strong>
                            <span><?php echo formatDate($photo['created_at']); ?></span>
                        </div>
                    </a>
                </div>
                
                <div class="photo-meta">
                    <span class="visibility <?php echo $photo['visibility']; ?>">
                        <?php echo $photo['visibility'] === 'friends' ? '👥 Amigos' : '🔒 Privado'; ?>
                    </span>
                    
                    <?php if($is_owner): ?>
                        <div class="photo-actions">
                            <button class="btn-icon" onclick="openEditModal(<?php echo (int)$photo['id']; ?>, '<?php echo htmlspecialchars($photo['text'] ?? '', ENT_QUOTES); ?>', '<?php echo htmlspecialchars($photo['visibility']); ?>')" title="Editar">
                                ✏️
                            </button>
                            <button class="btn-icon" onclick="openDeleteModal(<?php echo (int)$photo['id']; ?>)" title="Eliminar">
                                🗑️
                            </button>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Imagen -->
            <div class="photo-image">
                <img 
                    src="<?php echo htmlspecialchars(asset_url($photo['storage_rel_path'])); ?>" 
                    alt="Foto" 
                    class="main-image"
                    onclick="toggleZoom(this)"
                >
                <div class="zoom-hint">Click para ampliar</div>
            </div>

            <!-- Interacciones -->
            <div class="photo-actions-bar">
                <div class="interaction-buttons">
                    <form method="post" action="<?php echo htmlspecialchars(base_url('/photo/like')); ?>" class="like-form">
                        <input type="hidden" name="photo_id" value="<?php echo (int)$photo['id']; ?>">
                        <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
                        <button type="submit" class="action-btn <?php echo $photo['user_liked'] ? 'liked' : ''; ?>">
                            ❤️ <span><?php echo (int)$photo['like_count']; ?></span>
                        </button>
                    </form>
                    
                    <button class="action-btn" onclick="focusCommentInput()">
                        💬 <span><?php echo (int)$photo['comment_count']; ?></span>
                    </button>

                    <button class="action-btn btn-report-photo" onclick="reportPhoto(<?php echo $photo['id']; ?>)" title="Reportar foto">
                        ⚠️
                    </button>
                </div>

                <!-- Lista de personas que dieron like -->
                <?php if($photo['like_count'] > 0): ?>
                    <div class="likes-section">
                        <div class="likes-header">
                            <span class="likes-count"><?php echo (int)$photo['like_count']; ?> me gusta</span>
                            <button class="btn-see-all" onclick="openLikesModal()">
                                <span class="see-all-icon">👁️</span>
                                <span class="see-all-text">Ver todos</span>
                            </button>
                        </div>
                        <div class="likes-preview">
                            <?php 
                            $preview_likes = array_slice($likes, 0, 3);
                            foreach($preview_likes as $like): ?>
                                <div class="like-user">
                                    <a href="<?php echo htmlspecialchars(base_url('/profile?nick=' . $like['nick'])); ?>" class="user-link">
                                        <?php if(!empty($like['avatar_url'])): ?>
                                            <img src="<?php echo htmlspecialchars($like['avatar_url']); ?>" alt="avatar" class="like-avatar">
                                        <?php else: ?>
                                            <div class="avatar-tiny">
                                                <?php echo htmlspecialchars(strtoupper(substr($like['nick'],0,1))); ?>
                                            </div>
                                        <?php endif; ?>
                                    </a>
                                </div>
                            <?php endforeach; ?>
                            <?php if(count($likes) > 3): ?>
                                <div class="like-more">+<?php echo count($likes) - 3; ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(!empty($photo['text'])): ?>
                    <div class="photo-caption">
                        <p><strong>@<?php echo htmlspecialchars($photo['user_nick']); ?></strong> <?php echo htmlspecialchars($photo['text']); ?></p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Formulario de comentarios -->
            <?php if($can_interact): ?>
                <div class="comment-form-section">
                    <form method="post" action="<?php echo htmlspecialchars(base_url('/photo/comment')); ?>" class="comment-form">
                        <input type="hidden" name="photo_id" value="<?php echo (int)$photo['id']; ?>">
                        <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
                        <div class="form-group">
                            <textarea 
                                name="body" 
                                placeholder="Escribe un comentario..." 
                                maxlength="600"
                                rows="2"
                                oninput="updateCharCount(this)"
                            ></textarea>
                            <div class="form-footer">
                                <span class="char-count">0/600</span>
                                <button type="submit" class="btn-primary">Comentar</button>
                            </div>
                        </div>
                    </form>
                </div>
            <?php else: ?>
                <div class="comment-disabled">
                    <p>🔒 Necesitas ser amigo para comentar</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Sección de comentarios -->
    <div class="comments-sidebar">
        <div class="comments-card">
            <div class="comments-header">
                <h3>Comentarios (<?php echo count($comments); ?>)</h3>
            </div>

            <?php if(empty($comments)): ?>
                <div class="no-comments">
                    <div class="no-comments-icon">💬</div>
                    <p>No hay comentarios todavía</p>
                </div>
            <?php else: ?>
                <div class="comments-list">
                    <?php
                    $commentsPerPage = 10;
                    $currentPage = $_GET['comments_page'] ?? 1;
                    $totalComments = count($comments);
                    $totalPages = ceil($totalComments / $commentsPerPage);
                    
                    $mainComments = [];
                    $replies = [];
                    
                    foreach($comments as $comment) {
                        $parentId = $comment['parent_id'];
                        if ($parentId === null || $parentId == 0) {
                            $mainComments[$comment['id']] = $comment;
                        } else {
                            if (!isset($replies[$parentId])) {
                                $replies[$parentId] = [];
                            }
                            $replies[$parentId][] = $comment;
                        }
                    }
                    
                    $mainCommentsKeys = array_keys($mainComments);
                    $startIndex = ($currentPage - 1) * $commentsPerPage;
                    $currentComments = array_slice($mainCommentsKeys, $startIndex, $commentsPerPage, true);
                    
                    foreach($currentComments as $commentId): 
                        $mainComment = $mainComments[$commentId];
                        $commentReplies = isset($replies[$commentId]) ? $replies[$commentId] : [];
                        $replyCount = count($commentReplies);
                        $isCommentOwner = ($mainComment['user_id'] == user()['id']);
                        $isPostOwner = ($photo['owner_id'] == user()['id']);
                        $canDelete = $isCommentOwner || $isPostOwner;
                    ?>
                        <div class="comment-thread">
                            <!-- Comentario principal -->
                            <div class="comment main-comment">
                                <div class="comment-content">
                                    <a href="<?php echo htmlspecialchars(base_url('/profile?nick=' . $mainComment['nick'])); ?>" class="comment-user">
                                        <?php if(!empty($mainComment['avatar_url'])): ?>
                                            <img src="<?php echo htmlspecialchars($mainComment['avatar_url']); ?>" alt="avatar" class="comment-avatar">
                                        <?php else: ?>
                                            <div class="avatar-small">
                                                <?php echo htmlspecialchars(strtoupper(substr($mainComment['nick'],0,1))); ?>
                                            </div>
                                        <?php endif; ?>
                                    </a>
                                    <div class="comment-body">
                                        <div class="comment-meta">
                                            <a href="<?php echo htmlspecialchars(base_url('/profile?nick=' . $mainComment['nick'])); ?>" class="user-link">
                                                <strong>@<?php echo htmlspecialchars($mainComment['nick']); ?></strong>
                                            </a>
                                            <span class="comment-time"><?php echo formatDate($mainComment['created_at']); ?></span>
                                            <?php if($replyCount > 0): ?>
                                                <span class="reply-count-badge"><?php echo $replyCount; ?> respuestas</span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="comment-text" id="comment-text-<?php echo $mainComment['id']; ?>">
                                            <?php 
                                            $text = htmlspecialchars($mainComment['body']);
                                            if (strlen($text) > 120): 
                                            ?>
                                                <span class="comment-preview"><?php echo substr($text, 0, 120); ?>...</span>
                                                <span class="comment-full" style="display: none;"><?php echo $text; ?></span>
                                                <button class="btn-read-more" onclick="toggleCommentText(<?php echo $mainComment['id']; ?>)">
                                                    Ver más
                                                </button>
                                            <?php else: ?>
                                                <?php echo $text; ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="comment-actions">
                                            <?php if($can_interact): ?>
                                                <button class="btn-reply" onclick="toggleReplyForm(<?php echo $mainComment['id']; ?>)">
                                                    Responder
                                                </button>
                                            <?php endif; ?>
                                            <?php if($replyCount > 0): ?>
                                                <button class="btn-toggle-replies" onclick="toggleReplies(<?php echo $mainComment['id']; ?>)">
                                                    <span class="show-text">Ver respuestas</span>
                                                    <span class="hide-text" style="display: none;">Ocultar</span>
                                                </button>
                                            <?php endif; ?>
                                            <div class="comment-actions-meta">
                                                <?php if($canDelete): ?>
                                                    <button class="btn-delete" onclick="deleteComment(<?php echo $mainComment['id']; ?>, '<?php echo htmlspecialchars($mainComment['body']); ?>')">
                                                        🗑️
                                                    </button>
                                                <?php endif; ?>
                                                <button class="btn-report" onclick="reportComment(<?php echo $mainComment['id']; ?>)">
                                                    ⚠️
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Formulario de respuesta -->
                                <?php if($can_interact): ?>
                                    <div id="reply-form-<?php echo $mainComment['id']; ?>" class="reply-form" style="display: none;">
                                        <form method="post" action="<?php echo htmlspecialchars(base_url('/photo/comment')); ?>" class="comment-form">
                                            <input type="hidden" name="photo_id" value="<?php echo (int)$photo['id']; ?>">
                                            <input type="hidden" name="parent_id" value="<?php echo $mainComment['id']; ?>">
                                            <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
                                            <textarea 
                                                name="body" 
                                                placeholder="Escribe una respuesta..." 
                                                maxlength="600"
                                                rows="2"
                                            ></textarea>
                                            <div class="form-footer">
                                                <span class="char-count">0/600</span>
                                                <div class="reply-actions">
                                                    <button type="button" class="btn-cancel" onclick="toggleReplyForm(<?php echo $mainComment['id']; ?>)">Cancelar</button>
                                                    <button type="submit" class="btn-submit">Enviar</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <!-- Respuestas -->
                            <?php if ($replyCount > 0): ?>
                                <div id="replies-<?php echo $mainComment['id']; ?>" class="comment-replies">
                                    <?php foreach($commentReplies as $reply): 
                                        $isReplyOwner = ($reply['user_id'] == user()['id']);
                                        $canDeleteReply = $isReplyOwner || $isPostOwner;
                                    ?>
                                        <div class="comment reply">
                                            <div class="comment-content">
                                                <a href="<?php echo htmlspecialchars(base_url('/profile?nick=' . $reply['nick'])); ?>" class="comment-user">
                                                    <?php if(!empty($reply['avatar_url'])): ?>
                                                        <img src="<?php echo htmlspecialchars($reply['avatar_url']); ?>" alt="avatar" class="comment-avatar">
                                                    <?php else: ?>
                                                        <div class="avatar-small">
                                                            <?php echo htmlspecialchars(strtoupper(substr($reply['nick'],0,1))); ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </a>
                                                <div class="comment-body">
                                                    <div class="comment-meta">
                                                        <a href="<?php echo htmlspecialchars(base_url('/profile?nick=' . $reply['nick'])); ?>" class="user-link">
                                                            <strong>@<?php echo htmlspecialchars($reply['nick']); ?></strong>
                                                        </a>
                                                        <span class="comment-time"><?php echo formatDate($reply['created_at']); ?></span>
                                                    </div>
                                                    <div class="comment-text">
                                                        <?php echo htmlspecialchars($reply['body']); ?>
                                                    </div>
                                                    <div class="comment-actions">
                                                        <div class="comment-actions-meta">
                                                            <?php if($canDeleteReply): ?>
                                                                <button class="btn-delete" onclick="deleteComment(<?php echo $reply['id']; ?>, '<?php echo htmlspecialchars($reply['body']); ?>')">
                                                                    🗑️
                                                                </button>
                                                            <?php endif; ?>
                                                            <button class="btn-report" onclick="reportComment(<?php echo $reply['id']; ?>)">
                                                                ⚠️
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                    
                    <!-- Paginación -->
                    <?php if ($totalPages > 1): ?>
                        <div class="comments-pagination">
                            <?php if ($currentPage > 1): ?>
                                <a href="?id=<?php echo $photo['id']; ?>&comments_page=<?php echo $currentPage - 1; ?>" class="pagination-btn prev">
                                    ← Anteriores
                                </a>
                            <?php endif; ?>
                            
                            <span class="pagination-info">
                                Página <?php echo $currentPage; ?> de <?php echo $totalPages; ?>
                            </span>
                            
                            <?php if ($currentPage < $totalPages): ?>
                                <a href="?id=<?php echo $photo['id']; ?>&comments_page=<?php echo $currentPage + 1; ?>" class="pagination-btn next">
                                    Siguientes →
                                </a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Botón volver -->
<div class="back-button">
    <button onclick="history.back()" class="btn-back">
        <span class="back-icon">←</span>
        <span class="back-text">Volver</span>
    </button>
</div>

<!-- Modal de Likes -->
<div id="likesModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Personas que les gusta</h3>
            <button class="close" onclick="closeLikesModal()">&times;</button>
        </div>
        <div class="modal-body">
            <div class="likes-list">
                <?php if(empty($likes)): ?>
                    <div class="no-likes">
                        <p>Aún no hay me gusta</p>
                    </div>
                <?php else: ?>
                    <?php foreach($likes as $like): ?>
                        <div class="like-item">
                            <a href="<?php echo htmlspecialchars(base_url('/profile?nick=' . $like['nick'])); ?>" class="like-user-link">
                                <?php if(!empty($like['avatar_url'])): ?>
                                    <img src="<?php echo htmlspecialchars($like['avatar_url']); ?>" alt="avatar" class="like-modal-avatar">
                                <?php else: ?>
                                    <div class="avatar-small">
                                        <?php echo htmlspecialchars(strtoupper(substr($like['nick'],0,1))); ?>
                                    </div>
                                <?php endif; ?>
                                <div class="like-user-info">
                                    <strong>@<?php echo htmlspecialchars($like['nick']); ?></strong>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal de eliminación de comentario -->
<div id="deleteCommentModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Eliminar comentario</h3>
            <button class="close" onclick="closeDeleteCommentModal()">&times;</button>
        </div>
        <div class="modal-body">
            <p>¿Estás seguro de que quieres eliminar este comentario?</p>
            <div class="comment-preview" id="commentToDeletePreview"></div>
            <p>Esta acción no se puede deshacer.</p>
        </div>
        <div class="form-actions">
            <button type="button" class="btn-secondary" onclick="closeDeleteCommentModal()">Cancelar</button>
            <button type="button" class="btn-danger" onclick="confirmDeleteComment()">Eliminar</button>
        </div>
    </div>
</div>

<!-- Modales para el propietario -->
<?php if($is_owner): ?>
<div id="editPhotoModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Editar foto</h3>
            <button class="close" onclick="closeEditModal()">&times;</button>
        </div>
        <form method="post" action="<?php echo htmlspecialchars(base_url('/photos/update')); ?>">
            <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
            <input type="hidden" name="photo_id" id="edit_photo_id">
            
            <div class="form-group">
                <label>Descripción</label>
                <textarea name="text" id="edit_photo_text" placeholder="Añade una descripción..." maxlength="500"></textarea>
            </div>
            
            <div class="form-group">
                <label>Visibilidad</label>
                <select name="visibility" id="edit_photo_visibility">
                    <option value="friends">👥 Amigos</option>
                    <option value="private">🔒 Privado</option>
                </select>
            </div>
            
            <div class="form-actions">
                <button type="button" class="btn-secondary" onclick="closeEditModal()">Cancelar</button>
                <button type="submit" class="btn-primary">Guardar</button>
            </div>
        </form>
    </div>
</div>

<div id="deletePhotoModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Eliminar foto</h3>
            <button class="close" onclick="closeDeleteModal()">&times;</button>
        </div>
        <div class="modal-body">
            <p>¿Estás seguro de que quieres eliminar esta foto?</p>
            <p>Esta acción no se puede deshacer.</p>
        </div>
        <form method="post" action="<?php echo htmlspecialchars(base_url('/photos/delete')); ?>">
            <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
            <input type="hidden" name="photo_id" id="delete_photo_id">
            
            <div class="form-actions">
                <button type="button" class="btn-secondary" onclick="closeDeleteModal()">Cancelar</button>
                <button type="submit" class="btn-danger">Eliminar</button>
            </div>
        </form>
    </div>
</div>
<?php endif; ?>

<script>
let commentToDelete = null;

function toggleZoom(img) {
    img.classList.toggle('zoomed');
}

function focusCommentInput() {
    document.querySelector('textarea[name="body"]')?.focus();
}

function updateCharCount(textarea) {
    const counter = textarea.parentElement.querySelector('.char-count');
    if (counter) {
        counter.textContent = textarea.value.length + '/600';
    }
}

function reportPhoto(photoId) {
    alert('Función de reportar foto en desarrollo. Foto ID: ' + photoId);
}

function toggleReplyForm(commentId) {
    const form = document.getElementById('reply-form-' + commentId);
    form.style.display = form.style.display === 'none' ? 'block' : 'none';
}

function toggleCommentText(commentId) {
    const container = document.getElementById('comment-text-' + commentId);
    const preview = container.querySelector('.comment-preview');
    const full = container.querySelector('.comment-full');
    const button = container.querySelector('.btn-read-more');
    
    if (preview.style.display !== 'none') {
        preview.style.display = 'none';
        full.style.display = 'inline';
        button.textContent = 'Ver menos';
    } else {
        preview.style.display = 'inline';
        full.style.display = 'none';
        button.textContent = 'Ver más';
    }
}

function toggleReplies(commentId) {
    const replies = document.getElementById('replies-' + commentId);
    const showText = replies.closest('.comment-thread').querySelector('.show-text');
    const hideText = replies.closest('.comment-thread').querySelector('.hide-text');
    
    if (replies.style.display === 'none') {
        replies.style.display = 'block';
        showText.style.display = 'none';
        hideText.style.display = 'inline';
    } else {
        replies.style.display = 'none';
        showText.style.display = 'inline';
        hideText.style.display = 'none';
    }
}

function deleteComment(commentId, commentText) {
    commentToDelete = commentId;
    document.getElementById('commentToDeletePreview').textContent = commentText;
    document.getElementById('deleteCommentModal').style.display = 'block';
}

function confirmDeleteComment() {
    if (!commentToDelete) return;
    
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '<?php echo htmlspecialchars(base_url("/photo/delete_comment")); ?>';
    
    const csrfInput = document.createElement('input');
    csrfInput.type = 'hidden';
    csrfInput.name = '_csrf';
    csrfInput.value = '<?php echo htmlspecialchars(csrf_token()); ?>';
    
    const commentIdInput = document.createElement('input');
    commentIdInput.type = 'hidden';
    commentIdInput.name = 'comment_id';
    commentIdInput.value = commentToDelete;
    
    form.appendChild(csrfInput);
    form.appendChild(commentIdInput);
    document.body.appendChild(form);
    form.submit();
}

function reportComment(commentId) {
    alert('Función de reporte en desarrollo. Comentario ID: ' + commentId);
}

function closeDeleteCommentModal() {
    document.getElementById('deleteCommentModal').style.display = 'none';
    commentToDelete = null;
}

function openEditModal(photoId, text, visibility) {
    document.getElementById('edit_photo_id').value = photoId;
    document.getElementById('edit_photo_text').value = text || '';
    document.getElementById('edit_photo_visibility').value = visibility;
    document.getElementById('editPhotoModal').style.display = 'block';
}

function closeEditModal() {
    document.getElementById('editPhotoModal').style.display = 'none';
}

function openDeleteModal(photoId) {
    document.getElementById('delete_photo_id').value = photoId;
    document.getElementById('deletePhotoModal').style.display = 'block';
}

function closeDeleteModal() {
    document.getElementById('deletePhotoModal').style.display = 'none';
}

function openLikesModal() {
    document.getElementById('likesModal').style.display = 'block';
}

function closeLikesModal() {
    document.getElementById('likesModal').style.display = 'none';
}

window.onclick = function(event) {
    const modals = document.querySelectorAll('.modal');
    modals.forEach(modal => {
        if (event.target === modal) {
            modal.style.display = 'none';
        }
    });
}
</script>

<style>
/* Layout principal */
.photo-detail-layout {
    display: grid;
    grid-template-columns: 1fr 350px;
    gap: 20px;
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
}

/* Foto principal */
.photo-card {
    background: #1a1d23;
    border: 1px solid #2b3138;
    border-radius: 12px;
    overflow: hidden;
}

.photo-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 16px 20px;
    border-bottom: 1px solid #2b3138;
}

.user-link {
    display: flex;
    align-items: center;
    gap: 12px;
    text-decoration: none;
    color: inherit;
}

.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    object-fit: cover;
}

.avatar-placeholder {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #6366f1, #8b5cf6);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
}

.user-details strong {
    color: #f8fafc;
    font-size: 0.9rem;
}

.user-details span {
    color: #94a3b8;
    font-size: 0.8rem;
}

.photo-meta {
    display: flex;
    align-items: center;
    gap: 12px;
}

.visibility {
    padding: 4px 8px;
    border-radius: 6px;
    font-size: 0.8rem;
    font-weight: 500;
}

.visibility.friends {
    background: rgba(99, 102, 241, 0.1);
    color: #6366f1;
}

.visibility.private {
    background: rgba(100, 116, 139, 0.1);
    color: #64748b;
}

.photo-actions {
    display: flex;
    gap: 8px;
}

.btn-icon {
    background: none;
    border: none;
    padding: 8px;
    border-radius: 6px;
    cursor: pointer;
    font-size: 1rem;
    transition: background 0.2s;
}

.btn-icon:hover {
    background: rgba(255,255,255,0.1);
}

/* Imagen */
.photo-image {
    position: relative;
    background: #000;
    text-align: center;
    display: flex;
    align-items: center;
    justify-content: center;
    min-height: 400px;
}

.main-image {
    max-width: 100%;
    max-height: 70vh;
    object-fit: contain;
    cursor: zoom-in;
}

.main-image.zoomed {
    transform: scale(1.5);
    cursor: zoom-out;
}

.zoom-hint {
    position: absolute;
    bottom: 16px;
    left: 50%;
    transform: translateX(-50%);
    background: rgba(0,0,0,0.7);
    color: white;
    padding: 6px 12px;
    border-radius: 16px;
    font-size: 0.8rem;
    opacity: 0;
    transition: opacity 0.3s;
}

.photo-image:hover .zoom-hint {
    opacity: 1;
}

/* Interacciones */
.photo-actions-bar {
    padding: 16px 20px;
    border-bottom: 1px solid #2b3138;
}

.interaction-buttons {
    display: flex;
    gap: 8px;
    margin-bottom: 12px;
}

.action-btn {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid #2b3138;
    color: #94a3b8;
    cursor: pointer;
    padding: 8px 12px;
    border-radius: 6px;
    font-size: 0.9rem;
    transition: all 0.2s;
    display: flex;
    align-items: center;
    gap: 6px;
}

.action-btn:hover {
    background: rgba(255, 255, 255, 0.1);
}

.action-btn.liked {
    background: rgba(239, 68, 68, 0.1);
    color: #ef4444;
}

.btn-report-photo {
    margin-left: auto;
}

/* Likes */
.likes-section {
    margin: 16px 0;
    padding: 12px 0;
    border-top: 1px solid #2b3138;
}

.likes-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 12px;
}

.likes-count {
    color: #f8fafc;
    font-weight: 600;
}

.btn-see-all {
    background: rgba(99, 102, 241, 0.1);
    border: 1px solid rgba(99, 102, 241, 0.3);
    color: #6366f1;
    cursor: pointer;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 0.8rem;
    display: flex;
    align-items: center;
    gap: 6px;
}

.likes-preview {
    display: flex;
    align-items: center;
    gap: 8px;
}

.like-avatar {
    width: 28px;
    height: 28px;
    border-radius: 50%;
    object-fit: cover;
}

.avatar-tiny {
    width: 28px;
    height: 28px;
    border-radius: 50%;
    background: linear-gradient(135deg, #6366f1, #8b5cf6);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 0.7rem;
}

.like-more {
    width: 28px;
    height: 28px;
    border-radius: 50%;
    background: #2b3138;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #94a3b8;
    font-size: 0.7rem;
}

.photo-caption {
    margin-top: 12px;
}

.photo-caption p {
    margin: 0;
    color: #f8fafc;
}

/* Comentarios compactos */
.comments-sidebar {
    width: 350px;
}

.comments-card {
    background: #1a1d23;
    border: 1px solid #2b3138;
    border-radius: 12px;
    padding: 16px;
}

.comments-header h3 {
    margin: 0 0 16px 0;
    font-size: 1.1rem;
    color: #f8fafc;
}

.comments-list {
    max-height: 600px;
    overflow-y: auto;
}

.comment-thread {
    padding: 12px 0;
    border-bottom: 1px solid #2b3138;
}

.comment-thread:last-child {
    border-bottom: none;
}

.comment-content {
    display: flex;
    gap: 8px;
    align-items: flex-start;
}

.comment-avatar {
    width: 28px;
    height: 28px;
    border-radius: 50%;
    object-fit: cover;
}

.avatar-small {
    width: 28px;
    height: 28px;
    border-radius: 50%;
    background: linear-gradient(135deg, #6366f1, #8b5cf6);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 0.8rem;
}

.comment-body {
    flex: 1;
}

.comment-meta {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 4px;
}

.user-link strong {
    color: #f8fafc;
    font-size: 0.85rem;
}

.comment-time {
    color: #64748b;
    font-size: 0.75rem;
}

.reply-count-badge {
    background: rgba(99, 102, 241, 0.1);
    color: #6366f1;
    padding: 2px 6px;
    border-radius: 4px;
    font-size: 0.7rem;
}

.comment-text {
    color: #e2e8f0;
    font-size: 0.8rem;
    line-height: 1.4;
    margin-bottom: 6px;
}

.comment-actions {
    display: flex;
    align-items: center;
    gap: 8px;
}

.btn-reply, .btn-toggle-replies {
    background: rgba(99, 102, 241, 0.1);
    border: 1px solid rgba(99, 102, 241, 0.3);
    color: #6366f1;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.75rem;
    cursor: pointer;
}

.comment-actions-meta {
    display: flex;
    gap: 4px;
    margin-left: auto;
}

.btn-delete, .btn-report {
    background: none;
    border: none;
    cursor: pointer;
    padding: 4px;
    border-radius: 4px;
    font-size: 0.8rem;
}

.btn-delete {
    color: #ef4444;
}

.btn-report {
    color: #f59e0b;
}

/* Respuestas */
.comment-replies {
    margin: 8px 0 0 36px;
    border-left: 2px solid #374151;
    padding-left: 12px;
    display: none;
}

.comment.reply {
    padding: 8px 0;
}

.comment.reply .comment-avatar,
.comment.reply .avatar-small {
    width: 24px;
    height: 24px;
}

.comment.reply .avatar-small {
    font-size: 0.7rem;
}

.comment.reply .user-link strong {
    font-size: 0.8rem;
}

.comment.reply .comment-time {
    font-size: 0.7rem;
}

.comment.reply .comment-text {
    font-size: 0.75rem;
}

/* Formularios */
.reply-form {
    margin: 8px 0 0 36px;
    padding: 8px;
    background: rgba(43, 49, 56, 0.3);
    border-radius: 6px;
}

.reply-form textarea {
    width: 100%;
    background: #2b3138;
    border: 1px solid #3f4752;
    border-radius: 4px;
    padding: 8px;
    color: #f8fafc;
    font-size: 0.8rem;
    resize: vertical;
    min-height: 50px;
}

.form-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-top: 8px;
}

.char-count {
    color: #64748b;
    font-size: 0.7rem;
}

.reply-actions {
    display: flex;
    gap: 8px;
}

.btn-cancel {
    background: rgba(255,255,255,0.05);
    border: 1px solid #374151;
    color: #94a3b8;
    padding: 6px 12px;
    border-radius: 4px;
    font-size: 0.8rem;
    cursor: pointer;
}

.btn-submit {
    background: #6366f1;
    color: white;
    border: none;
    padding: 6px 12px;
    border-radius: 4px;
    font-size: 0.8rem;
    cursor: pointer;
}

.comment-form-section {
    padding: 16px 20px;
}

.comment-form textarea {
    width: 100%;
    background: #2b3138;
    border: 1px solid #3f4752;
    border-radius: 6px;
    padding: 12px;
    color: #f8fafc;
    resize: vertical;
    min-height: 60px;
}

/* Botón volver */
.back-button {
    position: fixed;
    top: 80px;
    left: 20px;
    z-index: 100;
}

.btn-back {
    background: #1a1d23;
    border: 1px solid #2b3138;
    color: #f8fafc;
    padding: 10px 16px;
    border-radius: 25px;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
}

/* Modales */
.modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.8);
    z-index: 1000;
}

.modal-content {
    background: #1a1d23;
    border: 1px solid #2b3138;
    border-radius: 12px;
    padding: 20px;
    max-width: 400px;
    width: 90%;
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}

.modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 16px;
}

.modal-header h3 {
    margin: 0;
    color: #f8fafc;
}

.close {
    background: none;
    border: none;
    color: #94a3b8;
    font-size: 1.5rem;
    cursor: pointer;
}

.form-group {
    margin-bottom: 16px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    color: #cbd5e1;
}

.form-group textarea,
.form-group select {
    width: 100%;
    padding: 10px;
    background: #2b3138;
    border: 1px solid #3f4752;
    border-radius: 6px;
    color: #f8fafc;
}

.form-actions {
    display: flex;
    gap: 12px;
    justify-content: flex-end;
}

.btn-primary {
    background: #6366f1;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 6px;
    cursor: pointer;
}

.btn-secondary {
    background: rgba(255,255,255,0.1);
    color: #f8fafc;
    border: 1px solid #2b3138;
    padding: 10px 20px;
    border-radius: 6px;
    cursor: pointer;
}

.btn-danger {
    background: #ef4444;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 6px;
    cursor: pointer;
}

/* Responsive */
@media (max-width: 968px) {
    .photo-detail-layout {
        grid-template-columns: 1fr;
    }
    
    .comments-sidebar {
        width: 100%;
    }
}

@media (max-width: 640px) {
    .photo-detail-layout {
        padding: 16px;
    }
    
    .back-button {
        top: 70px;
        left: 16px;
    }
}
</style>
<style id="fix-comments-compact">
/* === Compact comments overrides (safe to stack) === */
.comments-sidebar { width: 320px; }
.comments-card { padding: 12px; }
.comments-header h3 { font-size: 0.95rem; margin-bottom: 12px; }

.comment-thread { padding: 10px 0; }
.comment-content { gap: 8px; }
.comment-avatar, .like-avatar { width: 24px; height: 24px; }

.comment-user { display: inline-flex; align-items: baseline; gap: 6px; }
.comment-user strong { font-size: 0.85rem; font-weight: 600; }
.comment-time { font-size: 0.7rem; opacity: 0.9; }

.comment-text { font-size: 0.82rem; line-height: 1.35; margin: 4px 0 6px; word-wrap: break-word; overflow-wrap: anywhere; }

.comment.reply { margin-left: 28px; }
.comment.reply .comment-avatar { width: 22px; height: 22px; }
.comment.reply .comment-user strong { font-size: 0.8rem; }
.comment.reply .comment-time { font-size: 0.68rem; }
.comment.reply .comment-text { font-size: 0.78rem; line-height: 1.32; }

.comment-actions { gap: 10px; }
.comment-actions button.btn-link { font-size: 0.72rem; padding: 2px 6px; }

/* Form */
.comment-form textarea { font-size: 0.85rem; line-height: 1.35; min-height: 68px; padding: 8px 10px; }
.comment-form .btn-submit { padding: 6px 10px; font-size: 0.8rem; }

/* Responsive */
@media (max-width: 1024px) {
  .photo-detail-layout { grid-template-columns: 1fr; }
  .comments-sidebar { width: 100%; }
}
@media (max-width: 640px) {
  .comment-avatar, .like-avatar { width: 22px; height: 22px; }
  .comment-user strong { font-size: 0.82rem; }
  .comment-text { font-size: 0.8rem; }
}
</style>
<style id="fix-scrollbar-pagination">
/* === Hide scrollbar but keep scroll === */
.comments-list {
  scrollbar-width: none;           /* Firefox */
  -ms-overflow-style: none;        /* IE/Edge legacy */
}
.comments-list::-webkit-scrollbar { /* Chrome/Safari/Edge (Blink/WebKit) */
  width: 0;
  height: 0;
}

/* Soft fade at top/bottom to hint scroll */
.comments-card { position: relative; }
.comments-card::before,
.comments-card::after {
  content: "";
  position: absolute;
  left: 12px;
  right: 12px;
  height: 16px;
  pointer-events: none;
  z-index: 3;
}
.comments-card::before {
  top: 48px; /* below header (h3 + margin) */
  background: linear-gradient(to bottom, rgba(15,23,42,1), rgba(15,23,42,0));
}
.comments-card::after {
  bottom: 16px;
  background: linear-gradient(to top, rgba(15,23,42,1), rgba(15,23,42,0));
}

/* Nicer pagination */
.comments-pagination {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 10px;
  margin-top: 12px;
  padding-top: 8px;
  border-top: 1px dashed #2f3540;
}

.pagination-info {
  font-size: 0.75rem;
  color: #94a3b8;
  padding: 4px 10px;
  border-radius: 9999px;
  background: rgba(148,163,184,0.08);
  backdrop-filter: blur(4px);
}

.pagination-btn {
  display: inline-flex;
  align-items: center;
  gap: 6px;
  font-size: 0.8rem;
  padding: 6px 10px;
  border-radius: 10px;
  text-decoration: none;
  border: 1px solid #374151;
  background: linear-gradient(180deg, rgba(31,41,55,0.8), rgba(17,24,39,0.8));
  box-shadow: 0 1px 0 rgba(255,255,255,0.05) inset;
  color: #e5e7eb;
  transition: transform .15s ease, border-color .15s ease, background .15s ease;
}

.pagination-btn:hover {
  transform: translateY(-1px);
  border-color: #4b5563;
  background: linear-gradient(180deg, rgba(55,65,81,0.9), rgba(31,41,55,0.9));
}

.pagination-btn.prev::before { content: "←"; opacity: .9; }
.pagination-btn.next::after  { content: "→"; opacity: .9; }

/* Tighten row spacing a hair so more fit without scrollbar */
.comment-thread { padding: 8px 0; }
.comment-actions button.btn-link { padding: 2px 6px; }
</style>
<style id="fix-compact-replies">
/* ===== Compact replies ===== */
.comment-replies { margin-left: 28px; border-left: 2px solid rgba(99,102,241,0.25); padding-left: 10px; }
.comment.reply { padding: 6px 0; }

/* Reduce size of reply controls */
.reply-count-badge { padding: 1px 6px; font-size: 0.68rem; border-radius: 9999px; }
.btn-toggle-replies, .btn-reply {
  padding: 3px 8px;
  font-size: 0.74rem;
  border-radius: 8px;
  background: rgba(99,102,241,0.12);
  border: 1px solid rgba(99,102,241,0.35);
}
.btn-toggle-replies:hover, .btn-reply:hover { background: rgba(99,102,241,0.18); }

/* Tighter reply body */
.comment.reply .comment-avatar { width: 22px; height: 22px; }
.comment.reply .user-link strong { font-size: 0.78rem; }
.comment.reply .comment-time { font-size: 0.68rem; }
.comment.reply .comment-text { font-size: 0.78rem; line-height: 1.32; margin: 2px 0 4px; }

/* Reply form compact */
.reply-form { margin: 6px 0 0 28px; padding: 6px; border-radius: 6px; background: rgba(43,49,56,0.25); }
.reply-form textarea { min-height: 44px; font-size: 0.78rem; padding: 8px 10px; }

/* Icons column spacing on replies */
.reply-actions { gap: 8px; }
</style>
<style id="fix-ultra-compact-replies">
/* ===== ULTRA COMPACT REPLIES ===== */

/* Contenedor de respuestas: menos sangría, línea muy fina y poco padding */
.comment-replies {
  margin-left: 18px;
  padding-left: 8px;
  border-left: 1px solid rgba(148,163,184,0.25);
}

/* Cada respuesta más apretada y sin fondo extra */
.comment.reply {
  padding: 4px 0;
  margin: 0;
  background: transparent !important;
  box-shadow: none !important;
}

/* Tipografías y alturas aún más pequeñas SOLO en respuestas */
.comment.reply .comment-avatar { width: 20px; height: 20px; }
.comment.reply .user-link strong { font-size: 0.76rem; }
.comment.reply .comment-time { font-size: 0.66rem; opacity: .9; }
.comment.reply .comment-text { font-size: 0.76rem; line-height: 1.28; margin: 2px 0 4px; }

/* Acciones súper finas en una sola línea */
.reply-actions { gap: 6px; }
.btn-reply, .btn-toggle-replies {
  padding: 2px 6px;
  font-size: 0.68rem;
  border-radius: 6px;
  background: rgba(99,102,241,0.10);
  border: 1px solid rgba(99,102,241,0.30);
}
.btn-reply:hover, .btn-toggle-replies:hover { background: rgba(99,102,241,0.16); }

/* Formulario de respuesta: sin bloque grande */
.reply-form { margin: 4px 0 0 18px; padding: 6px; background: rgba(43,49,56,0.18); border-radius: 6px; }
.reply-form textarea { min-height: 38px; font-size: 0.76rem; line-height: 1.28; padding: 6px 8px; }
.reply-form .btn-submit { padding: 4px 8px; font-size: 0.72rem; border-radius: 6px; }

/* Reduce altura visual de divisores entre hilos */
.comment-thread { padding: 6px 0; }
.comment-thread + .comment-thread { margin-top: 4px; }
</style>





<?php
function formatDate($date) {
    $datetime = new DateTime($date);
    $now = new DateTime();
    $diff = $now->diff($datetime);
    
    if ($diff->days == 0) return 'Hoy';
    if ($diff->days == 1) return 'Ayer';
    if ($diff->days < 7) return "Hace {$diff->days} días";
    if ($diff->days < 30) return "Hace " . floor($diff->days / 7) . " semanas";
    if ($diff->days < 365) return "Hace " . floor($diff->days / 30) . " meses";
    
    return "Hace " . floor($diff->days / 365) . " años";
}
?>