</main>
<footer class="footer">
  <div class="container">
    <div class="footer-content">
      <div class="footer-brand">
        <div class="brand">Nebusa</div>
        <p>Amigos de verdad, sin postureo.</p>
        <div class="footer-social">
          <span>📱</span>
          <span>📸</span>
          <span>👥</span>
        </div>
      </div>
      <div class="footer-links">
        <div class="footer-column">
          <h4>Navegación</h4>
          <a href="<?php echo htmlspecialchars(base_url('/')); ?>">Inicio</a>
          <a href="<?php echo htmlspecialchars(base_url('/feed')); ?>">Feed</a>
          <a href="<?php echo htmlspecialchars(base_url('/friends')); ?>">Amigos</a>
          <a href="<?php echo htmlspecialchars(base_url('/photos/upload')); ?>">Subir foto</a>
        </div>
        <div class="footer-column">
          <h4>Cuenta</h4>
          <a href="<?php echo htmlspecialchars(base_url('/login')); ?>">Entrar</a>
          <a href="<?php echo htmlspecialchars(base_url('/register')); ?>">Registrarse</a>
          <a href="<?php echo htmlspecialchars(base_url('/profile')); ?>">Perfil</a>
          <a href="<?php echo htmlspecialchars(base_url('/invites')); ?>">Invitaciones</a>
        </div>
        <div class="footer-column">
          <h4>Legal</h4>
          <a href="<?php echo htmlspecialchars(base_url('/privacy')); ?>">Privacidad</a>
          <a href="<?php echo htmlspecialchars(base_url('/terms')); ?>">Términos</a>
          <a href="<?php echo htmlspecialchars(base_url('/cookies')); ?>">Cookies</a>
          <a href="<?php echo htmlspecialchars(base_url('/help')); ?>">Ayuda</a>
        </div>
      </div>
    </div>
    <div class="footer-bottom">
      <small>© <?php echo date('Y'); ?> Nebusa — Amigos de verdad, sin postureo.</small>
      <div class="footer-locale">
        <span>🌐 Español</span>
      </div>
    </div>
  </div>
</footer>
<script src="<?php echo htmlspecialchars(asset_url('assets/js/app.js')); ?>"></script>
</body>
</html>

<style>
.footer {
  background: rgba(15, 23, 42, 0.95);
  border-top: 1px solid rgba(255, 255, 255, 0.1);
  padding: 3rem 0 1.5rem;
  margin-top: 4rem;
  backdrop-filter: blur(10px);
}

.footer-content {
  display: grid;
  grid-template-columns: 1fr 2fr;
  gap: 3rem;
  margin-bottom: 2rem;
}

.footer-brand .brand {
  font-size: 1.5rem;
  margin-bottom: 0.5rem;
  background: linear-gradient(135deg, #6366f1, #8b5cf6);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
}

.footer-brand p {
  color: #94a3b8;
  max-width: 300px;
  margin-bottom: 1rem;
}

.footer-social {
  display: flex;
  gap: 1rem;
}

.footer-social span {
  font-size: 1.2rem;
  opacity: 0.7;
  transition: opacity 0.2s ease;
}

.footer-social span:hover {
  opacity: 1;
}

.footer-links {
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  gap: 2rem;
}

.footer-column h4 {
  color: #f8fafc;
  margin-bottom: 1rem;
  font-size: 1rem;
  font-weight: 600;
}

.footer-column a {
  display: block;
  color: #94a3b8;
  text-decoration: none;
  margin-bottom: 0.5rem;
  transition: color 0.2s ease;
  font-size: 0.9rem;
}

.footer-column a:hover {
  color: #f8fafc;
}

.footer-bottom {
  border-top: 1px solid rgba(255, 255, 255, 0.1);
  padding-top: 1.5rem;
  display: flex;
  justify-content: space-between;
  align-items: center;
  color: #64748b;
  font-size: 0.9rem;
}

.footer-locale span {
  color: #94a3b8;
  font-size: 0.85rem;
}

@media (max-width: 968px) {
  .footer-content {
    grid-template-columns: 1fr;
    gap: 2rem;
  }
  
  .footer-links {
    grid-template-columns: repeat(2, 1fr);
  }
  
  .footer-bottom {
    flex-direction: column;
    gap: 1rem;
    text-align: center;
  }
}

@media (max-width: 640px) {
  .footer-links {
    grid-template-columns: 1fr;
  }
  
  .footer {
    padding: 2rem 0 1rem;
  }
}
</style>