<section class="hero">
  <div class="hero-content">
    <h1>Amigos de verdad, <span class="highlight">sin postureo</span>.</h1>
    <p>Comparte tus momentos especiales sólo con tus amigos aceptados. Una red social íntima y segura donde ser tú mismo.</p>
    <div class="hero-actions">
      <a class="btn btn-primary" href="<?php echo htmlspecialchars(base_url('/register')); ?>">
        <span>Crear cuenta</span>
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
      </a>
      <a class="btn btn-secondary" href="<?php echo htmlspecialchars(base_url('/login')); ?>">Entrar</a>
    </div>
    <div class="hero-features">
      <div class="feature">
        <div class="feature-icon">🔒</div>
        <span>Privacidad real</span>
      </div>
      <div class="feature">
        <div class="feature-icon">👥</div>
        <span>Sólo amigos</span>
      </div>
      <div class="feature">
        <div class="feature-icon">📸</div>
        <span>Fotos privadas</span>
      </div>
    </div>
  </div>
  <div class="hero-visual">
    <div class="mockup-card">
      <div class="mockup-header">
        <div class="mockup-dots">
          <span></span>
          <span></span>
          <span></span>
        </div>
      </div>
      <div class="mockup-content">
        <div class="mockup-post">
          <div class="mockup-avatar"></div>
          <div class="mockup-text">
            <div class="mockup-line short"></div>
            <div class="mockup-line medium"></div>
          </div>
        </div>
        <div class="mockup-image"></div>
        <div class="mockup-actions">
          <span>❤️</span>
          <span>💬</span>
          <span>↗️</span>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
.hero {
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 4rem;
  align-items: center;
  min-height: 80vh;
  padding: 4rem 0;
}

.hero-content h1 {
  font-size: 3.5rem;
  font-weight: 700;
  line-height: 1.1;
  margin-bottom: 1.5rem;
  background: linear-gradient(135deg, #f8fafc 0%, #cbd5e1 100%);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
}

.hero-content h1 .highlight {
  background: linear-gradient(135deg, #6366f1, #8b5cf6);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
}

.hero-content p {
  font-size: 1.25rem;
  color: #94a3b8;
  margin-bottom: 2.5rem;
  max-width: 500px;
}

.hero-actions {
  display: flex;
  gap: 1rem;
  margin-bottom: 3rem;
}

.btn {
  display: inline-flex;
  align-items: center;
  gap: 0.5rem;
  padding: 1rem 2rem;
  border-radius: var(--radius);
  font-weight: 600;
  text-decoration: none;
  transition: all 0.3s ease;
  border: none;
  cursor: pointer;
  font-size: 1rem;
}

.btn-primary {
  background: var(--primary);
  color: white;
  box-shadow: var(--shadow);
}

.btn-primary:hover {
  background: var(--primary-dark);
  transform: translateY(-2px);
  box-shadow: var(--shadow-lg);
}

.btn-secondary {
  background: rgba(255, 255, 255, 0.1);
  color: #f8fafc;
  border: 1px solid rgba(255, 255, 255, 0.2);
  backdrop-filter: blur(10px);
}

.btn-secondary:hover {
  background: rgba(255, 255, 255, 0.15);
  transform: translateY(-2px);
  box-shadow: var(--shadow);
}

.hero-features {
  display: flex;
  gap: 2rem;
}

.feature {
  display: flex;
  align-items: center;
  gap: 0.5rem;
  color: #94a3b8;
  font-weight: 500;
}

.feature-icon {
  font-size: 1.25rem;
}

.hero-visual {
  display: flex;
  justify-content: center;
  align-items: center;
}

.mockup-card {
  background: rgba(30, 41, 59, 0.6);
  border: 1px solid rgba(255, 255, 255, 0.1);
  border-radius: 16px;
  padding: 1.5rem;
  width: 320px;
  backdrop-filter: blur(10px);
  box-shadow: var(--shadow-lg);
  animation: float 6s ease-in-out infinite;
}

@keyframes float {
  0%, 100% { transform: translateY(0); }
  50% { transform: translateY(-10px); }
}

.mockup-header {
  display: flex;
  justify-content: center;
  margin-bottom: 1rem;
}

.mockup-dots {
  display: flex;
  gap: 0.5rem;
}

.mockup-dots span {
  width: 8px;
  height: 8px;
  border-radius: 50%;
  background: rgba(255, 255, 255, 0.3);
}

.mockup-post {
  display: flex;
  align-items: center;
  gap: 1rem;
  margin-bottom: 1rem;
}

.mockup-avatar {
  width: 40px;
  height: 40px;
  border-radius: 50%;
  background: linear-gradient(135deg, #6366f1, #8b5cf6);
}

.mockup-text {
  flex: 1;
  display: flex;
  flex-direction: column;
  gap: 0.5rem;
}

.mockup-line {
  height: 8px;
  border-radius: 4px;
  background: rgba(255, 255, 255, 0.1);
}

.mockup-line.short {
  width: 60%;
}

.mockup-line.medium {
  width: 80%;
}

.mockup-image {
  height: 200px;
  background: linear-gradient(135deg, #6366f1, #8b5cf6);
  border-radius: 12px;
  margin-bottom: 1rem;
  opacity: 0.8;
}

.mockup-actions {
  display: flex;
  gap: 1rem;
  padding: 0.5rem 0;
}

.footer {
  background: rgba(15, 23, 42, 0.9);
  border-top: 1px solid rgba(255, 255, 255, 0.1);
  padding: 3rem 0 1.5rem;
  margin-top: 4rem;
}

.footer-content {
  display: grid;
  grid-template-columns: 1fr 2fr;
  gap: 3rem;
  margin-bottom: 2rem;
}

.footer-brand .brand {
  font-size: 1.5rem;
  margin-bottom: 0.5rem;
}

.footer-brand p {
  color: #94a3b8;
  max-width: 300px;
}

.footer-links {
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  gap: 2rem;
}

.footer-column h4 {
  color: #f8fafc;
  margin-bottom: 1rem;
  font-size: 1rem;
  font-weight: 600;
}

.footer-column a {
  display: block;
  color: #94a3b8;
  text-decoration: none;
  margin-bottom: 0.5rem;
  transition: color 0.2s ease;
}

.footer-column a:hover {
  color: #f8fafc;
}

.footer-bottom {
  border-top: 1px solid rgba(255, 255, 255, 0.1);
  padding-top: 1.5rem;
  text-align: center;
  color: #64748b;
}

@media (max-width: 968px) {
  .hero {
    grid-template-columns: 1fr;
    gap: 3rem;
    text-align: center;
  }
  
  .hero-content h1 {
    font-size: 2.5rem;
  }
  
  .hero-actions {
    justify-content: center;
  }
  
  .hero-features {
    justify-content: center;
  }
  
  .footer-content {
    grid-template-columns: 1fr;
    gap: 2rem;
  }
  
  .footer-links {
    grid-template-columns: repeat(2, 1fr);
  }
}

@media (max-width: 640px) {
  .hero-actions {
    flex-direction: column;
    align-items: center;
  }
  
  .btn {
    width: 200px;
    justify-content: center;
  }
  
  .hero-features {
    flex-direction: column;
    gap: 1rem;
  }
  
  .footer-links {
    grid-template-columns: 1fr;
  }
}
</style>