<?php
// Función time_ago definida directamente en la vista
if (!function_exists('time_ago')) {
    function time_ago($datetime) {
        try {
            $now = new DateTime;
            $ago = new DateTime($datetime);
            $diff = $now->diff($ago);

            if ($diff->y > 0) {
                return $diff->y . ' año' . ($diff->y > 1 ? 's' : '');
            }

if (!function_exists('avatar_src')) {
    function avatar_src($v) {
        $v = (string)$v;
        $v = str_replace('\\', '/', $v);
        if (preg_match('~^https?://~i', $v)) return $v;
        // si viene con /public/uploads/avatars/... nos quedamos con el nombre
        $file = basename($v);
        if ($file === '' || $file === '.' || $file === '..') return asset_url('uploads/avatars/default.png');
        // sanitiza el nombre
        $file = preg_replace('~[^A-Za-z0-9._-]~', '', $file);
        return asset_url('uploads/avatars/'.$file);
    }
}
            if ($diff->m > 0) {
                return $diff->m . ' mes' . ($diff->m > 1 ? 'es' : '');
            }
            if ($diff->d > 0) {
                return $diff->d . ' día' . ($diff->d > 1 ? 's' : '');
            }
            if ($diff->h > 0) {
                return $diff->h . ' hora' . ($diff->h > 1 ? 's' : '');
            }
            if ($diff->i > 0) {
                return $diff->i . ' minuto' . ($diff->i > 1 ? 's' : '');
            }
            return 'unos segundos';
        } catch (Exception $e) {
            return 'recientemente';
        }
    }
}
?>

<h2>Amigos</h2>

<div class="friends-layout">
    <!-- Solicitudes Recibidas -->
    <section class="card card-small">
        <div class="card-header">
            <h3>Solicitudes recibidas</h3>
            <span class="badge badge-count"><?php echo count($incoming); ?></span>
        </div>
        <?php if(empty($incoming)): ?>
            <div class="empty-state">
                <div class="empty-icon">👋</div>
                <p>No tienes solicitudes nuevas</p>
            </div>
        <?php else: ?>
            <div class="requests-list">
                <?php foreach($incoming as $r): ?>
                <div class="user-item">
                    <div class="user-avatar">
                        <?php if(!empty($r['avatar'])): ?>
                            <img src="<?php echo htmlspecialchars('/public/uploads/avatars/'.rawurlencode(basename((string)$r['avatar']))); ?>" alt="<?php echo htmlspecialchars($r['first_name']); ?>">
                        <?php else: ?>
                            <div class="avatar-placeholder"><?php echo strtoupper(substr($r['first_name'], 0, 1) . substr($r['last_name'], 0, 1)); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="user-info">
                        <a href="<?php echo htmlspecialchars(base_url('/profile?nick='.$r['nick'])); ?>" class="user-link">
                            <h4 class="user-name"><?php echo htmlspecialchars($r['first_name'].' '.$r['last_name']); ?></h4>
                            <p class="user-nick">@<?php echo htmlspecialchars($r['nick']); ?></p>
                        </a>
                        <p class="request-date">Hace <?php echo time_ago($r['created_at']); ?></p>
                    </div>
                    <div class="user-actions">
                        <form method="post" action="<?php echo htmlspecialchars(base_url('/friends/accept')); ?>" class="inline-form">
                            <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
                            <input type="hidden" name="request_id" value="<?php echo (int)$r['id']; ?>">
                            <button type="submit" class="btn btn-success btn-sm">✓ Aceptar</button>
                        </form>
                        <form method="post" action="<?php echo htmlspecialchars(base_url('/friends/reject')); ?>" class="inline-form">
                            <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
                            <input type="hidden" name="request_id" value="<?php echo (int)$r['id']; ?>">
                            <button type="submit" class="btn btn-ghost btn-sm">✗ Rechazar</button>
                        </form>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </section>

    <!-- Solicitudes Enviadas -->
    <section class="card card-small">
        <div class="card-header">
            <h3>Solicitudes enviadas</h3>
            <span class="badge badge-count"><?php echo count($outgoing); ?></span>
        </div>
        <?php if(empty($outgoing)): ?>
            <div class="empty-state">
                <div class="empty-icon">📤</div>
                <p>No tienes solicitudes pendientes</p>
            </div>
        <?php else: ?>
            <div class="requests-list">
                <?php foreach($outgoing as $r): ?>
                <div class="user-item">
                    <div class="user-avatar">
                        <?php if(!empty($r['avatar'])): ?>
                            <img src="<?php echo htmlspecialchars('/public/uploads/avatars/'.rawurlencode(basename((string)$r['avatar']))); ?>" alt="<?php echo htmlspecialchars($r['first_name']); ?>">
                        <?php else: ?>
                            <div class="avatar-placeholder"><?php echo strtoupper(substr($r['first_name'], 0, 1) . substr($r['last_name'], 0, 1)); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="user-info">
                        <a href="<?php echo htmlspecialchars(base_url('/profile?nick='.$r['nick'])); ?>" class="user-link">
                            <h4 class="user-name"><?php echo htmlspecialchars($r['first_name'].' '.$r['last_name']); ?></h4>
                            <p class="user-nick">@<?php echo htmlspecialchars($r['nick']); ?></p>
                        </a>
                        <p class="request-date">Enviada hace <?php echo time_ago($r['created_at']); ?></p>
                    </div>
                    <div class="user-actions">
                        <form method="post" action="<?php echo htmlspecialchars(base_url('/friends/cancel')); ?>" class="inline-form">
                            <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
                            <input type="hidden" name="request_id" value="<?php echo (int)$r['id']; ?>">
                            <button type="submit" class="btn btn-warning btn-sm" onclick="return confirm('¿Cancelar esta solicitud?')">Cancelar</button>
                        </form>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </section>

    <!-- Lista de Amigos -->
    <section class="card card-large">
        <div class="card-header">
            <div class="card-title-section">
                <h3>Mis amigos</h3>
                <span class="friends-count"><?php echo count($friends); ?> amigo<?php echo count($friends) !== 1 ? 's' : ''; ?></span>
            </div>
            <a href="<?php echo htmlspecialchars(base_url('/friends/search')); ?>" class="btn btn-primary">Buscar amigos</a>
        </div>
        <?php if(empty($friends)): ?>
            <div class="empty-state">
                <div class="empty-icon">👥</div>
                <p>Todavía no tienes amigos añadidos</p>
                <p class="empty-subtitle">Encuentra amigos y comienza a conectarte</p>
                <a href="<?php echo htmlspecialchars(base_url('/friends/search')); ?>" class="btn btn-primary">Buscar amigos</a>
            </div>
        <?php else: ?>
            <div class="friends-grid">
                <?php foreach($friends as $f): ?>
                <div class="friend-card">
                    <div class="friend-avatar">
                        <a href="<?php echo htmlspecialchars(base_url('/profile?nick='.$f['nick'])); ?>">
                            <?php if(!empty($f['avatar'])): ?>
                                <img src="<?php echo htmlspecialchars('/public/uploads/avatars/'.rawurlencode(basename((string)$f['avatar']))); ?>" alt="<?php echo htmlspecialchars($f['first_name']); ?>">
                            <?php else: ?>
                                <div class="avatar-placeholder"><?php echo strtoupper(substr($f['first_name'], 0, 1) . substr($f['last_name'], 0, 1)); ?></div>
                            <?php endif; ?>
                        </a>
                    </div>
                    <div class="friend-info">
                        <a href="<?php echo htmlspecialchars(base_url('/profile?nick='.$f['nick'])); ?>" class="user-link">
                            <h4 class="user-name"><?php echo htmlspecialchars($f['first_name'].' '.$f['last_name']); ?></h4>
                            <p class="user-nick">@<?php echo htmlspecialchars($f['nick']); ?></p>
                        </a>
                    </div>
                    <div class="friend-actions">
                        <form method="post" action="<?php echo htmlspecialchars(base_url('/friends/unfriend')); ?>" class="inline-form">
                            <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
                            <input type="hidden" name="friend_id" value="<?php echo (int)$f['id']; ?>">
                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('¿Eliminar a <?php echo htmlspecialchars($f['first_name']); ?> de tus amigos?')">Eliminar</button>
                        </form>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </section>
</div>

<style>
.friends-layout {
    display: grid;
    grid-template-columns: 1fr 1fr;
    grid-template-rows: auto auto;
    gap: 1.5rem;
    max-width: 1200px;
    margin: 0 auto;
}

.card {
    background: #1a1d23;
    border: 1px solid #2b3138;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.card-small {
    grid-column: span 1;
}

.card-large {
    grid-column: 1 / -1;
}

.card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid #2b3138;
}

.card-title-section {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.card-header h3 {
    margin: 0;
    color: #f8fafc;
    font-size: 1.25rem;
    font-weight: 600;
}

.friends-count {
    background: #6366f1;
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 600;
}

.badge-count {
    background: #ef4444;
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 600;
}

.requests-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.user-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: #2b3138;
    border-radius: 8px;
    border: 1px solid #3f4752;
}

.friends-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 1rem;
}

.friend-card {
    background: #2b3138;
    border: 1px solid #3f4752;
    border-radius: 10px;
    padding: 1.25rem;
    transition: all 0.3s ease;
    text-align: center;
}

.friend-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px -8px rgba(0, 0, 0, 0.4);
    border-color: #6366f1;
}

.user-avatar, .friend-avatar {
    width: 96px;
    height: 96px;
    margin: 12px auto 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    overflow: hidden;
    flex-shrink: 0;
}

.user-avatar img, .friend-avatar img {
    display: block;
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 50%;
}

.friend-avatar img {
    display: block;
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 50%;
}

.avatar-placeholder {
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    border: 2px solid #3f4752;
    background: linear-gradient(135deg, #1f2937 0%, #374151 100%);
}

.user-avatar .avatar-placeholder {
    width: 50px;
    height: 50px;
    font-size: 1rem;
}

.friend-avatar .avatar-placeholder {
    width: 100%;
    height: 100%;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
}

.user-info {
    flex: 1;
    min-width: 0;
}

.friend-info {
    margin-top: 0.75rem;
}

.user-link {
    text-decoration: none;
    color: inherit;
    display: block;
}

.user-link:hover .user-name {
    color: #6366f1;
}

.user-name {
    margin: 0 0 0.25rem 0;
    font-size: 1rem;
    font-weight: 600;
    color: #f8fafc;
    transition: color 0.2s ease;
}

.friend-card .user-name {
    font-size: 1.1rem;
}

.user-nick {
    margin: 0 0 0.5rem 0;
    color: #94a3b8;
    font-size: 0.85rem;
}

.friend-card .user-nick {
    font-size: 0.9rem;
}

.request-date {
    margin: 0;
    color: #64748b;
    font-size: 0.75rem;
}

.user-actions, .friend-actions {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
    flex-shrink: 0;
}

.friend-actions {
    margin-top: 0.75rem;
}

.empty-state {
    text-align: center;
    padding: 2rem 1rem;
    color: #94a3b8;
}

.empty-icon {
    font-size: 3rem;
    margin-bottom: 1rem;
    opacity: 0.5;
}

.empty-state p {
    margin: 0 0 1rem 0;
    font-size: 1rem;
}

.empty-subtitle {
    font-size: 0.9rem !important;
    margin-bottom: 1.5rem !important;
}

/* BOTONES CONSISTENTES CON EL RESTO DE LA APLICACIÓN */
.btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border-radius: 8px;
    font-weight: 500;
    text-decoration: none;
    border: none;
    cursor: pointer;
    transition: all 0.2s ease;
    font-size: 0.9rem;
    min-width: 120px;
    justify-content: center;
}

.btn-primary {
    background: #6366f1;
    color: white;
}

.btn-primary:hover:not(:disabled) {
    background: #4f46e5;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

.btn-success {
    background: #10b981;
    color: white;
}

.btn-success:hover {
    background: #059669;
    transform: translateY(-1px);
}

.btn-warning {
    background: #f59e0b;
    color: white;
}

.btn-warning:hover {
    background: #d97706;
    transform: translateY(-1px);
}

.btn-danger {
    background: #ef4444;
    color: white;
}

.btn-danger:hover {
    background: #dc2626;
    transform: translateY(-1px);
}

.btn-ghost {
    background: transparent;
    color: #94a3b8;
    border: 1px solid #2b3138;
}

.btn-ghost:hover {
    background: rgba(255,255,255,0.05);
    color: #f8fafc;
    border-color: #3f4752;
}

.btn-sm {
    padding: 8px 16px;
    font-size: 0.8rem;
    min-width: auto;
}

.inline-form {
    display: inline;
    margin: 0;
}

@media (max-width: 768px) {
    .friends-layout {
        grid-template-columns: 1fr;
        grid-template-rows: auto;
        gap: 1rem;
    }
    
    .card-large {
        grid-column: 1;
    }
    
    .card {
        padding: 20px;
    }
    
    .card-header {
        flex-direction: column;
        gap: 0.75rem;
        align-items: flex-start;
    }
    
    .user-item {
        flex-direction: column;
        text-align: center;
        gap: 0.75rem;
    }
    
    .user-actions {
        flex-direction: row;
        justify-content: center;
    }
    
    .friends-grid {
        grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
        gap: 0.75rem;
    }
    
    .friend-card {
        padding: 1rem;
    }
    
    .friend-avatar img {
    display: block;
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 50%;
}
    
    .friend-avatar .avatar-placeholder {
    width: 100%;
    height: 100%;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
}
}
</style>