<h2>Bienvenido a Nebusa</h2>

<div class="auth-layout">
    <section class="card">
        <div class="card-header">
            <h3>Iniciar sesión</h3>
            <div class="logo">🌌</div>
        </div>

        <?php if (isset($error) && $error): ?>
            <div class="alert alert-error">
                <div class="alert-icon">⚠️</div>
                <div class="alert-content">
                    <strong>Credenciales incorrectas</strong>
                    <p>Verifica tu email y contraseña</p>
                </div>
            </div>
        <?php endif; ?>

        <?php if (isset($success) && $success): ?>
            <div class="alert alert-success">
                <div class="alert-icon">✅</div>
                <div class="alert-content">
                    <strong>¡Registro exitoso!</strong>
                    <p>Ya puedes iniciar sesión</p>
                </div>
            </div>
        <?php endif; ?>

        <form method="post" action="<?php echo htmlspecialchars(base_url('/login')); ?>" class="auth-form" id="loginForm">
            <input type="hidden" name="_csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
            
            <div class="form-group">
                <label for="email" class="form-label">Email</label>
                <input 
                    type="email" 
                    name="email" 
                    id="email"
                    required 
                    class="form-input"
                    placeholder="tu@email.com"
                    value="<?php echo isset($old_email) ? htmlspecialchars($old_email) : ''; ?>"
                    autocomplete="email"
                >
            </div>

            <div class="form-group">
                <label for="password" class="form-label">Contraseña</label>
                <div class="password-input-container">
                    <input 
                        type="password" 
                        name="password" 
                        id="password"
                        required 
                        class="form-input"
                        placeholder="••••••••"
                        autocomplete="current-password"
                        minlength="8"
                    >
                    <button type="button" class="password-toggle" id="passwordToggle">
                        👁️
                    </button>
                </div>
            </div>

            <div class="form-options">
                <label class="checkbox-label">
                    <input type="checkbox" name="remember" id="remember">
                    <span class="checkmark"></span>
                    Recordar sesión
                </label>
                <a href="<?php echo htmlspecialchars(base_url('/forgot-password')); ?>" class="text-link">
                    ¿Olvidaste tu contraseña?
                </a>
            </div>

            <button type="submit" class="btn btn-primary btn-full" id="submitBtn">
                <span class="btn-text">Iniciar sesión</span>
                <span class="btn-loading hidden">⏳ Conectando...</span>
            </button>
        </form>

        <div class="auth-footer">
            <p>¿Nuevo en Nebusa? 
                <a href="<?php echo htmlspecialchars(base_url('/register')); ?>" class="text-link">
                    Crear cuenta
                </a>
            </p>
        </div>
    </section>
</div>

<style>
.auth-layout {
    max-width: 400px;
    margin: 2rem auto;
    padding: 0 1rem;
}

.card {
    background: #1a1a1a;
    border-radius: 12px;
    padding: 2rem;
    border: 1px solid #333;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
}

.card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid #333;
}

.card-header h3 {
    margin: 0;
    color: #ffffff;
    font-size: 1.5rem;
    font-weight: 600;
}

.logo {
    font-size: 1.5rem;
}

.alert {
    display: flex;
    gap: 0.75rem;
    padding: 1rem;
    border-radius: 8px;
    margin-bottom: 1.5rem;
    align-items: flex-start;
}

.alert-error {
    background: rgba(239, 68, 68, 0.1);
    border: 1px solid rgba(239, 68, 68, 0.3);
    color: #ef4444;
}

.alert-success {
    background: rgba(16, 185, 129, 0.1);
    border: 1px solid rgba(16, 185, 129, 0.3);
    color: #10b981;
}

.alert-icon {
    font-size: 1.25rem;
    flex-shrink: 0;
}

.alert-content {
    flex: 1;
}

.alert-content strong {
    display: block;
    margin-bottom: 0.25rem;
}

.alert-content p {
    margin: 0;
    font-size: 0.875rem;
    opacity: 0.9;
}

.auth-form {
    display: flex;
    flex-direction: column;
    gap: 1.25rem;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.form-label {
    color: #ffffff;
    font-weight: 600;
    font-size: 0.9rem;
}

.form-input {
    background: #2d2d2d;
    border: 1px solid #404040;
    border-radius: 8px;
    padding: 0.75rem;
    color: #ffffff;
    font-size: 1rem;
    transition: all 0.2s ease;
    width: 100%;
    box-sizing: border-box;
}

.form-input:focus {
    outline: none;
    border-color: #6366f1;
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
}

.form-input:invalid:not(:focus):not(:placeholder-shown) {
    border-color: #ef4444;
}

.password-input-container {
    position: relative;
    display: flex;
    align-items: center;
}

.password-toggle {
    position: absolute;
    right: 0.75rem;
    background: none;
    border: none;
    color: #9ca3af;
    cursor: pointer;
    padding: 0.25rem;
    border-radius: 4px;
    transition: color 0.2s ease;
}

.password-toggle:hover {
    color: #ffffff;
    background: rgba(255, 255, 255, 0.1);
}

.form-options {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin: 0.5rem 0;
}

.checkbox-label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    cursor: pointer;
    color: #d1d5db;
    font-size: 0.875rem;
}

.checkbox-label input[type="checkbox"] {
    display: none;
}

.checkmark {
    width: 18px;
    height: 18px;
    border: 2px solid #4b5563;
    border-radius: 4px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.2s ease;
}

.checkbox-label input[type="checkbox"]:checked + .checkmark {
    background: #6366f1;
    border-color: #6366f1;
}

.checkbox-label input[type="checkbox"]:checked + .checkmark::after {
    content: "✓";
    color: white;
    font-size: 12px;
}

.text-link {
    color: #6366f1;
    text-decoration: none;
    font-size: 0.875rem;
    transition: color 0.2s ease;
}

.text-link:hover {
    color: #8b5cf6;
    text-decoration: underline;
}

.btn-full {
    width: 100%;
    margin-top: 0.5rem;
}

.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 0.75rem 1.5rem;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    text-decoration: none;
    cursor: pointer;
    transition: all 0.2s ease;
    font-size: 1rem;
    gap: 0.5rem;
}

.btn-primary {
    background: #6366f1;
    color: white;
}

.btn-primary:hover:not(:disabled) {
    background: #5b5cdc;
    transform: translateY(-1px);
}

.btn-primary:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.auth-footer {
    text-align: center;
    margin-top: 1.5rem;
    padding-top: 1.5rem;
    border-top: 1px solid #333;
    color: #9ca3af;
}

.auth-footer p {
    margin: 0;
}

.hidden {
    display: none;
}

/* Responsive */
@media (max-width: 480px) {
    .auth-layout {
        margin: 1rem auto;
    }
    
    .card {
        padding: 1.5rem;
    }
    
    .form-options {
        flex-direction: column;
        gap: 0.75rem;
        align-items: flex-start;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const loginForm = document.getElementById('loginForm');
    const passwordToggle = document.getElementById('passwordToggle');
    const passwordInput = document.getElementById('password');
    const submitBtn = document.getElementById('submitBtn');
    const btnText = submitBtn.querySelector('.btn-text');
    const btnLoading = submitBtn.querySelector('.btn-loading');

    // Toggle password visibility
    passwordToggle.addEventListener('click', function() {
        const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordInput.setAttribute('type', type);
        passwordToggle.textContent = type === 'password' ? '👁️' : '🔒';
    });

    // Form submission
    loginForm.addEventListener('submit', function(e) {
        const email = document.getElementById('email').value;
        const password = document.getElementById('password').value;

        // Validación básica del cliente
        if (!email || !password) {
            e.preventDefault();
            return;
        }

        // Mostrar estado de carga
        submitBtn.disabled = true;
        btnText.classList.add('hidden');
        btnLoading.classList.remove('hidden');
    });

    // Validación en tiempo real
    const inputs = loginForm.querySelectorAll('input[required]');
    inputs.forEach(input => {
        input.addEventListener('blur', function() {
            if (!this.value) {
                this.style.borderColor = '#ef4444';
            } else {
                this.style.borderColor = '#404040';
            }
        });
    });

    // Prevenir envío múltiple
    let formSubmitted = false;
    loginForm.addEventListener('submit', function(e) {
        if (formSubmitted) {
            e.preventDefault();
            return;
        }
        formSubmitted = true;
    });
});
</script>