<?php
date_default_timezone_set('UTC');
if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>
<?php
// src/views/reports/index.php
?>
<div class="grid" style="margin-top:40px">
    <div class="card">
        <h2 style="margin:0 0 20px 0;display:flex;align-items:center;gap:12px">
            <i class="fas fa-flag"></i> Sistema de Reportes
            <?php if ($is_moderator): ?>
            <span class="muted" style="font-size:1rem">(Moderador)</span>
            <?php endif; ?>
        </h2>
        
        <?php if (empty($reports)): ?>
        <div style="text-align:center;padding:40px 20px">
            <div style="font-size:3rem;color:var(--muted);margin-bottom:15px">
                <i class="fas fa-check-circle"></i>
            </div>
            <h3 style="margin-bottom:10px">No hay reportes</h3>
            <p class="muted">No hay reportes pendientes de revisión.</p>
        </div>
        <?php else: ?>
        <div class="reports-list">
            <?php foreach ($reports as $report): ?>
            <div class="report-card" style="background:var(--card-hover);border-radius:12px;padding:20px;margin-bottom:20px;border-left:4px solid var(--<?php echo $report['status'] === 'pending' ? 'warning' : ($report['status'] === 'resolved' ? 'success' : 'info'); ?>)">
                <div style="display:flex;justify-content:space-between;align-items:flex-start;margin-bottom:15px">
                    <div>
                        <h4 style="margin:0 0 8px 0">
                            Reporte de <?php echo h(ucfirst($report['target_type'])); ?>
                            <span class="status-badge" style="background:var(--<?php echo $report['status'] === 'pending' ? 'warning' : ($report['status'] === 'resolved' ? 'success' : 'info'); ?>);color:white;padding:4px 8px;border-radius:4px;font-size:0.8rem;margin-left:8px">
                                <?php echo h(ucfirst($report['status'])); ?>
                            </span>
                        </h4>
                        <div class="muted" style="font-size:0.9rem">
                            <i class="far fa-clock"></i> <?php echo h(fdt($report['created_at'])); ?>
                            por @<?php echo h($report['reporter_username'] ?? 'unknown'); ?>
                        </div>
                    </div>
                    
                    <?php if ($is_moderator && $report['status'] === 'pending'): ?>
                    <div style="display:flex;gap:8px">
                        <form method="post" action="./?r=reports/update">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="report_id" value="<?php echo h($report['id']); ?>">
                            <input type="hidden" name="action" value="reviewed">
                            <button type="submit" class="btn sm" style="background:var(--info)">
                                <i class="fas fa-eye"></i> Revisado
                            </button>
                        </form>
                        <form method="post" action="./?r=reports/update">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="report_id" value="<?php echo h($report['id']); ?>">
                            <input type="hidden" name="action" value="resolved">
                            <button type="submit" class="btn sm" style="background:var(--success)">
                                <i class="fas fa-check"></i> Resuelto
                            </button>
                        </form>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div style="margin-bottom:15px">
                    <div style="display:flex;gap:20px;margin-bottom:10px">
                        <div>
                            <strong>Motivo:</strong>
                            <span style="background:var(--accent-light);padding:4px 8px;border-radius:4px">
                                <?php echo h(ucfirst($report['reason'])); ?>
                            </span>
                        </div>
                        <div>
                            <strong>Objetivo:</strong>
                            <?php if ($report['target_type'] === 'user'): ?>
                            Usuario: @<?php echo h($report['target_username']); ?>
                            <?php else: ?>
                            <?php echo h(ucfirst($report['target_type'])); ?> #<?php echo h($report['target_id']); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <?php if (!empty($report['description'])): ?>
                    <div style="background:var(--card);padding:12px;border-radius:8px;margin-bottom:10px">
                        <strong>Descripción:</strong>
                        <p style="margin:8px 0 0 0"><?php echo h($report['description']); ?></p>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($report['content_preview'])): ?>
                    <div style="background:var(--card);padding:12px;border-radius:8px;margin-bottom:10px">
                        <strong>Contenido:</strong>
                        <p style="margin:8px 0 0 0"><?php echo h($report['content_preview']); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
                
                <?php if ($is_moderator && $report['status'] !== 'pending'): ?>
                <div style="background:var(--card);padding:12px;border-radius:8px;font-size:0.9rem">
                    <strong>Resolución:</strong>
                    <div style="display:flex;justify-content:space-between;margin-top:5px">
                        <span>
                            Por: @<?php echo h($report['reviewed_by'] ?? 'admin'); ?>
                            el <?php echo h(fdt($report['reviewed_at'])); ?>
                        </span>
                        <span class="muted">
                            Estado: <?php echo h(ucfirst($report['status'])); ?>
                        </span>
                    </div>
                    <?php if (!empty($report['notes'])): ?>
                    <div style="margin-top:8px">
                        <strong>Notas:</strong>
                        <p style="margin:5px 0 0 0"><?php echo h($report['notes']); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <?php if ($is_moderator && $report['status'] === 'pending'): ?>
                <form method="post" action="./?r=reports/update" style="margin-top:15px">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="report_id" value="<?php echo h($report['id']); ?>">
                    <input type="hidden" name="action" value="resolved">
                    
                    <div class="form-group">
                        <label for="notes-<?php echo h($report['id']); ?>">Notas de resolución:</label>
                        <textarea name="notes" id="notes-<?php echo h($report['id']); ?>" rows="3" placeholder="Añade notas sobre la resolución de este reporte..." style="width:100%"></textarea>
                    </div>
                    
                    <div style="display:flex;gap:8px;justify-content:flex-end">
                        <button type="submit" name="action_type" value="warn" class="btn" style="background:var(--warning)">
                            <i class="fas fa-exclamation-triangle"></i> Advertir usuario
                        </button>
                        <button type="submit" name="action_type" value="delete" class="btn" style="background:var(--error)">
                            <i class="fas fa-trash"></i> Eliminar contenido
                        </button>
                        <button type="submit" name="action_type" value="ban" class="btn" style="background:var(--error-dark)">
                            <i class="fas fa-ban"></i> Banear usuario
                        </button>
                    </div>
                </form>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</div>