<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>
<?php
// src/views/reports/create.php
?>
<div class="grid" style="margin-top:40px;max-width:600px;margin-left:auto;margin-right:auto">
    <div class="card">
        <h2 style="margin:0 0 20px 0"><i class="fas fa-flag"></i> Reportar <?php echo h(ucfirst($target_type)); ?></h2>
        
        <?php if ($target_type === 'post'): ?>
            <div style="background:var(--bg-secondary);padding:15px;border-radius:var(--radius-sm);margin-bottom:20px;">
                <strong>Publicación de:</strong> @<?php echo h($target_info['username']); ?><br>
                <strong>Contenido:</strong> <?php echo !empty($target_info['caption']) ? h($target_info['caption']) : 'Sin descripción'; ?>
            </div>
        <?php elseif ($target_type === 'comment'): ?>
            <div style="background:var(--bg-secondary);padding:15px;border-radius:var(--radius-sm);margin-bottom:20px;">
                <strong>Comentario de:</strong> @<?php echo h($target_info['username']); ?><br>
                <strong>Contenido:</strong> <?php echo h($target_info['comment']); ?>
            </div>
        <?php elseif ($target_type === 'user'): ?>
            <div style="background:var(--bg-secondary);padding:15px;border-radius:var(--radius-sm);margin-bottom:20px;">
                <strong>Usuario:</strong> @<?php echo h($target_info['username']); ?>
            </div>
        <?php endif; ?>
        
        <form method="post" action="./?r=reports/create">
<?= csrf_field() ?>
            <input type="hidden" name="target_type" value="<?php echo h($target_type); ?>">
            <input type="hidden" name="target_id" value="<?php echo h($target_id); ?>">
            
            <div class="form-group">
                <label for="reason"><i class="fas fa-exclamation-circle"></i> Motivo del reporte</label>
                <select name="reason" id="reason" required>
                    <option value="">Seleccionar motivo...</option>
                    <option value="spam">Spam o publicidad no deseada</option>
                    <option value="harassment">Acoso o bullying</option>
                    <option value="inappropriate">Contenido inapropiado</option>
                    <option value="other">Otro motivo</option>
                </select>
            </div>
            
            <div class="form-group">
                <label for="description"><i class="fas fa-align-left"></i> Descripción (opcional)</label>
                <textarea name="description" id="description" rows="4" 
                          placeholder="Proporciona más detalles sobre el problema..." 
                          maxlength="500"></textarea>
                <div class="muted" style="text-align:right;font-size:0.8rem">
                    <span id="charCount">0</span>/500 caracteres
                </div>
            </div>
            
            <?php echo csrf_field(); ?>
            
            <button type="submit" class="btn primary" style="width:100%">
                <i class="fas fa-paper-plane"></i> Enviar Reporte
            </button>
        </form>
    </div>
</div>

<script>
document.getElementById('description').addEventListener('input', function() {
    document.getElementById('charCount').textContent = this.value.length;
});
</script>