<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>
<?php
// src/views/profile/friend.php
?>
<div class="grid" style="margin-top:40px">
    <div class="card">
        <!-- Header con botón de volver -->
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px">
            <a href="./?r=friends" class="btn">
                <i class="fas fa-arrow-left"></i> Volver a amigos
            </a>
            
            <!-- Botón de reportar usuario -->
            <?php if ($friend['id'] != $_SESSION['user']['id']): ?>
            <a href="./?r=reports/form&type=user&id=<?php echo h($friend['id']); ?>" class="btn" style="background:var(--error);color:white">
                <i class="fas fa-flag"></i> Reportar usuario
            </a>
            <?php endif; ?>
        </div>

        <!-- Información del perfil -->
        <div class="profile-header" style="text-align:center;margin-bottom:30px">
            <div class="user-badge" style="width:80px;height:80px;margin:0 auto 15px;font-size:2rem" style="overflow:hidden;border-radius:50%;padding:0;background:none;"><?php echo avatar_img(isset($friend['author_avatar_url'])?$friend['author_avatar_url']:(isset($friend['avatar_url'])?$friend['avatar_url']:''), isset($friend['username'])?$friend['username']:'U', 36); ?></div>
            <h1 style="margin:0 0 8px 0">@<?php echo h($friend['username']); ?></h1>
            <div class="muted">Miembro desde <?php echo h(fdt($friend['created_at'])); ?></div>
        </div>

        <!-- Bio del usuario -->
        <?php if (!empty($friend['bio'])): ?>
        <div class="card" style="margin-bottom:20px;background:linear-gradient(135deg, rgba(124,209,255,0.1), rgba(185,156,255,0.1))">
            <h3 style="margin:0 0 12px 0"><i class="fas fa-quote-left"></i> Bio</h3>
            <p style="margin:0;line-height:1.6"><?php echo h($friend['bio']); ?></p>
        </div>
        <?php endif; ?>

        <!-- Estadísticas -->
        <div class="grid grid-3" style="margin-bottom:30px">
            <div class="card" style="text-align:center">
                <div style="font-size:2rem;color:var(--accent);font-weight:700"><?php echo h($stats['post_count']); ?></div>
                <div class="muted">Publicaciones</div>
            </div>
            <div class="card" style="text-align:center">
                <div style="font-size:2rem;color:var(--accent2);font-weight:700"><?php echo h($stats['friend_count']); ?></div>
                <div class="muted">Amigos</div>
            </div>
            <div class="card" style="text-align:center">
                <div style="font-size:2rem;color:var(--accent3);font-weight:700"><?php echo h($stats['like_count'] + $stats['comment_count']); ?></div>
                <div class="muted">Interacciones</div>
            </div>
        </div>

        <!-- Publicaciones recientes -->
        <div class="card">
            <h3 style="margin:0 0 20px 0"><i class="fas fa-images"></i> Publicaciones recientes</h3>
            
            <?php if (empty($posts)): ?>
            <div style="text-align:center;padding:30px;color:var(--muted)">
                <i class="fas fa-camera" style="font-size:2.5rem;margin-bottom:15px"></i>
                <p>@<?php echo h($friend['username']); ?> no tiene publicaciones aún</p>
            </div>
            <?php else: ?>
            <div class="posts-grid" style="display:grid;grid-template-columns:repeat(auto-fill, minmax(250px, 1fr));gap:16px">
                <?php foreach ($posts as $post): ?>
                <a href="./?r=posts/view&id=<?php echo h($post['id']); ?>" class="post-thumbnail" style="display:block;border-radius:12px;overflow:hidden;border:1px solid var(--border);transition:var(--transition)">
                    <?php if (!empty($post['url'])): ?>
                    <img src="<?php echo h($post['url']); ?>" alt="Publicación" style="width:100%;height:200px;object-fit:cover">
                    <?php else: ?>
                    <div style="width:100%;height:200px;background:var(--card-hover);display:flex;align-items:center;justify-content:center;color:var(--muted)">
                        <i class="fas fa-image" style="font-size:2rem"></i>
                    </div>
                    <?php endif; ?>
                    <div style="padding:12px">
                        <div style="font-size:0.9rem;margin-bottom:8px;display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden">
                            <?php echo !empty($post['caption']) ? h($post['caption']) : 'Sin descripción'; ?>
                        </div>
                        <div style="display:flex;justify-content:space-between;align-items:center">
                            <div style="display:flex;align-items:center;gap:8px">
                                <i class="fas fa-heart" style="color:var(--accent3)"></i>
                                <span style="font-size:0.85rem"><?php echo h($post['likes']); ?></span>
                            </div>
                            <div style="display:flex;align-items:center;gap:8px">
                                <i class="fas fa-comment" style="color:var(--accent)"></i>
                                <span style="font-size:0.85rem"><?php echo h($post['comments']); ?></span>
                            </div>
                        </div>
                    </div>
                </a>
                <?php endforeach; ?>
            </div>
            
            <?php if (count($posts) >= 6): ?>
            <div style="text-align:center;margin-top:20px">
                <a href="./?r=posts/user&id=<?php echo h($friend['id']); ?>" class="btn">
                    <i class="fas fa-list"></i> Ver todas las publicaciones
                </a>
            </div>
            <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.post-thumbnail:hover {
    transform: translateY(-5px);
    box-shadow: var(--shadow);
    border-color: var(--border-light);
}
</style>