<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>
<div class="grid" style="margin-top:40px">
  <div class="card" style="display:flex;justify-content:space-between;align-items:center">
    <h2 style="margin:0"><i class="fas fa-images"></i> Mis publicaciones</h2>
    <a class="btn primary" href="./?r=posts/create">
      <i class="fas fa-plus"></i> Nueva publicación
    </a>
  </div>
  
  <?php if (!empty($posts)): ?>
    <div class="grid">
      <?php foreach($posts as $p): ?>
        <div class="card" style="display:grid;grid-template-columns:120px 1fr auto;gap:16px;align-items:center;transition:var(--transition)">
          <div class="thumb" style="height:100px;">
            <?php if (!empty($p['url'])): ?>
              <img src="<?php echo h($p['url']); ?>" alt="thumb" style="width:100%;height:100%;object-fit:cover" onerror="this.style.display='none';">
            <?php else: ?>
              <div class="muted" style="display:flex;align-items:center;justify-content:center;height:100%;background:rgba(15,18,24,0.5);border-radius:var(--radius-sm)">
                <i class="fas fa-image" style="font-size:1.5rem;opacity:0.5"></i>
              </div>
            <?php endif; ?>
          </div>
          
          <div>
            <div class="muted" style="font-size:0.85rem">
              <i class="fas fa-calendar"></i> <?php echo h(fdt_madrid($p['created_at'])); ?>
            </div>
            <div style="margin:8px 0;word-break:break-word">
              <?php echo !empty($p['caption']) ? h($p['caption']) : '<span class="muted">Sin descripción</span>'; ?>
            </div>
            <div style="display:flex;gap:8px">
              <a class="btn" href="./?r=posts/view&id=<?php echo h($p['id']); ?>" style="font-size:0.9rem">
                <i class="fas fa-eye"></i> Ver
              </a>
              <form method="post" action="./?r=posts/delete&id=<?php echo h($p['id']); ?>" 
                    onsubmit="return confirm('¿Estás seguro de que quieres borrar esta publicación? Esta acción no se puede deshacer.');">
<?= csrf_field() ?>
                <button class="btn" type="submit" style="font-size:0.9rem">
                  <i class="fas fa-trash"></i> Borrar
                </button>
              </form>
            </div>
          </div>
          
          <div style="text-align:center">
            <div class="muted" style="font-size:0.8rem">Interacciones</div>
            <div style="font-size:1.2rem;font-weight:bold;color:var(--accent)">
              <?php echo h($p['likes'] ?? 0); ?>
            </div>
            <div class="muted" style="font-size:0.8rem">Likes</div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php else: ?>
    <div class="card" style="text-align:center;padding:60px 20px">
      <i class="fas fa-image" style="font-size:3rem;margin-bottom:16px;opacity:0.5"></i>
      <h3 style="margin:0 0 12px 0">Todavía no has publicado nada</h3>
      <p class="muted">Comparte tus momentos con tus amigos.</p>
      <a href="./?r=posts/create" class="btn primary" style="margin-top:16px">
        <i class="fas fa-plus"></i> Crear primera publicación
      </a>
    </div>
  <?php endif; ?>
</div>