<?php if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>
<div class="grid" style="margin-top:40px;max-width:600px;margin-left:auto;margin-right:auto">
  <?php if(!empty($error)): ?>
    <div class="alert alert-error">
      <i class="fas fa-exclamation-circle"></i>
      <div><?php echo h($error); ?></div>
    </div>
  <?php endif; ?>
  
  <?php if(!empty($ok)): ?>
    <div class="alert alert-success">
      <i class="fas fa-check-circle"></i>
      <div><?php echo h($ok); ?></div>
    </div>
  <?php endif; ?>
  
  <form class="card" method="post" enctype="multipart/form-data">
<?= csrf_field() ?>

    <h2 style="margin:0 0 16px 0"><i class="fas fa-plus-circle"></i> Nueva publicación</h2>
    
    <div class="form-group">
      <label for="photo" class="btn" style="display:block;text-align:center;cursor:pointer;border:2px dashed var(--border);padding:40px 20px;border-radius:var(--radius);transition:var(--transition)" 
            onmouseover="this.style.borderColor='var(--accent)'" onmouseout="this.style.borderColor='var(--border)'">
        <i class="fas fa-cloud-upload-alt" style="font-size:2rem;margin-bottom:12px;color:var(--muted)"></i>
        <div>Haz clic o arrastra una imagen aquí</div>
        <div class="muted" style="margin-top:8px">Formatos: JPG, PNG, WEBP</div>
      </label>
      <input type="file" name="photo" id="photo" accept="image/jpeg,image/png,image/webp" required style="display:none" onchange="previewImage(this)">
    </div>
    
    <div id="imagePreview" style="display:none;margin-bottom:20px;text-align:center">
      <img id="preview" src="#" alt="Vista previa" style="max-width:100%;max-height:300px;border-radius:var(--radius);border:1px solid var(--border)">
      <button type="button" class="btn" onclick="removeImage()" style="margin-top:12px">
        <i class="fas fa-times"></i> Eliminar imagen
      </button>
    </div>
    
    <div class="form-group">
      <label for="caption"><i class="fas fa-pencil-alt"></i> Pie de foto</label>
      <textarea name="caption" placeholder="¿Qué estás pensando?" rows="3"></textarea>
    </div>
    
    <button class="btn primary" type="submit" style="width:100%">
      <i class="fas fa-paper-plane"></i> Publicar
    </button>
  </form>
</div>

<script>
function previewImage(input) {
  const preview = document.getElementById('preview');
  const imagePreview = document.getElementById('imagePreview');
  
  if (input.files && input.files[0]) {
    const reader = new FileReader();
    
    reader.onload = function(e) {
      preview.src = e.target.result;
      imagePreview.style.display = 'block';
    }
    
    reader.readAsDataURL(input.files[0]);
  }
}

function removeImage() {
  const input = document.getElementById('photo');
  const imagePreview = document.getElementById('imagePreview');
  
  input.value = '';
  imagePreview.style.display = 'none';
}

// Drag and drop functionality
const dropArea = document.querySelector('.form-group');
['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
  dropArea.addEventListener(eventName, preventDefaults, false);
});

function preventDefaults(e) {
  e.preventDefault();
  e.stopPropagation();
}

['dragenter', 'dragover'].forEach(eventName => {
  dropArea.addEventListener(eventName, highlight, false);
});

['dragleave', 'drop'].forEach(eventName => {
  dropArea.addEventListener(eventName, unhighlight, false);
});

function highlight(e) {
  dropArea.style.borderColor = 'var(--accent)';
  dropArea.style.backgroundColor = 'rgba(124, 209, 255, 0.1)';
}

function unhighlight(e) {
  dropArea.style.borderColor = 'var(--border)';
  dropArea.style.backgroundColor = 'transparent';
}

dropArea.addEventListener('drop', handleDrop, false);

function handleDrop(e) {
  const dt = e.dataTransfer;
  const files = dt.files;
  const input = document.getElementById('photo');
  
  if (files.length) {
    input.files = files;
    previewImage(input);
  }
}
</script>