<?php
date_default_timezone_set('UTC');
if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>
<?php if($m = flash('success')): ?>
  <div class="alert alert-success">
    <i class="fas fa-check-circle"></i>
    <div><?php echo h($m); ?></div>
  </div>
<?php endif; ?>

<?php if($m = flash('error')): ?>
  <div class="alert alert-error">
    <i class="fas fa-exclamation-circle"></i>
    <div><?php echo h($m); ?></div>
  </div>
<?php endif; ?>

<div class="grid grid-2" style="margin-top:40px">
  <div class="card">
    <h2 style="margin:0 0 16px 0"><i class="fas fa-ticket-alt"></i> Invitaciones</h2>
    <div class="muted" style="margin-bottom:16px">Te quedan <b style="color:var(--accent);font-size:1.2rem"><?php echo (int)$left; ?></b> invitaciones.</div>
    
    <form method="post" style="margin-top:20px">
<?= csrf_field() ?>

      <button class="btn primary" name="generate" value="1" <?php echo $left<=0?'disabled':''; ?> style="width:100%">
        <i class="fas fa-plus"></i> Generar código de invitación
      </button>
    </form>
    
    <div class="muted" style="margin-top:16px">
      <p><i class="fas fa-info-circle"></i> Comparte el código con tus amigos para que se registren en Thirty.</p>
    </div>
  </div>

  <div class="card">
    <h3 style="margin:0 0 16px 0"><i class="fas fa-list"></i> Tus códigos</h3>
    <?php if (!empty($invites)): ?>
      <div style="overflow-x:auto;">
        <table style="width:100%;border-collapse:collapse;border:1px solid var(--border);border-radius:var(--radius-sm);overflow:hidden">
          <thead>
            <tr style="background:rgba(15,18,24,0.5)">
              <th style="text-align:left;padding:12px;border-bottom:1px solid var(--border)">Código</th>
              <th style="text-align:left;padding:12px;border-bottom:1px solid var(--border)">Estado</th>
              <th style="text-align:left;padding:12px;border-bottom:1px solid var(--border)">Creado</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($invites as $i): ?>
              <tr style="border-bottom:1px solid var(--border)">
                <td style="padding:12px;border-bottom:1px solid var(--border)">
                  <code style="background:rgba(124,209,255,0.1);padding:6px 10px;border-radius:6px;color:var(--accent);font-weight:500">
                    <?php echo h($i['code']); ?>
                  </code>
                </td>
                <td style="padding:12px;border-bottom:1px solid var(--border)">
                  <?php if ($i['used_by']): ?>
                    <span style="display:inline-flex;align-items:center;gap:4px;padding:4px 8px;border-radius:20px;background:rgba(255,77,77,0.1);color:var(--error);font-size:0.85rem">
                      <i class="fas fa-times-circle"></i> Usado
                    </span>
                  <?php else: ?>
                    <span style="display:inline-flex;align-items:center;gap:4px;padding:4px 8px;border-radius:20px;background:rgba(77,255,136,0.1);color:var(--success);font-size:0.85rem">
                      <i class="fas fa-check-circle"></i> Libre
                    </span>
                  <?php endif; ?>
                </td>
                <td style="padding:12px;border-bottom:1px solid var(--border);color:var(--muted);font-size:0.9rem">
                  <?php echo h(date('d/m/Y', strtotime($i['created_at']))); ?>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php else: ?>
      <div class="muted" style="text-align:center;padding:40px 20px">
        <i class="fas fa-ticket-alt" style="font-size:3rem;margin-bottom:16px;opacity:0.5"></i>
        <p>Aún no generaste invitaciones.</p>
        <p style="margin-top:8px">Genera tu primer código para invitar amigos.</p>
      </div>
    <?php endif; ?>
  </div>
</div>