<?php
date_default_timezone_set('UTC');
if (!function_exists('avatar_img')) { @include_once '../../helpers.php'; } ?>
<?php
// src/views/friends/index.php
?>
<div class="grid" style="margin-top:40px">
    <div class="card">
        <h2 style="margin:0 0 20px 0;display:flex;align-items:center;gap:12px">
            <i class="fas fa-users"></i> Mis Amigos
        </h2>

        <!-- Búsqueda de nuevos amigos -->
        <div class="card" style="background:linear-gradient(135deg, rgba(124,209,255,0.1), rgba(185,156,255,0.1));margin-bottom:20px">
            <h3 style="margin:0 0 15px 0"><i class="fas fa-user-plus"></i> Agregar nuevos amigos</h3>
            <form method="get" action="./" style="display:flex;gap:10px">
                <input type="hidden" name="r" value="friends">
                <input type="text" name="search" placeholder="Buscar por nombre de usuario..." 
                       value="<?php echo h($search ?? ''); ?>" style="flex:1">
                <button type="submit" class="btn primary">
                    <i class="fas fa-search"></i> Buscar
                </button>
                <?php if (!empty($search)): ?>
                    <a href="./?r=friends" class="btn error">
                        <i class="fas fa-times"></i> Limpiar
                    </a>
                <?php endif; ?>
            </form>

            <?php if (!empty($search_results)): ?>
            <div style="margin-top:15px">
                <h4 style="margin:0 0 10px 0">Resultados de búsqueda:</h4>
                <div class="search-results" style="display:flex;flex-direction:column;gap:10px">
                    <?php foreach ($search_results as $user): ?>
                    <div style="display:flex;justify-content:space-between;align-items:center;padding:12px;background:var(--card);border-radius:8px">
                        <div style="display:flex;align-items:center;gap:10px">
                            <div class="user-badge" style="width:36px;height:36px" style="overflow:hidden;border-radius:50%;padding:0;background:none;"><?php echo avatar_img(isset($user['author_avatar_url'])?$user['author_avatar_url']:(isset($user['avatar_url'])?$user['avatar_url']:''), isset($user['username'])?$user['username']:'U', 36); ?></div>
                            <span>@<?php echo h($user['username']); ?></span>
                        </div>
                        <form method="post" action="./?r=friends/add">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="friend_id" value="<?php echo h($user['id']); ?>">
                            <button type="submit" class="btn primary sm">
                                <i class="fas fa-user-plus"></i> Agregar
                            </button>
                        </form>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php elseif (!empty($search)): ?>
            <div style="text-align:center;padding:20px;color:var(--muted)">
                <i class="fas fa-search" style="font-size:2rem;margin-bottom:10px"></i>
                <p>No se encontraron usuarios con ese nombre</p>
            </div>
            <?php endif; ?>
        </div>

        <!-- Búsqueda entre amigos existentes -->
        <div class="card" style="margin-bottom:20px">
            <h3 style="margin:0 0 15px 0"><i class="fas fa-search"></i> Buscar entre mis amigos</h3>
            <form method="get" action="./" style="display:flex;gap:10px">
                <input type="hidden" name="r" value="friends">
                <input type="text" name="search_friends" placeholder="Buscar entre mis amigos..." 
                       value="<?php echo h($search_friends ?? ''); ?>" style="flex:1">
                <button type="submit" class="btn">
                    <i class="fas fa-search"></i> Buscar
                </button>
                <?php if (!empty($search_friends)): ?>
                    <a href="./?r=friends" class="btn error">
                        <i class="fas fa-times"></i> Limpiar
                    </a>
                <?php endif; ?>
            </form>
        </div>

        <!-- Solicitudes pendientes recibidas -->
        <?php if (!empty($requests_received)): ?>
        <div class="card" style="background:linear-gradient(135deg, rgba(77,255,136,0.1), rgba(124,209,255,0.1));margin-bottom:20px">
            <h3 style="margin:0 0 15px 0"><i class="fas fa-user-clock"></i> Solicitudes pendientes</h3>
            <div class="requests-list" style="display:flex;flex-direction:column;gap:12px">
                <?php foreach ($requests_received as $request): ?>
                <div style="display:flex;justify-content:space-between;align-items:center;padding:12px;background:var(--card);border-radius:8px">
                    <div style="display:flex;align-items:center;gap:10px">
                        <div class="user-badge" style="width:36px;height:36px" style="overflow:hidden;border-radius:50%;padding:0;background:none;"><?php echo avatar_img(isset($user['author_avatar_url'])?$user['author_avatar_url']:(isset($request['avatar_url'])?$request['avatar_url']:''), isset($request['username'])?$request['username']:'U', 36); ?></div>
                        <div>
                            <div>@<?php echo h($request['username']); ?></div>
                            <div class="muted" style="font-size:0.8rem">
                                <?php echo h(fdt_madrid($request['created_at'])); ?>
                            </div>
                        </div>
                    </div>
                    <div style="display:flex;gap:8px">
                        <form method="post" action="./?r=friends/accept&id=<?php echo h($request['id']); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn success sm">
                                <i class="fas fa-check"></i> Aceptar
                            </button>
                        </form>
                        <form method="post" action="./?r=friends/reject&id=<?php echo h($request['id']); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn error sm">
                                <i class="fas fa-times"></i> Rechazar
                            </button>
                        </form>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Solicitudes enviadas pendientes -->
        <?php if (!empty($requests_sent)): ?>
        <div class="card" style="background:linear-gradient(135deg, rgba(255,156,242,0.1), rgba(185,156,255,0.1));margin-bottom:20px">
            <h3 style="margin:0 0 15px 0"><i class="fas fa-paper-plane"></i> Solicitudes enviadas</h3>
            <div class="sent-requests" style="display:flex;flex-direction:column;gap:12px">
                <?php foreach ($requests_sent as $request): ?>
                <div style="display:flex;justify-content:space-between;align-items:center;padding:12px;background:var(--card);border-radius:8px">
                    <div style="display:flex;align-items:center;gap:10px">
                        <div class="user-badge" style="width:36px;height:36px" style="overflow:hidden;border-radius:50%;padding:0;background:none;"><?php echo avatar_img(isset($user['author_avatar_url'])?$user['author_avatar_url']:(isset($request['avatar_url'])?$request['avatar_url']:''), isset($request['username'])?$request['username']:'U', 36); ?></div>
                        <div>
                            <div>@<?php echo h($request['username']); ?></div>
                            <div class="muted" style="font-size:0.8rem">
                                <?php echo h(fdt_madrid($request['created_at'])); ?>
                            </div>
                        </div>
                    </div>
                    <span class="muted" style="font-size:0.9rem">Esperando respuesta...</span>
                </div>
                <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Lista de amigos -->
        <div class="card">
            <h3 style="margin:0 0 15px 0">
                <i class="fas fa-user-friends"></i> 
                <?php if (!empty($search_friends)): ?>
                Resultados de búsqueda (<?php echo count($filtered_friends); ?>)
                <?php else: ?>
                Mis amigos (<?php echo count($friends); ?>)
                <?php endif; ?>
            </h3>

            <?php if (empty($friends) && empty($filtered_friends)): ?>
            <div style="text-align:center;padding:40px 20px">
                <div style="font-size:3rem;color:var(--muted);margin-bottom:15px">
                    <i class="fas fa-user-friends"></i>
                </div>
                <h3 style="margin-bottom:10px">Aún no tienes amigos</h3>
                <p class="muted">Usa la búsqueda superior para encontrar y agregar amigos.</p>
            </div>
            <?php else: ?>
            <div class="friends-list" style="display:flex;flex-direction:column;gap:12px">
                <?php foreach ((!empty($search_friends) ? $filtered_friends : $friends) as $friend): ?>
                <div style="display:flex;justify-content:space-between;align-items:center;padding:12px;background:var(--card-hover);border-radius:8px;border:1px solid var(--border-light)">
                    <div style="display:flex;align-items:center;gap:10px;flex:1">
                        <div class="user-badge" style="width:40px;height:40px" style="overflow:hidden;border-radius:50%;padding:0;background:none;"><?php echo avatar_img(isset($user['author_avatar_url'])?$user['author_avatar_url']:(isset($friend['avatar_url'])?$friend['avatar_url'] : ''), isset($friend['username'])?$friend['username']:'U', 36); ?></div>
                        <div style="flex:1">
                            <a href="./?r=profile/friend&id=<?php echo h($friend['id']); ?>" class="username-link" style="font-size:1.1rem;font-weight:500">
                                @<?php echo h($friend['username']); ?>
                            </a>
                            <div class="muted" style="font-size:0.85rem">
                                Amigos desde <?php echo h(fdt_madrid($friend['created_at'] ?? 'now')); ?>
                            </div>
                        </div>
                    </div>
                    <div style="display:flex;gap:8px">
                        <a href="./?r=profile/friend&id=<?php echo h($friend['id']); ?>" class="btn sm">
                            <i class="fas fa-eye"></i> Ver perfil
                        </a>
                        <a href="./?r=reports/form&type=user&id=<?php echo h($friend['id']); ?>" class="btn sm" style="color:var(--error)">
                            <i class="fas fa-flag"></i> Reportar
                        </a>
                        <form method="post" action="./?r=friends/remove&id=<?php echo h($friend['id']); ?>" 
                              onsubmit="return confirm('¿Estás seguro de que quieres eliminar a @<?php echo h($friend['username']); ?> de tus amigos?');">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn error sm">
                                <i class="fas fa-user-times"></i> Eliminar
                            </button>
                        </form>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.btn.success {
    background: var(--success);
    color: white;
}

.btn.error {
    background: var(--error);
    color: white;
}

.btn.sm {
    padding: 6px 12px;
    font-size: 0.85rem;
}

.search-section {
    margin-bottom: 20px;
    padding: 16px;
    border-radius: 8px;
    background: linear-gradient(135deg, rgba(124,209,255,0.1), rgba(185,156,255,0.1));
}

.search-form {
    display: flex;
    gap: 10px;
    align-items: flex-end;
}

.search-input {
    flex: 1;
}

.search-results, .filtered-friends {
    margin-top: 15px;
    border-top: 1px solid var(--border-light);
    padding-top: 15px;
}

.user-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px;
    background: var(--card);
    border-radius: 8px;
    margin-bottom: 8px;
}

.user-info {
    display: flex;
    align-items: center;
    gap: 10px;
}

.user-badge {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background: linear-gradient(135deg, var(--accent), var(--accent2));
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
}

.no-results {
    text-align: center;
    padding: 20px;
    color: var(--muted);
}
</style>